/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Pattern;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.BibEntry;

public class SilverPlatterImporter
extends Importer {
    private static final Pattern START_PATTERN = Pattern.compile("Record.*INSPEC.*");

    @Override
    public String getName() {
        return "SilverPlatter";
    }

    @Override
    public StandardFileType getFileType() {
        return StandardFileType.SILVER_PLATTER;
    }

    @Override
    public String getDescription() {
        return "Imports a SilverPlatter exported file.";
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader reader) throws IOException {
        String str;
        while ((str = reader.readLine()) != null) {
            if (START_PATTERN.matcher(str).find()) {
                return false;
            }
            if (str.length() < 5 || !"TI:  ".equals(str.substring(0, 5))) continue;
            return true;
        }
        return false;
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        String str;
        ArrayList<BibEntry> bibitems = new ArrayList<BibEntry>();
        boolean isChapter = false;
        StringBuilder sb = new StringBuilder();
        while ((str = reader.readLine()) != null) {
            if (str.length() < 2) {
                sb.append("__::__").append(str);
                continue;
            }
            sb.append("__NEWFIELD__").append(str);
        }
        String[] entries = sb.toString().split("__::__");
        String type = "";
        HashMap<String, String> h2 = new HashMap<String, String>();
        for (String entry : entries) {
            String title;
            int inPos;
            String titleO;
            String[] fields;
            if (entry.trim().length() < 6) continue;
            h2.clear();
            for (String field2 : fields = entry.split("__NEWFIELD__")) {
                String yr;
                String jr;
                if (field2.length() < 6) continue;
                String f3 = field2.substring(0, 2);
                String frest = field2.substring(5);
                if ("TI".equals(f3)) {
                    h2.put("title", frest);
                    continue;
                }
                if ("AU".equals(f3)) {
                    if (frest.trim().endsWith("(ed)")) {
                        String ed = frest.trim();
                        ed = ed.substring(0, ed.length() - 4);
                        h2.put("editor", AuthorList.fixAuthorLastNameFirst(ed.replace(",-", ", ").replace(";", " and ")));
                        continue;
                    }
                    h2.put("author", AuthorList.fixAuthorLastNameFirst(frest.replace(",-", ", ").replace(";", " and ")));
                    continue;
                }
                if ("AB".equals(f3)) {
                    h2.put("abstract", frest);
                    continue;
                }
                if ("DE".equals(f3)) {
                    String kw = frest.replace("-;", ",").toLowerCase(Locale.ROOT);
                    h2.put("keywords", kw.substring(0, kw.length() - 1));
                    continue;
                }
                if ("SO".equals(f3)) {
                    int m3 = frest.indexOf(46);
                    if (m3 < 0) continue;
                    jr = frest.substring(0, m3);
                    h2.put("journal", jr.replace("-", " "));
                    frest = frest.substring(m3);
                    m3 = frest.indexOf(59);
                    if (m3 < 5) continue;
                    yr = frest.substring(m3 - 5, m3).trim();
                    h2.put("year", yr);
                    frest = frest.substring(m3);
                    m3 = frest.indexOf(58);
                    int issueIndex = frest.indexOf(40);
                    int endIssueIndex = frest.indexOf(41);
                    if (m3 < 0) continue;
                    String pg = frest.substring(m3 + 1).trim();
                    h2.put("pages", pg);
                    h2.put("volume", frest.substring(1, issueIndex).trim());
                    h2.put("issue", frest.substring(issueIndex + 1, endIssueIndex).trim());
                    continue;
                }
                if ("PB".equals(f3)) {
                    int m4 = frest.indexOf(58);
                    if (m4 < 0) continue;
                    jr = frest.substring(0, m4);
                    h2.put("publisher", jr.replace("-", " ").trim());
                    frest = frest.substring(m4);
                    m4 = frest.indexOf(", ");
                    if (m4 + 2 >= frest.length()) continue;
                    yr = frest.substring(m4 + 2).trim();
                    try {
                        Integer.parseInt(yr);
                        h2.put("year", yr);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if ("AF".equals(f3)) {
                    h2.put("school", frest.trim());
                    continue;
                }
                if (!"DT".equals(f3)) continue;
                if ("Monograph".equals(frest = frest.trim())) {
                    type = "book";
                    continue;
                }
                if (frest.startsWith("Dissertation")) {
                    type = "phdthesis";
                    continue;
                }
                if (frest.toLowerCase(Locale.ROOT).contains("journal")) {
                    type = "article";
                    continue;
                }
                if ("Contribution".equals(frest) || "Chapter".equals(frest)) {
                    type = "incollection";
                    isChapter = true;
                    continue;
                }
                type = frest.replace(" ", "");
            }
            if (isChapter && (titleO = (String)h2.get("title")) != null && (inPos = (title = titleO.trim()).indexOf("\" in ")) > 1) {
                h2.put("title", title.substring(0, inPos));
            }
            BibEntry b = new BibEntry(type);
            b.setField(h2);
            bibitems.add(b);
        }
        return new ParserResult(bibitems);
    }
}

