/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.http.client.utils.URIBuilder;
import org.jabref.logic.formatter.bibtexfields.ClearFormatter;
import org.jabref.logic.formatter.bibtexfields.RemoveBracesFormatter;
import org.jabref.logic.importer.EntryBasedParserFetcher;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.IdBasedParserFetcher;
import org.jabref.logic.importer.IdParserFetcher;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.Parser;
import org.jabref.logic.importer.SearchBasedParserFetcher;
import org.jabref.logic.importer.util.JsonReader;
import org.jabref.logic.util.strings.StringSimilarity;
import org.jabref.model.cleanup.FieldFormatterCleanup;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BiblatexEntryTypes;
import org.jabref.model.entry.EntryType;
import org.jabref.model.entry.identifier.DOI;
import org.jabref.model.util.OptionalUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CrossRef
implements IdParserFetcher<DOI>,
EntryBasedParserFetcher,
SearchBasedParserFetcher,
IdBasedParserFetcher {
    private static final String API_URL = "https://api.crossref.org/works";
    private static final RemoveBracesFormatter REMOVE_BRACES_FORMATTER = new RemoveBracesFormatter();

    @Override
    public String getName() {
        return "Crossref";
    }

    @Override
    public URL getURLForEntry(BibEntry entry) throws URISyntaxException, MalformedURLException, FetcherException {
        URIBuilder uriBuilder = new URIBuilder(API_URL);
        entry.getLatexFreeField("title").ifPresent(title -> uriBuilder.addParameter("query.title", (String)title));
        entry.getLatexFreeField("author").ifPresent(author -> uriBuilder.addParameter("query.author", (String)author));
        entry.getLatexFreeField("year").ifPresent(year -> uriBuilder.addParameter("filter", "from-pub-date:" + year));
        uriBuilder.addParameter("rows", "20");
        uriBuilder.addParameter("offset", "0");
        return uriBuilder.build().toURL();
    }

    @Override
    public URL getURLForQuery(String query) throws URISyntaxException, MalformedURLException, FetcherException {
        URIBuilder uriBuilder = new URIBuilder(API_URL);
        uriBuilder.addParameter("query", query);
        return uriBuilder.build().toURL();
    }

    @Override
    public URL getURLForID(String identifier) throws URISyntaxException, MalformedURLException, FetcherException {
        URIBuilder uriBuilder = new URIBuilder("https://api.crossref.org/works/" + identifier);
        return uriBuilder.build().toURL();
    }

    @Override
    public Parser getParser() {
        return inputStream -> {
            JSONObject response = JsonReader.toJsonObject(inputStream).getJSONObject("message");
            ArrayList<BibEntry> entries = new ArrayList<BibEntry>();
            if (response.has("items")) {
                JSONArray items = response.getJSONArray("items");
                for (int i = 0; i < items.length(); ++i) {
                    JSONObject item = items.getJSONObject(i);
                    BibEntry entry = this.jsonItemToBibEntry(item);
                    entries.add(entry);
                }
            } else {
                BibEntry entry = this.jsonItemToBibEntry(response);
                entries.add(entry);
            }
            return entries;
        };
    }

    @Override
    public void doPostCleanup(BibEntry entry) {
        if (entry.getField("title").equals(entry.getField("subtitle"))) {
            new FieldFormatterCleanup("subtitle", new ClearFormatter()).cleanup(entry);
        }
    }

    private BibEntry jsonItemToBibEntry(JSONObject item) throws ParseException {
        try {
            BibEntry entry = new BibEntry();
            entry.setType(this.convertType(item.getString("type")));
            entry.setField("title", Optional.ofNullable(item.optJSONArray("title")).map(array -> array.optString(0)).orElse(""));
            entry.setField("subtitle", Optional.ofNullable(item.optJSONArray("subtitle")).map(array -> array.optString(0)).orElse(""));
            entry.setField("author", this.toAuthors(item.optJSONArray("author")));
            entry.setField("year", Optional.ofNullable(item.optJSONObject("published-print")).map(array -> array.optJSONArray("date-parts")).map(array -> array.optJSONArray(0)).map(array -> array.optInt(0)).map(year -> Integer.toString(year)).orElse(""));
            entry.setField("doi", item.getString("DOI"));
            entry.setField("pages", item.optString("page"));
            entry.setField("volume", item.optString("volume"));
            entry.setField("issn", Optional.ofNullable(item.optJSONArray("ISSN")).map(array -> array.getString(0)).orElse(""));
            return entry;
        }
        catch (JSONException exception) {
            throw new ParseException("CrossRef API JSON format has changed", exception);
        }
    }

    private String toAuthors(JSONArray authors) {
        if (authors == null) {
            return "";
        }
        AuthorList authorsParsed = new AuthorList();
        for (int i = 0; i < authors.length(); ++i) {
            JSONObject author = authors.getJSONObject(i);
            authorsParsed.addAuthor(author.optString("given", ""), "", "", author.optString("family", ""), "");
        }
        return authorsParsed.getAsFirstLastNamesWithAnd();
    }

    private EntryType convertType(String type) {
        switch (type) {
            case "journal-article": {
                return BiblatexEntryTypes.ARTICLE;
            }
        }
        return BiblatexEntryTypes.MISC;
    }

    @Override
    public Optional<DOI> extractIdentifier(BibEntry inputEntry, List<BibEntry> fetchedEntries) throws FetcherException {
        String entryTitle = REMOVE_BRACES_FORMATTER.format(inputEntry.getLatexFreeField("title").orElse(""));
        StringSimilarity stringSimilarity = new StringSimilarity();
        for (BibEntry fetchedEntry : fetchedEntries) {
            Optional<String> dataTitle = fetchedEntry.getField("title");
            if (OptionalUtil.isPresentAnd(dataTitle, title -> stringSimilarity.isSimilar(entryTitle, (String)title)).booleanValue()) {
                return fetchedEntry.getDOI();
            }
            Optional<String> dataSubtitle = fetchedEntry.getField("subtitle");
            Optional<String> dataWithSubTitle = OptionalUtil.combine(dataTitle, dataSubtitle, (title, subtitle) -> title + " " + subtitle);
            if (!OptionalUtil.isPresentAnd(dataWithSubTitle, titleWithSubtitle -> stringSimilarity.isSimilar(entryTitle, (String)titleWithSubtitle)).booleanValue()) continue;
            return fetchedEntry.getDOI();
        }
        return Optional.empty();
    }

    @Override
    public String getIdentifierName() {
        return "DOI";
    }
}

