/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bibtexkeypattern;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.logic.formatter.Formatters;
import org.jabref.logic.formatter.casechanger.Word;
import org.jabref.logic.layout.format.RemoveLatexCommandsFormatter;
import org.jabref.model.cleanup.Formatter;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.Keyword;
import org.jabref.model.entry.KeywordList;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BracketedPattern {
    private static final Logger LOGGER = LoggerFactory.getLogger(BracketedPattern.class);
    private static final String STARTING_CAPITAL_PATTERN = "[^A-Z]";
    private static final int CHARS_OF_FIRST = 5;
    private static final Pattern REGEX_PATTERN = Pattern.compile(".*\\(\\{([A-Z]+)\\}\\).*");
    private final String pattern;

    public BracketedPattern() {
        this.pattern = null;
    }

    public BracketedPattern(String pattern) {
        this.pattern = pattern;
    }

    public String toString() {
        return this.getClass().getName() + "[pattern=" + this.pattern + "]";
    }

    public String expand(BibEntry bibentry) {
        BibDatabase null_database = null;
        return this.expand(bibentry, null_database);
    }

    public String expand(BibEntry bibentry, BibDatabase database) {
        Objects.requireNonNull(bibentry);
        Character keywordDelimiter = Character.valueOf(';');
        return this.expand(bibentry, keywordDelimiter, database);
    }

    public String expand(BibEntry bibentry, Character keywordDelimiter, BibDatabase database) {
        Objects.requireNonNull(bibentry);
        return BracketedPattern.expandBrackets(this.pattern, keywordDelimiter, bibentry, database);
    }

    public static String expandBrackets(String pattern, Character keywordDelimiter, BibEntry entry, BibDatabase database) {
        Objects.requireNonNull(pattern);
        Objects.requireNonNull(entry);
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(pattern, "\\[]", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ("\\".equals(token)) {
                if (!st.hasMoreTokens()) continue;
                sb.append(st.nextToken());
                continue;
            }
            if ("[".equals(token)) {
                token = st.nextToken();
                List<String> fieldParts = BracketedPattern.parseFieldMarker(token);
                if (fieldParts.size() <= 1) {
                    sb.append(BracketedPattern.getFieldValue(entry, token, keywordDelimiter, database));
                } else {
                    String fieldValue = BracketedPattern.getFieldValue(entry, fieldParts.get(0), keywordDelimiter, database);
                    sb.append(BracketedPattern.applyModifiers(fieldValue, fieldParts, 1));
                }
                if ("]".equals(token = st.hasMoreTokens() ? st.nextToken() : "")) continue;
                LOGGER.warn("Missing closing bracket ']' in '" + pattern + "'");
                continue;
            }
            sb.append(token);
        }
        return sb.toString();
    }

    public static String getFieldValue(BibEntry entry, String value, Character keywordDelimiter, BibDatabase database) {
        String val = value;
        try {
            if (val.startsWith("auth") || val.startsWith("pureauth")) {
                String authString = database != null ? entry.getResolvedFieldOrAlias("author", database).map(authorString -> BracketedPattern.normalize(database.resolveForStrings((String)authorString))).orElse("") : entry.getResolvedFieldOrAlias("author", database).orElse("");
                if (val.startsWith("pure")) {
                    val = val.substring(4);
                } else if (authString.isEmpty()) {
                    authString = database != null ? entry.getResolvedFieldOrAlias("editor", database).map(authorString -> BracketedPattern.normalize(database.resolveForStrings((String)authorString))).orElse("") : entry.getResolvedFieldOrAlias("editor", database).orElse("");
                }
                if ("auth".equals(val)) {
                    return BracketedPattern.firstAuthor(authString);
                }
                if ("authForeIni".equals(val)) {
                    return BracketedPattern.firstAuthorForenameInitials(authString);
                }
                if ("authFirstFull".equals(val)) {
                    return BracketedPattern.firstAuthorVonAndLast(authString);
                }
                if ("authors".equals(val)) {
                    return BracketedPattern.allAuthors(authString);
                }
                if ("authorsAlpha".equals(val)) {
                    return BracketedPattern.authorsAlpha(authString);
                }
                if ("authorLast".equals(val)) {
                    return BracketedPattern.lastAuthor(authString);
                }
                if ("authorLastForeIni".equals(val)) {
                    return BracketedPattern.lastAuthorForenameInitials(authString);
                }
                if ("authorIni".equals(val)) {
                    return BracketedPattern.oneAuthorPlusIni(authString);
                }
                if (val.matches("authIni[\\d]+")) {
                    int num = Integer.parseInt(val.substring(7));
                    return BracketedPattern.authIniN(authString, num);
                }
                if ("auth.auth.ea".equals(val)) {
                    return BracketedPattern.authAuthEa(authString);
                }
                if ("auth.etal".equals(val)) {
                    return BracketedPattern.authEtal(authString, ".", ".etal");
                }
                if ("authEtAl".equals(val)) {
                    return BracketedPattern.authEtal(authString, "", "EtAl");
                }
                if ("authshort".equals(val)) {
                    return BracketedPattern.authshort(authString);
                }
                if (val.matches("auth[\\d]+_[\\d]+")) {
                    String[] nums = val.substring(4).split("_");
                    return BracketedPattern.authNofMth(authString, Integer.parseInt(nums[0]), Integer.parseInt(nums[1]));
                }
                if (val.matches("auth\\d+")) {
                    String fa = BracketedPattern.firstAuthor(authString);
                    int num = Integer.parseInt(val.substring(4));
                    if (num > fa.length()) {
                        num = fa.length();
                    }
                    return fa.substring(0, num);
                }
                if (val.matches("authors\\d+")) {
                    return BracketedPattern.nAuthors(authString, Integer.parseInt(val.substring(7)));
                }
                return entry.getResolvedFieldOrAlias(val, database).orElse("");
            }
            if (val.startsWith("ed")) {
                if ("edtr".equals(val)) {
                    return BracketedPattern.firstAuthor(entry.getResolvedFieldOrAlias("editor", database).orElse(""));
                }
                if ("edtrForeIni".equals(val)) {
                    return BracketedPattern.firstAuthorForenameInitials(entry.getResolvedFieldOrAlias("editor", database).orElse(""));
                }
                if ("editors".equals(val)) {
                    return BracketedPattern.allAuthors(entry.getResolvedFieldOrAlias("editor", database).orElse(""));
                }
                if ("editorLast".equals(val)) {
                    return BracketedPattern.lastAuthor(entry.getResolvedFieldOrAlias("editor", database).orElse(""));
                }
                if ("editorLastForeIni".equals(val)) {
                    return BracketedPattern.lastAuthorForenameInitials(entry.getResolvedFieldOrAlias("editor", database).orElse(""));
                }
                if ("editorIni".equals(val)) {
                    return BracketedPattern.oneAuthorPlusIni(entry.getResolvedFieldOrAlias("editor", database).orElse(""));
                }
                if (val.matches("edtrIni[\\d]+")) {
                    int num = Integer.parseInt(val.substring(7));
                    return BracketedPattern.authIniN(entry.getResolvedFieldOrAlias("editor", database).orElse(""), num);
                }
                if (val.matches("edtr[\\d]+_[\\d]+")) {
                    String[] nums = val.substring(4).split("_");
                    return BracketedPattern.authNofMth(entry.getResolvedFieldOrAlias("editor", database).orElse(""), Integer.parseInt(nums[0]), Integer.parseInt(nums[1]) - 1);
                }
                if ("edtr.edtr.ea".equals(val)) {
                    return BracketedPattern.authAuthEa(entry.getResolvedFieldOrAlias("editor", database).orElse(""));
                }
                if ("edtrshort".equals(val)) {
                    return BracketedPattern.authshort(entry.getResolvedFieldOrAlias("editor", database).orElse(""));
                }
                if (val.matches("edtr\\d+")) {
                    String fa = BracketedPattern.firstAuthor(entry.getResolvedFieldOrAlias("editor", database).orElse(""));
                    int num = Integer.parseInt(val.substring(4));
                    if (num > fa.length()) {
                        num = fa.length();
                    }
                    return fa.substring(0, num);
                }
                return entry.getResolvedFieldOrAlias(val, database).orElse("");
            }
            if ("firstpage".equals(val)) {
                return BracketedPattern.firstPage(entry.getResolvedFieldOrAlias("pages", database).orElse(""));
            }
            if ("pageprefix".equals(val)) {
                return BracketedPattern.pagePrefix(entry.getResolvedFieldOrAlias("pages", database).orElse(""));
            }
            if ("lastpage".equals(val)) {
                return BracketedPattern.lastPage(entry.getResolvedFieldOrAlias("pages", database).orElse(""));
            }
            if ("title".equals(val)) {
                return BracketedPattern.camelizeSignificantWordsInTitle(entry.getResolvedFieldOrAlias("title", database).orElse(""));
            }
            if ("fulltitle".equals(val)) {
                return entry.getResolvedFieldOrAlias("title", database).orElse("");
            }
            if ("shorttitle".equals(val)) {
                return BracketedPattern.getTitleWords(3, BracketedPattern.removeSmallWords(entry.getResolvedFieldOrAlias("title", database).orElse("")));
            }
            if ("shorttitleINI".equals(val)) {
                return BracketedPattern.keepLettersAndDigitsOnly(BracketedPattern.applyModifiers(BracketedPattern.getTitleWordsWithSpaces(3, entry.getResolvedFieldOrAlias("title", database).orElse("")), Collections.singletonList("abbr"), 0));
            }
            if ("veryshorttitle".equals(val)) {
                return BracketedPattern.getTitleWords(1, BracketedPattern.removeSmallWords(entry.getResolvedFieldOrAlias("title", database).orElse("")));
            }
            if ("camel".equals(val)) {
                return BracketedPattern.getCamelizedTitle(entry.getResolvedFieldOrAlias("title", database).orElse(""));
            }
            if ("shortyear".equals(val)) {
                String yearString = entry.getResolvedFieldOrAlias("year", database).orElse("");
                if (yearString.isEmpty()) {
                    return yearString;
                }
                if (yearString.startsWith("in") || yearString.startsWith("sub")) {
                    return "IP";
                }
                if (yearString.length() > 2) {
                    return yearString.substring(yearString.length() - 2);
                }
                return yearString;
            }
            if ("entrytype".equals(val)) {
                return entry.getResolvedFieldOrAlias("entrytype", database).orElse("");
            }
            if (val.matches("keyword\\d+")) {
                int num = Integer.parseInt(val.substring(7));
                KeywordList separatedKeywords = entry.getResolvedKeywords(keywordDelimiter, database);
                if (separatedKeywords.size() < num) {
                    return "";
                }
                return separatedKeywords.get(num - 1).toString();
            }
            if (val.matches("keywords\\d*")) {
                int num = val.length() > 8 ? Integer.parseInt(val.substring(8)) : Integer.MAX_VALUE;
                KeywordList separatedKeywords = entry.getResolvedKeywords(keywordDelimiter, database);
                StringBuilder sb = new StringBuilder();
                int i = 0;
                for (Keyword keyword : separatedKeywords) {
                    sb.append(keyword.toString().replaceAll("\\s+", ""));
                    if (++i < num) continue;
                    break;
                }
                return sb.toString();
            }
            return entry.getResolvedFieldOrAlias(val, database).orElse("");
        }
        catch (NullPointerException ex) {
            LOGGER.debug("Problem making expanding bracketed expression", ex);
            return "";
        }
    }

    static String applyModifiers(String label, List<String> parts, int offset) {
        String resultingLabel = label;
        for (int j = offset; j < parts.size(); ++j) {
            String modifier = parts.get(j);
            if ("abbr".equals(modifier)) {
                String[] words;
                StringBuilder abbreviateSB = new StringBuilder();
                for (String word : words = resultingLabel.replaceAll("[\\{\\}']", "").split("[\\(\\) \r\n\"]")) {
                    if (word.isEmpty()) continue;
                    abbreviateSB.append(word.charAt(0));
                }
                resultingLabel = abbreviateSB.toString();
                continue;
            }
            Optional<Formatter> formatter = Formatters.getFormatterForModifier(modifier);
            if (formatter.isPresent()) {
                resultingLabel = formatter.get().format(resultingLabel);
                continue;
            }
            if (!modifier.isEmpty() && modifier.length() >= 2 && modifier.charAt(0) == '(' && modifier.endsWith(")")) {
                if (!label.isEmpty() || modifier.length() <= 2) continue;
                resultingLabel = modifier.substring(1, modifier.length() - 1);
                continue;
            }
            LOGGER.warn("Key generator warning: unknown modifier '" + modifier + "'.");
        }
        return resultingLabel;
    }

    public static String getTitleWords(int number, String title) {
        return BracketedPattern.getTitleWordsWithSpaces(number, title);
    }

    private static String formatTitle(String title) {
        String ss = new RemoveLatexCommandsFormatter().format(title);
        StringBuilder stringBuilder = new StringBuilder();
        int piv = 0;
        while (piv < ss.length()) {
            StringBuilder current = new StringBuilder();
            while (piv < ss.length() && !Character.isWhitespace(ss.charAt(piv)) && ss.charAt(piv) != '-') {
                current.append(ss.charAt(piv));
                ++piv;
            }
            ++piv;
            String word = current.toString().trim();
            if (word.isEmpty()) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(word);
        }
        return stringBuilder.toString();
    }

    public static String getCamelizedTitle(String title) {
        return BracketedPattern.keepLettersAndDigitsOnly(BracketedPattern.camelizeTitle(title));
    }

    private static String camelizeTitle(String title) {
        StringBuilder stringBuilder = new StringBuilder();
        String formattedTitle = BracketedPattern.formatTitle(title);
        try (Scanner titleScanner = new Scanner(formattedTitle);){
            while (titleScanner.hasNext()) {
                String word = titleScanner.next();
                word = word.substring(0, 1).toUpperCase(Locale.ROOT) + word.substring(1);
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(word);
            }
        }
        return stringBuilder.toString();
    }

    public static String camelizeSignificantWordsInTitle(String title) {
        StringJoiner stringJoiner = new StringJoiner(" ");
        String formattedTitle = BracketedPattern.formatTitle(title);
        try (Scanner titleScanner = new Scanner(formattedTitle);){
            while (titleScanner.hasNext()) {
                String word = titleScanner.next();
                Boolean camelize = true;
                for (String smallWord : Word.SMALLER_WORDS) {
                    if (!word.equalsIgnoreCase(smallWord)) continue;
                    camelize = false;
                }
                word = camelize != false || stringJoiner.length() == 0 ? word.substring(0, 1).toUpperCase(Locale.ROOT) + word.substring(1) : word.substring(0, 1).toLowerCase(Locale.ROOT) + word.substring(1);
                stringJoiner.add(word);
            }
        }
        return stringJoiner.toString();
    }

    public static String removeSmallWords(String title) {
        StringJoiner stringJoiner = new StringJoiner(" ");
        String formattedTitle = BracketedPattern.formatTitle(title);
        try (Scanner titleScanner = new Scanner(formattedTitle);){
            block5: while (titleScanner.hasNext()) {
                String word = titleScanner.next();
                for (String smallWord : Word.SMALLER_WORDS) {
                    if (!word.equalsIgnoreCase(smallWord)) continue;
                    continue block5;
                }
                stringJoiner.add(word);
            }
        }
        return stringJoiner.toString();
    }

    private static String getTitleWordsWithSpaces(int number, String title) {
        StringJoiner stringJoiner = new StringJoiner(" ");
        String formattedTitle = BracketedPattern.formatTitle(title);
        try (Scanner titleScanner = new Scanner(formattedTitle);){
            for (int words = 0; titleScanner.hasNext() && words < number; ++words) {
                String word = titleScanner.next();
                stringJoiner.add(word);
            }
        }
        return stringJoiner.toString();
    }

    private static String keepLettersAndDigitsOnly(String in) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < in.length(); ++i) {
            if (!Character.isLetterOrDigit(in.charAt(i))) continue;
            stringBuilder.append(in.charAt(i));
        }
        return stringBuilder.toString();
    }

    public static String firstAuthor(String authorField) {
        AuthorList authorList = AuthorList.parse(authorField);
        if (authorList.isEmpty()) {
            return "";
        }
        return authorList.getAuthor(0).getLast().orElse("");
    }

    public static String firstAuthorForenameInitials(String authorField) {
        AuthorList authorList = AuthorList.parse(authorField);
        if (authorList.isEmpty()) {
            return "";
        }
        return authorList.getAuthor(0).getFirstAbbr().map(s2 -> s2.substring(0, 1)).orElse("");
    }

    public static String firstAuthorVonAndLast(String authorField) {
        AuthorList authorList = AuthorList.parse(authorField);
        if (authorList.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        authorList.getAuthor(0).getVon().ifPresent(vonAuthor -> stringBuilder.append(vonAuthor.replaceAll(" ", "")));
        authorList.getAuthor(0).getLast().ifPresent(stringBuilder::append);
        return stringBuilder.toString();
    }

    public static String lastAuthor(String authorField) {
        String[] tokens = AuthorList.fixAuthorForAlphabetization(authorField).split("\\s+\\band\\b\\s+");
        if (tokens.length > 0) {
            String[] lastAuthor = tokens[tokens.length - 1].split(",");
            return lastAuthor[0];
        }
        return "";
    }

    public static String lastAuthorForenameInitials(String authorField) {
        AuthorList authorList = AuthorList.parse(authorField);
        if (authorList.isEmpty()) {
            return "";
        }
        return authorList.getAuthor(authorList.getNumberOfAuthors() - 1).getFirstAbbr().map(s2 -> s2.substring(0, 1)).orElse("");
    }

    public static String allAuthors(String authorField) {
        return BracketedPattern.nAuthors(authorField, Integer.MAX_VALUE);
    }

    public static String authorsAlpha(String authorField) {
        int max;
        String authors = "";
        String fixedAuthors = AuthorList.fixAuthorLastNameOnlyCommas(authorField, false);
        String[] tokens = (fixedAuthors = fixedAuthors.replace(" and ", ", ")).split(",");
        int n = max = tokens.length > 4 ? 3 : tokens.length;
        if (max == 1) {
            String[] firstAuthor = tokens[0].replaceAll("\\s+", " ").trim().split(" ");
            for (int j = 0; j < firstAuthor.length - 1; ++j) {
                authors = authors.concat(firstAuthor[j].substring(0, 1));
            }
            authors = authors.concat(firstAuthor[firstAuthor.length - 1].substring(0, Math.min(3, firstAuthor[firstAuthor.length - 1].length())));
        } else {
            for (int i = 0; i < max; ++i) {
                String[] curAuthor;
                for (String aCurAuthor : curAuthor = tokens[i].replaceAll("\\s+", " ").trim().split(" ")) {
                    authors = authors.concat(aCurAuthor.substring(0, 1));
                }
            }
            if (tokens.length > 4) {
                authors = authors.concat("+");
            }
        }
        return authors;
    }

    public static String nAuthors(String authorField, int n) {
        String[] tokens = AuthorList.fixAuthorForAlphabetization(authorField).split("\\s+\\band\\b\\s+");
        StringBuilder authorSB = new StringBuilder();
        for (int i = 0; tokens.length > i && i < n; ++i) {
            String lastName = tokens[i].replaceAll(",\\s+.*", "");
            authorSB.append(lastName);
        }
        if (tokens.length > n) {
            authorSB.append("EtAl");
        }
        return authorSB.toString();
    }

    public static String oneAuthorPlusIni(String authorField) {
        String fixedAuthorField = AuthorList.fixAuthorForAlphabetization(authorField);
        String[] tokens = fixedAuthorField.split("\\s+\\band\\b\\s+");
        if (tokens.length == 0) {
            return "";
        }
        String firstAuthor = tokens[0].split(",")[0];
        StringBuilder authorSB = new StringBuilder();
        authorSB.append(firstAuthor.substring(0, Math.min(5, firstAuthor.length())));
        for (int i = 1; tokens.length > i; ++i) {
            authorSB.append(tokens[i].charAt(0));
        }
        return authorSB.toString();
    }

    public static String authAuthEa(String authorField) {
        String fixedAuthorField = AuthorList.fixAuthorForAlphabetization(authorField);
        String[] tokens = fixedAuthorField.split("\\s+\\band\\b\\s+");
        if (tokens.length == 0) {
            return "";
        }
        StringBuilder author = new StringBuilder();
        author.append(tokens[0].split(",")[0]);
        if (tokens.length >= 2) {
            author.append('.').append(tokens[1].split(",")[0]);
        }
        if (tokens.length > 2) {
            author.append(".ea");
        }
        return author.toString();
    }

    public static String authEtal(String authorField, String delim, String append) {
        String fixedAuthorField = AuthorList.fixAuthorForAlphabetization(authorField);
        String[] tokens = fixedAuthorField.split("\\s*\\band\\b\\s*");
        if (tokens.length == 0) {
            return "";
        }
        StringBuilder author = new StringBuilder();
        author.append(tokens[0].split(",")[0]);
        if (tokens.length == 2) {
            author.append(delim).append(tokens[1].split(",")[0]);
        } else if (tokens.length > 2) {
            author.append(append);
        }
        return author.toString();
    }

    public static String authNofMth(String authorField, int n, int m3) {
        int mminusone = m3 - 1;
        String fixedAuthorField = AuthorList.fixAuthorForAlphabetization(authorField);
        String[] tokens = fixedAuthorField.split("\\s+\\band\\b\\s+");
        if (tokens.length <= mminusone || n < 0 || mminusone < 0) {
            return "";
        }
        String lastName = tokens[mminusone].split(",")[0];
        if (lastName.length() <= n) {
            return lastName;
        }
        return lastName.substring(0, n);
    }

    public static String authshort(String authorField) {
        String fixedAuthorField = AuthorList.fixAuthorForAlphabetization(authorField);
        StringBuilder author = new StringBuilder();
        String[] tokens = fixedAuthorField.split("\\band\\b");
        if (tokens.length == 1) {
            author.append(BracketedPattern.authNofMth(fixedAuthorField, fixedAuthorField.length(), 1));
        } else if (tokens.length >= 2) {
            for (int i = 0; tokens.length > i && i < 3; ++i) {
                author.append(BracketedPattern.authNofMth(fixedAuthorField, 1, i + 1));
            }
            if (tokens.length > 3) {
                author.append('+');
            }
        }
        return author.toString();
    }

    public static String authIniN(String authorField, int n) {
        if (n <= 0) {
            return "";
        }
        String fixedAuthorField = AuthorList.fixAuthorForAlphabetization(authorField);
        StringBuilder author = new StringBuilder();
        String[] tokens = fixedAuthorField.split("\\band\\b");
        if (tokens.length == 0) {
            return author.toString();
        }
        int charsAll = n / tokens.length;
        for (int i = 0; tokens.length > i; ++i) {
            if (i < n % tokens.length) {
                author.append(BracketedPattern.authNofMth(fixedAuthorField, charsAll + 1, i + 1));
                continue;
            }
            author.append(BracketedPattern.authNofMth(fixedAuthorField, charsAll, i + 1));
        }
        if (author.length() <= n) {
            return author.toString();
        }
        return author.toString().substring(0, n);
    }

    public static String firstPage(String pages) {
        String[] splitPages = pages.split("\\D+");
        int result = Integer.MAX_VALUE;
        for (String n : splitPages) {
            if (!n.matches("\\d+")) continue;
            result = Math.min(Integer.parseInt(n), result);
        }
        if (result == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(result);
    }

    public static String pagePrefix(String pages) {
        if (pages.matches("^\\D+.*$")) {
            return pages.split("\\d+")[0];
        }
        return "";
    }

    public static String lastPage(String pages) {
        String[] splitPages = pages.split("\\D+");
        int result = Integer.MIN_VALUE;
        for (String n : splitPages) {
            if (!n.matches("\\d+")) continue;
            result = Math.max(Integer.parseInt(n), result);
        }
        if (result == Integer.MIN_VALUE) {
            return "";
        }
        return String.valueOf(result);
    }

    protected static List<String> parseFieldMarker(String arg) {
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean escaped = false;
        int inParenthesis = 0;
        for (int i = 0; i < arg.length(); ++i) {
            char currentChar = arg.charAt(i);
            if (currentChar == ':' && !escaped && inParenthesis == 0) {
                parts.add(current.toString());
                current = new StringBuilder();
                continue;
            }
            if (currentChar == '(' && !escaped) {
                ++inParenthesis;
                current.append(currentChar);
                continue;
            }
            if (currentChar == ')' && !escaped && inParenthesis > 0) {
                --inParenthesis;
                current.append(currentChar);
                continue;
            }
            if (currentChar == '\\') {
                if (escaped) {
                    escaped = false;
                    current.append(currentChar);
                    continue;
                }
                escaped = true;
                continue;
            }
            if (escaped) {
                current.append(currentChar);
                escaped = false;
                continue;
            }
            current.append(currentChar);
        }
        parts.add(current.toString());
        return parts;
    }

    private static String normalize(String content) {
        ArrayList<String> tokens = new ArrayList<String>();
        int b = 0;
        StringBuilder and = new StringBuilder();
        StringBuilder token = new StringBuilder();
        for (int p = 0; p < content.length(); ++p) {
            if (b == 0) {
                String andString = and.toString();
                if (andString.isEmpty() && content.charAt(p) == ' ' || " ".equals(andString) && content.charAt(p) == 'a' || " a".equals(andString) && content.charAt(p) == 'n' || " an".equals(andString) && content.charAt(p) == 'd') {
                    and.append(content.charAt(p));
                    continue;
                }
                if (" and".equals(and.toString()) && content.charAt(p) == ' ') {
                    and = new StringBuilder();
                    tokens.add(token.toString().trim());
                    token = new StringBuilder();
                    continue;
                }
                if (content.charAt(p) == '{') {
                    ++b;
                }
                if (content.charAt(p) == '}') {
                    --b;
                }
                token.append((CharSequence)and);
                and = new StringBuilder();
                token.append(content.charAt(p));
                continue;
            }
            token.append(content.charAt(p));
        }
        tokens.add(token.toString());
        StringBuilder normalized = new StringBuilder("");
        for (int i = 0; i < tokens.size(); ++i) {
            if (i > 0) {
                normalized.append(" and ");
            }
            normalized.append(BracketedPattern.isInstitution((String)tokens.get(i)) ? BracketedPattern.generateInstitutionKey((String)tokens.get(i)) : BracketedPattern.removeDiacritics((String)tokens.get(i)));
        }
        return normalized.toString();
    }

    private static String removeDiacritics(String content) {
        if (content.isEmpty()) {
            return content;
        }
        String result = content;
        result = result.replaceAll("\\{\\\\\"([a-zA-Z])\\}", "$1e");
        result = result.replaceAll("\\\\\"\\{([a-zA-Z])\\}", "$1e");
        result = result.replaceAll("\\\\\"([a-zA-Z])", "$1e");
        result = result.replaceAll("\\{\\\\.([a-zA-Z])\\}", "$1");
        result = result.replaceAll("\\\\.\\{([a-zA-Z])\\}", "$1");
        result = result.replaceAll("\\\\.([a-zA-Z])", "$1");
        return result;
    }

    private static String unifyDiacritics(String content) {
        return content.replaceAll("\\$\\\\ddot\\{\\\\mathrm\\{([^\\}])\\}\\}\\$", "{\\\"$1}").replaceAll("(\\\\[^\\-a-zA-Z])\\{?([a-zA-Z])\\}?", "{$1$2}");
    }

    private static boolean isInstitution(String author) {
        return StringUtil.isInCurlyBrackets(author);
    }

    private static String generateInstitutionKey(String content) {
        if (content.isEmpty()) {
            return content;
        }
        String result = content;
        result = BracketedPattern.unifyDiacritics(result);
        Matcher matcher = REGEX_PATTERN.matcher(result = result.replaceAll("^\\{", "").replaceAll("\\}$", ""));
        if (matcher.matches()) {
            return matcher.group(1);
        }
        result = BracketedPattern.removeDiacritics(result);
        String[] parts = result.split(",");
        String university = null;
        String department = null;
        String school = null;
        String rest = null;
        List<String> ignore = Arrays.asList("press", "the");
        for (int index = 0; index < parts.length; ++index) {
            ArrayList<String> part = new ArrayList<String>();
            for (String k : parts[index].replaceAll("\\{[A-Z]+\\}", "").split("[ \\-_]")) {
                if ((k.isEmpty() || ignore.contains(k.toLowerCase(Locale.ENGLISH)) || k.charAt(k.length() - 1) == '.' || !String.valueOf(k.charAt(0)).matches("[A-Z]")) && (k.length() < 3 || !"uni".equalsIgnoreCase(k.substring(0, 2)))) continue;
                part.add(k);
            }
            boolean isUniversity = false;
            boolean isTechnology = false;
            boolean isDepartment = false;
            boolean isSchool = false;
            for (String string : part) {
                if (string.matches("^[Uu][Nn][Ii].*")) {
                    isUniversity = true;
                }
                if (string.matches("^[Tt][Ee][Cc][Hh].*")) {
                    isTechnology = true;
                }
                if ("school".equalsIgnoreCase(string)) {
                    isSchool = true;
                }
                if (!string.matches("^[Dd][EeIi][Pp].*") && !string.matches("^[Ll][Aa][Bb].*")) continue;
                isDepartment = true;
            }
            if (isTechnology) {
                isUniversity = false;
            }
            if (isUniversity) {
                StringBuilder universitySB = new StringBuilder();
                universitySB.append("Uni");
                for (String string : part) {
                    if (string.matches("^[Uu][Nn][Ii].*")) continue;
                    universitySB.append(string);
                }
                university = universitySB.toString();
                if (index <= 0 || department != null) continue;
                department = parts[index - 1];
                continue;
            }
            if (isSchool || isDepartment) {
                StringBuilder schoolSB = new StringBuilder();
                StringBuilder stringBuilder = new StringBuilder();
                for (String k : part) {
                    if (k.matches("^[Dd][EeIi][Pp].*") || "school".equalsIgnoreCase(k) || "faculty".equalsIgnoreCase(k) || k.replaceAll(STARTING_CAPITAL_PATTERN, "").isEmpty()) continue;
                    if (isSchool) {
                        schoolSB.append(k.replaceAll(STARTING_CAPITAL_PATTERN, ""));
                    }
                    if (!isDepartment) continue;
                    stringBuilder.append(k.replaceAll(STARTING_CAPITAL_PATTERN, ""));
                }
                if (isSchool) {
                    school = schoolSB.toString();
                }
                if (!isDepartment) continue;
                department = stringBuilder.toString();
                continue;
            }
            if (rest != null) continue;
            StringBuilder restSB = new StringBuilder();
            if (part.size() < 3) {
                for (String string : part) {
                    restSB.append(string);
                }
            } else {
                for (String string : part) {
                    String string2 = string.replaceAll(STARTING_CAPITAL_PATTERN, "");
                    if (string2.isEmpty()) continue;
                    restSB.append(string2);
                }
            }
            rest = restSB.toString();
        }
        return (university == null ? rest : university) + (school == null ? "" : school) + (department == null || school != null && department.equals(school) ? "" : department);
    }
}

