/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bibtex;

import org.jabref.logic.bibtex.FieldContentParser;
import org.jabref.logic.bibtex.InvalidFieldValueException;
import org.jabref.logic.bibtex.LatexFieldFormatterPreferences;
import org.jabref.logic.util.OS;
import org.jabref.model.entry.InternalBibtexFields;
import org.jabref.model.strings.StringUtil;

public class LatexFieldFormatter {
    public static final String BIBTEX_STRING = "__string";
    private static final char FIELD_START = '{';
    private static final char FIELD_END = '}';
    private final boolean neverFailOnHashes;
    private final LatexFieldFormatterPreferences prefs;
    private final FieldContentParser parser;
    private StringBuilder stringBuilder;

    public LatexFieldFormatter(LatexFieldFormatterPreferences prefs) {
        this(true, prefs);
    }

    private LatexFieldFormatter(boolean neverFailOnHashes, LatexFieldFormatterPreferences prefs) {
        this.neverFailOnHashes = neverFailOnHashes;
        this.prefs = prefs;
        this.parser = new FieldContentParser(prefs.getFieldContentParserPreferences());
    }

    public static LatexFieldFormatter buildIgnoreHashes(LatexFieldFormatterPreferences prefs) {
        return new LatexFieldFormatter(true, prefs);
    }

    private static void checkBraces(String text) throws InvalidFieldValueException {
        int left = 0;
        int right = 0;
        for (int i = 0; i < text.length(); ++i) {
            char item = text.charAt(i);
            boolean charBeforeIsEscape = false;
            if (i > 0 && text.charAt(i - 1) == '\\') {
                charBeforeIsEscape = true;
            }
            if (!charBeforeIsEscape && item == '{') {
                ++left;
                continue;
            }
            if (charBeforeIsEscape || item != '}') continue;
            ++right;
        }
        if (right != 0 && left == 0) {
            throw new InvalidFieldValueException("Unescaped '}' character without opening bracket ends string prematurely.");
        }
        if (right != 0 && right < left) {
            throw new InvalidFieldValueException("Unescaped '}' character without opening bracket ends string prematurely.");
        }
        if (left != right) {
            throw new InvalidFieldValueException("Braces don't match.");
        }
    }

    public String format(String content, String fieldName) throws InvalidFieldValueException {
        boolean resolveStrings;
        boolean shouldNormalizeNewlines;
        if (content == null) {
            return '{' + String.valueOf('}');
        }
        String result = content;
        boolean bl = shouldNormalizeNewlines = !result.contains(OS.NEWLINE) && result.contains("\n");
        if (shouldNormalizeNewlines) {
            result = result.replace("\n", OS.NEWLINE);
        }
        if (!(resolveStrings = this.shouldResolveStrings(fieldName))) {
            return this.formatWithoutResolvingStrings(result, fieldName);
        }
        result = result.trim();
        return this.formatAndResolveStrings(result, fieldName);
    }

    private String formatAndResolveStrings(String content, String fieldName) throws InvalidFieldValueException {
        this.stringBuilder = new StringBuilder();
        LatexFieldFormatter.checkBraces(content);
        int pivot = 0;
        while (pivot < content.length()) {
            int pos2;
            int goFrom = pivot;
            int pos1 = pivot;
            while (goFrom == pos1) {
                pos1 = content.indexOf(35, goFrom);
                if (pos1 > 0 && content.charAt(pos1 - 1) == '\\') {
                    goFrom = pos1 + 1;
                    ++pos1;
                    continue;
                }
                goFrom = pos1 - 1;
            }
            if (pos1 == -1) {
                pos1 = content.length();
                pos2 = -1;
            } else {
                pos2 = content.indexOf(35, pos1 + 1);
                if (pos2 == -1) {
                    if (this.neverFailOnHashes) {
                        pos1 = content.length();
                    } else {
                        throw new InvalidFieldValueException("The # character is not allowed in BibTeX strings unless escaped as in '\\#'.\nIn JabRef, use pairs of # characters to indicate a string.\nNote that the entry causing the problem has been selected.");
                    }
                }
            }
            if (pos1 > pivot) {
                this.writeText(content, pivot, pos1);
            }
            if (pos1 < content.length() && pos2 - 1 > pos1) {
                this.writeStringLabel(content, pos1 + 1, pos2, pos1 == pivot, pos2 + 1 == content.length());
            }
            if (pos2 > -1) {
                pivot = pos2 + 1;
                continue;
            }
            pivot = pos1 + 1;
        }
        return this.parser.format(this.stringBuilder, fieldName);
    }

    private boolean shouldResolveStrings(String fieldName) {
        boolean resolveStrings = true;
        if (this.prefs.isResolveStringsAllFields()) {
            for (String exception : this.prefs.getDoNotResolveStringsFor()) {
                if (!exception.equals(fieldName)) continue;
                resolveStrings = false;
                break;
            }
        } else {
            resolveStrings = InternalBibtexFields.isStandardField(fieldName) || BIBTEX_STRING.equals(fieldName);
        }
        return resolveStrings;
    }

    private String formatWithoutResolvingStrings(String content, String fieldName) throws InvalidFieldValueException {
        LatexFieldFormatter.checkBraces(content);
        this.stringBuilder = new StringBuilder(String.valueOf('{'));
        this.stringBuilder.append(this.parser.format(content, fieldName));
        this.stringBuilder.append('}');
        return this.stringBuilder.toString();
    }

    private void writeText(String text, int startPos, int endPos) {
        this.stringBuilder.append('{');
        boolean escape = false;
        boolean inCommandName = false;
        boolean inCommand = false;
        boolean inCommandOption = false;
        int nestedEnvironments = 0;
        StringBuilder commandName = new StringBuilder();
        for (int i = startPos; i < endPos; ++i) {
            char c = text.charAt(i);
            if (Character.isLetter(c) && (escape || inCommandName)) {
                inCommandName = true;
                if (!inCommandOption) {
                    commandName.append(c);
                }
            } else if ((!Character.isWhitespace(c) || !inCommand && !inCommandOption) && inCommandName) {
                if (c == '[') {
                    inCommandOption = true;
                } else if (inCommandOption && c == ']') {
                    inCommandOption = false;
                } else if (!inCommandOption && c == '{') {
                    inCommandName = false;
                    inCommand = true;
                } else {
                    commandName.delete(0, commandName.length());
                    inCommandName = false;
                }
            }
            if (inCommand && c == '}') {
                if ("begin".equals(commandName.toString())) {
                    ++nestedEnvironments;
                }
                if (nestedEnvironments > 0 && "end".equals(commandName.toString())) {
                    --nestedEnvironments;
                }
                commandName.delete(0, commandName.length());
                inCommand = false;
            }
            if (!(c != '&' || escape || inCommand && "url".equals(commandName.toString()) || nestedEnvironments != 0)) {
                this.stringBuilder.append("\\&");
            } else {
                this.stringBuilder.append(c);
            }
            escape = c == '\\';
        }
        this.stringBuilder.append('}');
    }

    private void writeStringLabel(String text, int startPos, int endPos, boolean first, boolean last) {
        this.putIn((first ? "" : " # ") + text.substring(startPos, endPos) + (last ? "" : " # "));
    }

    private void putIn(String s2) {
        this.stringBuilder.append(StringUtil.wrap(s2, this.prefs.getLineLength(), OS.NEWLINE));
    }
}

