/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bibtex;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.jabref.logic.bibtex.FieldContentParserPreferences;
import org.jabref.logic.util.OS;
import org.jabref.model.strings.StringUtil;

public class FieldContentParser {
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");
    private final Set<String> multiLineFields;

    public FieldContentParser(FieldContentParserPreferences prefs) {
        Objects.requireNonNull(prefs);
        this.multiLineFields = new HashSet<String>();
        this.multiLineFields.add("abstract");
        this.multiLineFields.add("comment");
        this.multiLineFields.add("review");
        this.multiLineFields.addAll(prefs.getNonWrappableFields());
    }

    public String format(String fieldContent, String bibtexField) {
        if (this.multiLineFields.contains(bibtexField)) {
            return StringUtil.unifyLineBreaks(fieldContent, OS.NEWLINE);
        }
        return WHITESPACE.matcher(fieldContent).replaceAll(" ");
    }

    public String format(StringBuilder fieldContent, String bibtexField) {
        return this.format(fieldContent.toString(), bibtexField);
    }
}

