/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.utils.MaterialDesignIconFactory;
import java.util.function.BiConsumer;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Tooltip;
import javafx.scene.input.DragEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.util.Callback;
import org.jabref.model.strings.StringUtil;

public class ViewModelListCellFactory<T>
implements Callback<ListView<T>, ListCell<T>> {
    private Callback<T, String> toText;
    private Callback<T, Node> toGraphic;
    private Callback<T, String> toTooltip;
    private BiConsumer<T, ? super MouseEvent> toOnMouseClickedEvent;
    private Callback<T, String> toStyleClass;
    private Callback<T, ContextMenu> toContextMenu;
    private BiConsumer<T, ? super MouseEvent> toOnDragDetected;
    private BiConsumer<T, ? super DragEvent> toOnDragDropped;
    private BiConsumer<T, ? super DragEvent> toOnDragEntered;
    private BiConsumer<T, ? super DragEvent> toOnDragExited;
    private BiConsumer<T, ? super DragEvent> toOnDragOver;

    public ViewModelListCellFactory<T> withText(Callback<T, String> toText) {
        this.toText = toText;
        return this;
    }

    public ViewModelListCellFactory<T> withGraphic(Callback<T, Node> toGraphic) {
        this.toGraphic = toGraphic;
        return this;
    }

    public ViewModelListCellFactory<T> withIcon(Callback<T, GlyphIcons> toIcon) {
        this.toGraphic = viewModel -> MaterialDesignIconFactory.get().createIcon((GlyphIcons)toIcon.call(viewModel));
        return this;
    }

    public ViewModelListCellFactory<T> withIcon(Callback<T, GlyphIcons> toIcon, Callback<T, Paint> toColor) {
        this.toGraphic = viewModel -> {
            Text graphic = MaterialDesignIconFactory.get().createIcon((GlyphIcons)toIcon.call(viewModel));
            graphic.setFill((Paint)toColor.call(viewModel));
            return graphic;
        };
        return this;
    }

    public ViewModelListCellFactory<T> withTooltip(Callback<T, String> toTooltip) {
        this.toTooltip = toTooltip;
        return this;
    }

    public ViewModelListCellFactory<T> withContextMenu(Callback<T, ContextMenu> toContextMenu) {
        this.toContextMenu = toContextMenu;
        return this;
    }

    public ViewModelListCellFactory<T> withStyleClass(Callback<T, String> toStyleClass) {
        this.toStyleClass = toStyleClass;
        return this;
    }

    public ViewModelListCellFactory<T> withOnMouseClickedEvent(BiConsumer<T, ? super MouseEvent> toOnMouseClickedEvent) {
        this.toOnMouseClickedEvent = toOnMouseClickedEvent;
        return this;
    }

    public ViewModelListCellFactory<T> setOnDragDetected(BiConsumer<T, ? super MouseEvent> toOnDragDetected) {
        this.toOnDragDetected = toOnDragDetected;
        return this;
    }

    public ViewModelListCellFactory<T> setOnDragDropped(BiConsumer<T, ? super DragEvent> toOnDragDropped) {
        this.toOnDragDropped = toOnDragDropped;
        return this;
    }

    public ViewModelListCellFactory<T> setOnDragEntered(BiConsumer<T, ? super DragEvent> toOnDragEntered) {
        this.toOnDragEntered = toOnDragEntered;
        return this;
    }

    public ViewModelListCellFactory<T> setOnDragExited(BiConsumer<T, ? super DragEvent> toOnDragExited) {
        this.toOnDragExited = toOnDragExited;
        return this;
    }

    public ViewModelListCellFactory<T> setOnDragOver(BiConsumer<T, ? super DragEvent> toOnDragOver) {
        this.toOnDragOver = toOnDragOver;
        return this;
    }

    public ListCell<T> call(ListView<T> param2) {
        return new ListCell<T>(){

            protected void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                Object viewModel = this.getItem();
                if (empty || viewModel == null) {
                    this.setText(null);
                    this.setGraphic(null);
                    this.setOnMouseClicked(null);
                    this.setTooltip(null);
                } else {
                    String tooltipText;
                    if (ViewModelListCellFactory.this.toText != null) {
                        this.setText((String)ViewModelListCellFactory.this.toText.call(viewModel));
                    }
                    if (ViewModelListCellFactory.this.toGraphic != null) {
                        this.setGraphic((Node)ViewModelListCellFactory.this.toGraphic.call(viewModel));
                    }
                    if (ViewModelListCellFactory.this.toOnMouseClickedEvent != null) {
                        this.setOnMouseClicked(event -> ViewModelListCellFactory.this.toOnMouseClickedEvent.accept(viewModel, event));
                    }
                    if (ViewModelListCellFactory.this.toStyleClass != null) {
                        this.getStyleClass().setAll((Object[])new String[]{(String)ViewModelListCellFactory.this.toStyleClass.call(viewModel)});
                    }
                    if (ViewModelListCellFactory.this.toTooltip != null && StringUtil.isNotBlank(tooltipText = (String)ViewModelListCellFactory.this.toTooltip.call(viewModel))) {
                        this.setTooltip(new Tooltip(tooltipText));
                    }
                    if (ViewModelListCellFactory.this.toContextMenu != null) {
                        this.setContextMenu((ContextMenu)ViewModelListCellFactory.this.toContextMenu.call(viewModel));
                    }
                    if (ViewModelListCellFactory.this.toOnDragDetected != null) {
                        this.setOnDragDetected(event -> ViewModelListCellFactory.this.toOnDragDetected.accept(viewModel, event));
                    }
                    if (ViewModelListCellFactory.this.toOnDragDropped != null) {
                        this.setOnDragDropped(event -> ViewModelListCellFactory.this.toOnDragDropped.accept(viewModel, event));
                    }
                    if (ViewModelListCellFactory.this.toOnDragEntered != null) {
                        this.setOnDragEntered(event -> ViewModelListCellFactory.this.toOnDragEntered.accept(viewModel, event));
                    }
                    if (ViewModelListCellFactory.this.toOnDragExited != null) {
                        this.setOnDragExited(event -> ViewModelListCellFactory.this.toOnDragExited.accept(viewModel, event));
                    }
                    if (ViewModelListCellFactory.this.toOnDragOver != null) {
                        this.setOnDragOver(event -> ViewModelListCellFactory.this.toOnDragOver.accept(viewModel, event));
                    }
                }
                this.getListView().refresh();
            }
        };
    }
}

