/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import org.fxmisc.easybind.EasyBind;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTaskExecutor
implements TaskExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTaskExecutor.class);
    private static final ExecutorService EXECUTOR = Executors.newFixedThreadPool(5);

    public static <V> V runInJavaFXThread(Callable<V> callable) {
        FutureTask<V> task = new FutureTask<V>(callable);
        Platform.runLater(task);
        try {
            return task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("Problem running in fx thread", e);
            return null;
        }
    }

    public static void runAndWaitInJavaFXThread(Runnable action) {
        Objects.requireNonNull(action);
        if (Platform.isFxApplicationThread()) {
            action.run();
            return;
        }
        CountDownLatch doneLatch = new CountDownLatch(1);
        Platform.runLater(() -> {
            try {
                action.run();
            }
            finally {
                doneLatch.countDown();
            }
        });
        try {
            doneLatch.await();
        }
        catch (InterruptedException e) {
            LOGGER.error("Problem running action on JavaFX thread", e);
        }
    }

    public static void runInJavaFXThread(Runnable runnable) {
        Platform.runLater((Runnable)runnable);
    }

    @Override
    public <V> Future<?> execute(BackgroundTask<V> task) {
        return EXECUTOR.submit((Runnable)this.getJavaFXTask(task));
    }

    @Override
    public void shutdown() {
        EXECUTOR.shutdownNow();
    }

    private <V> Task<V> getJavaFXTask(final BackgroundTask<V> task) {
        Consumer<Exception> onException;
        Consumer<V> onSuccess;
        Task javaTask = new Task<V>(){
            {
                EasyBind.subscribe(task.progressProperty(), progress -> this.updateProgress(progress.getWorkDone(), progress.getMax()));
            }

            public V call() throws Exception {
                return task.call();
            }
        };
        Runnable onRunning = task.getOnRunning();
        if (onRunning != null) {
            javaTask.setOnRunning(event -> onRunning.run());
        }
        if ((onSuccess = task.getOnSuccess()) != null) {
            javaTask.setOnSucceeded(arg_0 -> DefaultTaskExecutor.lambda$getJavaFXTask$2(onSuccess, (Task)javaTask, arg_0));
        }
        if ((onException = task.getOnException()) != null) {
            javaTask.setOnFailed(arg_0 -> this.lambda$getJavaFXTask$3(onException, (Task)javaTask, arg_0));
        }
        return javaTask;
    }

    private Exception convertToException(Throwable throwable) {
        if (throwable instanceof Exception) {
            return (Exception)throwable;
        }
        return new Exception(throwable);
    }

    private /* synthetic */ void lambda$getJavaFXTask$3(Consumer onException, Task javaTask, WorkerStateEvent event) {
        onException.accept(this.convertToException(javaTask.getException()));
    }

    private static /* synthetic */ void lambda$getJavaFXTask$2(Consumer onSuccess, Task javaTask, WorkerStateEvent event) {
        onSuccess.accept(javaTask.getValue());
    }
}

