/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.specialfields;

import com.google.common.eventbus.Subscribe;
import javax.swing.SwingUtilities;
import org.jabref.Globals;
import org.jabref.JabRefGUI;
import org.jabref.logic.specialfields.SpecialFieldsUtils;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.event.FieldChangedEvent;
import org.jabref.model.entry.specialfields.SpecialField;

public class SpecialFieldUpdateListener {
    private static SpecialFieldUpdateListener INSTANCE;

    @Subscribe
    public void listen(FieldChangedEvent fieldChangedEvent) {
        if (!Globals.prefs.isKeywordSyncEnabled()) {
            return;
        }
        BibEntry entry = fieldChangedEvent.getBibEntry();
        String fieldName = fieldChangedEvent.getFieldName();
        SwingUtilities.invokeLater(() -> {
            if ("keywords".equals(fieldName)) {
                SpecialFieldsUtils.syncSpecialFieldsFromKeywords(entry, Globals.prefs.getKeywordDelimiter());
            } else if (SpecialField.isSpecialField(fieldName)) {
                SpecialFieldsUtils.syncKeywordsFromSpecialFields(entry, Globals.prefs.getKeywordDelimiter());
            }
            SwingUtilities.invokeLater(() -> JabRefGUI.getMainFrame().getCurrentBasePanel().updateEntryEditorIfShowing());
        });
    }

    public static SpecialFieldUpdateListener getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SpecialFieldUpdateListener();
        }
        return INSTANCE;
    }
}

