/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.specialfields;

import com.google.common.eventbus.Subscribe;
import java.util.List;
import org.jabref.Globals;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.specialfields.SpecialFieldsUtils;
import org.jabref.model.FieldChange;
import org.jabref.model.database.event.EntryAddedEvent;
import org.jabref.model.entry.BibEntry;

public class SpecialFieldDatabaseChangeListener {
    private static SpecialFieldDatabaseChangeListener INSTANCE;

    public static SpecialFieldDatabaseChangeListener getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SpecialFieldDatabaseChangeListener();
        }
        return INSTANCE;
    }

    @Subscribe
    public void listen(EntryAddedEvent event) {
        if (!Globals.prefs.isKeywordSyncEnabled()) {
            return;
        }
        BibEntry entry = event.getBibEntry();
        NamedCompound nc = new NamedCompound(Localization.lang("Synchronized special fields based on keywords", new String[0]));
        List<FieldChange> changes = SpecialFieldsUtils.syncSpecialFieldsFromKeywords(entry, Globals.prefs.getKeywordDelimiter());
        for (FieldChange change : changes) {
            nc.addEdit(new UndoableFieldChange(change));
        }
    }
}

