/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.shared;

import com.google.common.eventbus.Subscribe;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jabref.Globals;
import org.jabref.JabRefGUI;
import org.jabref.gui.BasePanel;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.entryeditor.EntryEditor;
import org.jabref.gui.shared.ConnectToSharedDatabaseDialog;
import org.jabref.gui.shared.MergeSharedEntryDialog;
import org.jabref.gui.undo.UndoableRemoveEntry;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.shared.DBMSConnection;
import org.jabref.logic.shared.DBMSConnectionProperties;
import org.jabref.logic.shared.DBMSSynchronizer;
import org.jabref.logic.shared.event.ConnectionLostEvent;
import org.jabref.logic.shared.event.SharedEntryNotPresentEvent;
import org.jabref.logic.shared.event.UpdateRefusedEvent;
import org.jabref.logic.shared.exception.InvalidDBMSConnectionPropertiesException;
import org.jabref.logic.shared.exception.NotASharedDatabaseException;
import org.jabref.logic.shared.prefs.SharedDatabasePreferences;
import org.jabref.model.Defaults;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.database.shared.DatabaseNotSupportedException;
import org.jabref.model.database.shared.DatabaseSynchronizer;

public class SharedDatabaseUIManager {
    private final JabRefFrame jabRefFrame;
    private DatabaseSynchronizer dbmsSynchronizer;

    public SharedDatabaseUIManager(JabRefFrame jabRefFrame) {
        this.jabRefFrame = jabRefFrame;
    }

    @Subscribe
    public void listen(ConnectionLostEvent connectionLostEvent) {
        this.jabRefFrame.output(Localization.lang("Connection lost.", new String[0]));
        Object[] options = new String[]{Localization.lang("Reconnect", new String[0]), Localization.lang("Work offline", new String[0]), Localization.lang("Close library", new String[0])};
        int answer = JOptionPane.showOptionDialog(this.jabRefFrame, Localization.lang("The connection to the server has been terminated.", new String[0]) + "\n\n", Localization.lang("Connection lost", new String[0]), 1, 2, null, options, options[0]);
        if (answer == 0) {
            this.jabRefFrame.closeCurrentTab();
            ConnectToSharedDatabaseDialog connectToSharedDatabaseDialog = new ConnectToSharedDatabaseDialog(this.jabRefFrame);
            connectToSharedDatabaseDialog.setVisible(true);
        } else if (answer == 1) {
            connectionLostEvent.getBibDatabaseContext().convertToLocalDatabase();
            this.jabRefFrame.refreshTitleAndTabs();
            this.jabRefFrame.updateEnabledState();
            this.jabRefFrame.output(Localization.lang("Working offline.", new String[0]));
        } else {
            this.jabRefFrame.closeCurrentTab();
        }
    }

    @Subscribe
    public void listen(UpdateRefusedEvent updateRefusedEvent) {
        this.jabRefFrame.output(Localization.lang("Update refused.", new String[0]));
        new MergeSharedEntryDialog(this.jabRefFrame, this.dbmsSynchronizer, updateRefusedEvent.getLocalBibEntry(), updateRefusedEvent.getSharedBibEntry(), updateRefusedEvent.getBibDatabaseContext().getMode()).showMergeDialog();
    }

    @Subscribe
    public void listen(SharedEntryNotPresentEvent event) {
        BasePanel panel = this.jabRefFrame.getCurrentBasePanel();
        EntryEditor entryEditor = panel.getEntryEditor();
        panel.getUndoManager().addEdit(new UndoableRemoveEntry(panel.getDatabase(), event.getBibEntry(), panel));
        if (Objects.nonNull((Object)entryEditor) && entryEditor.getEntry() == event.getBibEntry()) {
            JOptionPane.showMessageDialog(this.jabRefFrame, Localization.lang("The BibEntry you currently work on has been deleted on the shared side.", new String[0]) + "\n" + Localization.lang("You can restore the entry using the \"Undo\" operation.", new String[0]), Localization.lang("Shared entry is no longer present", new String[0]), 1);
            SwingUtilities.invokeLater(() -> panel.hideBottomComponent());
        }
    }

    public BasePanel openNewSharedDatabaseTab(DBMSConnectionProperties dbmsConnectionProperties) throws SQLException, DatabaseNotSupportedException, InvalidDBMSConnectionPropertiesException {
        JabRefFrame frame = JabRefGUI.getMainFrame();
        BibDatabaseMode selectedMode = Globals.prefs.getDefaultBibDatabaseMode();
        BibDatabaseContext bibDatabaseContext = new BibDatabaseContext(new Defaults(selectedMode));
        DBMSSynchronizer synchronizer = new DBMSSynchronizer(bibDatabaseContext, Globals.prefs.getKeywordDelimiter(), Globals.prefs.getKeyPattern(), Globals.getFileUpdateMonitor());
        bibDatabaseContext.convertToSharedDatabase(synchronizer);
        this.dbmsSynchronizer = bibDatabaseContext.getDBMSSynchronizer();
        this.dbmsSynchronizer.openSharedDatabase(new DBMSConnection(dbmsConnectionProperties));
        this.dbmsSynchronizer.registerListener(this);
        frame.output(Localization.lang("Connection to %0 server established.", dbmsConnectionProperties.getType().toString()));
        return frame.addTab(bibDatabaseContext, true);
    }

    public void openSharedDatabaseFromParserResult(ParserResult parserResult) throws SQLException, DatabaseNotSupportedException, InvalidDBMSConnectionPropertiesException, NotASharedDatabaseException {
        Optional<String> sharedDatabaseIDOptional = parserResult.getDatabase().getSharedDatabaseID();
        if (!sharedDatabaseIDOptional.isPresent()) {
            throw new NotASharedDatabaseException();
        }
        String sharedDatabaseID = sharedDatabaseIDOptional.get();
        DBMSConnectionProperties dbmsConnectionProperties = new DBMSConnectionProperties(new SharedDatabasePreferences(sharedDatabaseID));
        JabRefFrame frame = JabRefGUI.getMainFrame();
        BibDatabaseMode selectedMode = Globals.prefs.getDefaultBibDatabaseMode();
        BibDatabaseContext bibDatabaseContext = new BibDatabaseContext(new Defaults(selectedMode));
        DBMSSynchronizer synchronizer = new DBMSSynchronizer(bibDatabaseContext, Globals.prefs.getKeywordDelimiter(), Globals.prefs.getKeyPattern(), Globals.getFileUpdateMonitor());
        bibDatabaseContext.convertToSharedDatabase(synchronizer);
        bibDatabaseContext.getDatabase().setSharedDatabaseID(sharedDatabaseID);
        bibDatabaseContext.setDatabaseFile(parserResult.getDatabaseContext().getDatabaseFile().orElse(null));
        this.dbmsSynchronizer = bibDatabaseContext.getDBMSSynchronizer();
        this.dbmsSynchronizer.openSharedDatabase(new DBMSConnection(dbmsConnectionProperties));
        this.dbmsSynchronizer.registerListener(this);
        parserResult.setDatabaseContext(bibDatabaseContext);
        frame.output(Localization.lang("Connection to %0 server established.", dbmsConnectionProperties.getType().toString()));
    }
}

