/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.push;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jabref.Globals;
import org.jabref.JabRefExecutorService;
import org.jabref.gui.BasePanel;
import org.jabref.gui.IconTheme;
import org.jabref.gui.push.AbstractPushToApplication;
import org.jabref.gui.push.PushToApplication;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.metadata.MetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushToLyx
extends AbstractPushToApplication
implements PushToApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(PushToLyx.class);

    @Override
    public String getApplicationName() {
        return "LyX/Kile";
    }

    @Override
    public Icon getIcon() {
        return IconTheme.getImage("lyx");
    }

    @Override
    protected void initParameters() {
        this.commandPathPreferenceKey = "lyxpipe";
    }

    @Override
    public void operationCompleted(BasePanel panel) {
        if (this.couldNotConnect) {
            panel.output(Localization.lang("Error", new String[0]) + ": " + Localization.lang("verify that LyX is running and that the lyxpipe is valid", new String[0]) + ". [" + this.commandPath + "]");
        } else if (this.couldNotCall) {
            panel.output(Localization.lang("Error", new String[0]) + ": " + Localization.lang("unable to write to", new String[0]) + " " + this.commandPath + ".in");
        } else {
            super.operationCompleted(panel);
        }
    }

    @Override
    protected void initSettingsPanel() {
        super.initSettingsPanel();
        this.settings = new JPanel();
        this.settings.add(new JLabel(Localization.lang("Path to LyX pipe", new String[0]) + ":"));
        this.settings.add(this.path);
    }

    @Override
    public void pushEntries(BibDatabase database, List<BibEntry> entries, String keyString, MetaData metaData) {
        File lp;
        this.couldNotConnect = false;
        this.couldNotCall = false;
        this.notDefined = false;
        this.initParameters();
        this.commandPath = Globals.prefs.get(this.commandPathPreferenceKey);
        if (this.commandPath == null || this.commandPath.trim().isEmpty()) {
            this.notDefined = true;
            return;
        }
        if (!this.commandPath.endsWith(".in")) {
            this.commandPath = this.commandPath + ".in";
        }
        if (!((lp = new File(this.commandPath)).exists() && lp.canWrite() || (lp = new File(this.commandPath + ".in")).exists() && lp.canWrite())) {
            this.couldNotConnect = true;
            return;
        }
        File lyxpipe = lp;
        JabRefExecutorService.INSTANCE.executeAndWait(() -> {
            try {
                FileWriter fw = new FileWriter(lyxpipe);
                Throwable throwable = null;
                try {
                    BufferedWriter lyxOut = new BufferedWriter(fw);
                    Throwable throwable2 = null;
                    try {
                        String citeStr = "LYXCMD:sampleclient:citation-insert:" + keyString;
                        lyxOut.write(citeStr + "\n");
                        lyxOut.close();
                        fw.close();
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        PushToLyx.$closeResource(throwable2, lyxOut);
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    PushToLyx.$closeResource(throwable, fw);
                }
            }
            catch (IOException excep) {
                this.couldNotCall = true;
                LOGGER.warn("Problem pushing to LyX/Kile.", excep);
            }
        });
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

