/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.keyboard;

import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.input.KeyEvent;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.DialogService;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.keyboard.KeyBindingCategory;
import org.jabref.gui.keyboard.KeyBindingRepository;
import org.jabref.gui.keyboard.KeyBindingViewModel;
import org.jabref.logic.l10n.Localization;
import org.jabref.preferences.PreferencesService;

public class KeyBindingsDialogViewModel
extends AbstractViewModel {
    private final KeyBindingRepository keyBindingRepository;
    private final PreferencesService preferences;
    private final ObjectProperty<KeyBindingViewModel> selectedKeyBinding = new SimpleObjectProperty();
    private final ObjectProperty<KeyBindingViewModel> rootKeyBinding = new SimpleObjectProperty();
    private final DialogService dialogService;

    public KeyBindingsDialogViewModel(KeyBindingRepository keyBindingRepository, DialogService dialogService, PreferencesService preferences) {
        this.keyBindingRepository = Objects.requireNonNull(keyBindingRepository);
        this.dialogService = Objects.requireNonNull(dialogService);
        this.preferences = Objects.requireNonNull(preferences);
        this.populateTable();
    }

    public ObjectProperty<KeyBindingViewModel> selectedKeyBindingProperty() {
        return this.selectedKeyBinding;
    }

    public ObjectProperty<KeyBindingViewModel> rootKeyBindingProperty() {
        return this.rootKeyBinding;
    }

    private void populateTable() {
        KeyBindingViewModel root = new KeyBindingViewModel(this.keyBindingRepository, KeyBindingCategory.FILE);
        for (KeyBindingCategory category : KeyBindingCategory.values()) {
            KeyBindingViewModel categoryItem = new KeyBindingViewModel(this.keyBindingRepository, category);
            this.keyBindingRepository.getKeyBindings().forEach((keyBinding, bind) -> {
                if (keyBinding.getCategory() == category) {
                    KeyBindingViewModel keyBindViewModel = new KeyBindingViewModel(this.keyBindingRepository, (KeyBinding)((Object)keyBinding), (String)bind);
                    categoryItem.getChildren().add((Object)keyBindViewModel);
                }
            });
            root.getChildren().add((Object)categoryItem);
        }
        this.rootKeyBinding.set((Object)root);
    }

    public void setNewBindingForCurrent(KeyEvent event) {
        if (this.selectedKeyBinding.isNull().get()) {
            return;
        }
        KeyBindingViewModel selectedEntry = (KeyBindingViewModel)this.selectedKeyBinding.get();
        if (selectedEntry == null || selectedEntry.isCategory()) {
            return;
        }
        if (selectedEntry.setNewBinding(event)) {
            this.keyBindingRepository.put(selectedEntry.getKeyBinding(), selectedEntry.getBinding());
        }
    }

    public void saveKeyBindings() {
        this.preferences.storeKeyBindingRepository(this.keyBindingRepository);
        String title = Localization.lang("Key bindings changed", new String[0]);
        String content = Localization.lang("Your new key bindings have been stored.", new String[0]) + '\n' + Localization.lang("You must restart JabRef for the new key bindings to work properly.", new String[0]);
        this.dialogService.showInformationDialogAndWait(title, content);
    }

    public void resetToDefault() {
        String title = Localization.lang("Resetting all key bindings", new String[0]);
        String content = Localization.lang("All key bindings will be reset to their defaults.", new String[0]);
        ButtonType resetButtonType = new ButtonType("Reset", ButtonBar.ButtonData.OK_DONE);
        this.dialogService.showCustomButtonDialogAndWait(Alert.AlertType.INFORMATION, title, content, resetButtonType, ButtonType.CANCEL).ifPresent(response -> {
            if (response == resetButtonType) {
                this.keyBindingRepository.resetToDefault();
                this.populateTable();
            }
        });
    }
}

