/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.importer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.EntryMarker;
import org.jabref.gui.FXDialogService;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.importer.ImportInspectionDialog;
import org.jabref.gui.importer.ParserResultWarningDialog;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.gui.worker.AbstractWorker;
import org.jabref.logic.importer.ImportException;
import org.jabref.logic.importer.ImportFormatReader;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.UpdateField;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.KeyCollisionException;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibtexString;

public class ImportMenuItem
extends JMenuItem
implements ActionListener {
    private final JabRefFrame frame;
    private final boolean openInNew;
    private final Importer importer;
    private Exception importError;

    public ImportMenuItem(JabRefFrame frame, boolean openInNew) {
        this(frame, openInNew, null);
    }

    public ImportMenuItem(JabRefFrame frame, boolean openInNew, Importer importer) {
        super(importer == null ? Localization.lang("Autodetect format", new String[0]) : importer.getName());
        this.importer = importer;
        this.frame = frame;
        this.openInNew = openInNew;
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MyWorker worker = new MyWorker();
        worker.init();
        worker.getWorker().run();
        worker.getCallBack().update();
    }

    public void automatedImport(List<String> filenames) {
        MyWorker worker = new MyWorker();
        worker.fileOk = true;
        worker.filenames = filenames.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        worker.getWorker().run();
        worker.getCallBack().update();
    }

    private ParserResult mergeImportResults(List<ImportFormatReader.UnknownFormatImport> imports) {
        BibDatabase database = new BibDatabase();
        ParserResult directParserResult = null;
        boolean anythingUseful = false;
        for (ImportFormatReader.UnknownFormatImport importResult : imports) {
            ParserResult pr;
            if (importResult == null) continue;
            if ("BibTeX".equals(importResult.format)) {
                pr = importResult.parserResult;
                boolean bl = anythingUseful = anythingUseful || pr.getDatabase().hasEntries() || !pr.getDatabase().hasNoStrings();
                if (directParserResult == null) {
                    directParserResult = pr;
                }
                for (BibEntry entry : pr.getDatabase().getEntries()) {
                    database.insertEntry(entry);
                }
                for (BibtexString bs : pr.getDatabase().getStringValues()) {
                    try {
                        database.addString((BibtexString)bs.clone());
                    }
                    catch (KeyCollisionException keyCollisionException) {}
                }
                continue;
            }
            pr = importResult.parserResult;
            ObservableList<BibEntry> entries = pr.getDatabase().getEntries();
            anythingUseful |= !entries.isEmpty();
            UpdateField.setAutomaticFields(entries, Globals.prefs.getUpdateFieldPreferences());
            boolean markEntries = !this.openInNew && EntryMarker.shouldMarkEntries();
            for (BibEntry entry : entries) {
                if (markEntries) {
                    EntryMarker.markEntry(entry, 6, false, new NamedCompound(""));
                }
                database.insertEntry(entry);
            }
        }
        if (!anythingUseful) {
            return null;
        }
        if (imports.size() == 1 && directParserResult != null) {
            return directParserResult;
        }
        return new ParserResult(database);
    }

    class MyWorker
    extends AbstractWorker {
        private List<Path> filenames;
        private ParserResult bibtexResult;
        private boolean fileOk;

        MyWorker() {
        }

        @Override
        public void init() {
            ImportMenuItem.this.importError = null;
            FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().withInitialDirectory(Globals.prefs.get("workingDirectory")).build();
            FXDialogService ds = new FXDialogService();
            this.filenames = DefaultTaskExecutor.runInJavaFXThread(() -> ds.showFileOpenDialogAndGetMultipleFiles(fileDialogConfiguration));
            if (!this.filenames.isEmpty()) {
                ImportMenuItem.this.frame.block();
                ImportMenuItem.this.frame.output(Localization.lang("Starting import", new String[0]));
                this.fileOk = true;
                Globals.prefs.put("workingDirectory", this.filenames.get(0).getParent().toString());
            }
        }

        @Override
        public void run() {
            ParserResult pr;
            if (!this.fileOk) {
                return;
            }
            ArrayList<ImportFormatReader.UnknownFormatImport> imports = new ArrayList<ImportFormatReader.UnknownFormatImport>();
            for (Path filename : this.filenames) {
                try {
                    if (ImportMenuItem.this.importer == null) {
                        ImportMenuItem.this.frame.output(Localization.lang("Importing in unknown format", new String[0]) + "...");
                        imports.add(Globals.IMPORT_FORMAT_READER.importUnknownFormat(filename, Globals.getFileUpdateMonitor()));
                        continue;
                    }
                    ImportMenuItem.this.frame.output(Localization.lang("Importing in %0 format", ImportMenuItem.this.importer.getName()) + "...");
                    pr = ImportMenuItem.this.importer.importDatabase(filename, Globals.prefs.getDefaultEncoding());
                    imports.add(new ImportFormatReader.UnknownFormatImport(ImportMenuItem.this.importer.getName(), pr));
                }
                catch (IOException | ImportException e) {
                    ImportMenuItem.this.importError = e;
                }
            }
            this.bibtexResult = ImportMenuItem.this.mergeImportResults(imports);
            for (ImportFormatReader.UnknownFormatImport p : imports) {
                if (p == null) continue;
                pr = p.parserResult;
                ParserResultWarningDialog.showParserResultWarningDialog(pr, ImportMenuItem.this.frame);
            }
        }

        @Override
        public void update() {
            if (!this.fileOk) {
                return;
            }
            if (this.bibtexResult == null) {
                if (ImportMenuItem.this.importer == null) {
                    ImportMenuItem.this.frame.output(Localization.lang("Could not find a suitable import format.", new String[0]));
                } else if (ImportMenuItem.this.importError == null) {
                    JOptionPane.showMessageDialog(ImportMenuItem.this.frame, Localization.lang("No entries found. Please make sure you are using the correct import filter.", new String[0]), Localization.lang("Import failed", new String[0]), 0);
                } else {
                    JOptionPane.showMessageDialog(ImportMenuItem.this.frame, ImportMenuItem.this.importError.getMessage(), Localization.lang("Import failed", new String[0]), 0);
                }
            } else if (ImportMenuItem.this.openInNew) {
                ImportMenuItem.this.frame.addTab(this.bibtexResult.getDatabaseContext(), true);
                ImportMenuItem.this.frame.output(Localization.lang("Imported entries", new String[0]) + ": " + this.bibtexResult.getDatabase().getEntryCount());
            } else {
                BasePanel panel = (BasePanel)ImportMenuItem.this.frame.getTabbedPane().getSelectedComponent();
                ImportInspectionDialog diag = new ImportInspectionDialog(ImportMenuItem.this.frame, panel, Localization.lang("Import", new String[0]), ImportMenuItem.this.openInNew);
                diag.addEntries((Collection<BibEntry>)this.bibtexResult.getDatabase().getEntries());
                diag.entryListComplete();
                diag.setLocationRelativeTo(ImportMenuItem.this.frame);
                diag.setVisible(true);
                diag.toFront();
            }
            ImportMenuItem.this.frame.unblock();
        }
    }
}

