/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.groups;

import com.google.common.eventbus.Subscribe;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.IconTheme;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.SidePaneComponent;
import org.jabref.gui.SidePaneManager;
import org.jabref.gui.customjfx.CustomJFXPanel;
import org.jabref.gui.groups.GroupTreeView;
import org.jabref.gui.groups.GroupingWorker;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.maintable.MainTableDataModel;
import org.jabref.logic.groups.DefaultGroupsFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.event.FieldChangedEvent;
import org.jabref.model.groups.GroupTreeNode;
import org.jabref.model.search.matchers.MatcherSet;
import org.jabref.model.search.matchers.MatcherSets;

public class GroupSidePane
extends SidePaneComponent {
    protected final JabRefFrame frame;
    private final SidePaneComponent.ToggleAction toggleAction;

    public GroupSidePane(JabRefFrame frame, SidePaneManager manager) {
        super(manager, IconTheme.JabRefIcon.TOGGLE_GROUPS.getIcon(), Localization.lang("Groups", new String[0]));
        Globals.stateManager.activeGroupProperty().addListener((observable, oldValue, newValue) -> this.updateShownEntriesAccordingToSelectedGroups((List<GroupTreeNode>)newValue));
        Globals.stateManager.activeDatabaseProperty().addListener((observable, oldValue, newValue) -> {
            newValue.ifPresent(databaseContext -> databaseContext.getDatabase().registerListener(this));
            oldValue.ifPresent(databaseContext -> databaseContext.getDatabase().unregisterListener(this));
        });
        this.toggleAction = (SidePaneComponent)this.new SidePaneComponent.ToggleAction(Localization.menuTitle("Toggle groups interface", new String[0]), Localization.lang("Toggle groups interface", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.TOGGLE_GROUPS_INTERFACE), IconTheme.JabRefIcon.TOGGLE_GROUPS);
        this.frame = frame;
        JFXPanel groupsPane = CustomJFXPanel.create();
        this.add((Component)groupsPane);
        Platform.runLater(() -> {
            StackPane root = new StackPane();
            root.getChildren().addAll((Object[])new Node[]{new GroupTreeView().getView()});
            Scene scene = new Scene((Parent)root);
            groupsPane.setScene(scene);
        });
    }

    @Subscribe
    public synchronized void listen(FieldChangedEvent event) {
        if ("groups".equals(event.getFieldName())) {
            this.updateShownEntriesAccordingToSelectedGroups((List<GroupTreeNode>)Globals.stateManager.activeGroupProperty());
        }
    }

    private void updateShownEntriesAccordingToSelectedGroups(List<GroupTreeNode> selectedGroups) {
        if (selectedGroups == null || selectedGroups.isEmpty()) {
            selectedGroups = Collections.singletonList(new GroupTreeNode(DefaultGroupsFactory.getAllEntriesGroup()));
        }
        MatcherSet searchRules = MatcherSets.build(Globals.prefs.getBoolean("groupIntersectSelections") ? MatcherSets.MatcherType.AND : MatcherSets.MatcherType.OR);
        for (GroupTreeNode node : selectedGroups) {
            searchRules.addRule(node.getSearchMatcher());
        }
        GroupingWorker worker = new GroupingWorker(this.frame, this.panel);
        worker.run(searchRules);
        worker.update();
    }

    @Override
    public void componentOpening() {
        Globals.prefs.putBoolean("groupSidepaneVisible", Boolean.TRUE);
    }

    @Override
    public int getRescalingWeight() {
        return 1;
    }

    @Override
    public void componentClosing() {
        if (this.panel != null) {
            this.panel.getMainTable().getTableModel().updateGroupingState(MainTableDataModel.DisplayOption.DISABLED);
        }
        this.getToggleAction().setSelected(false);
        Globals.prefs.putBoolean("groupSidepaneVisible", Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActiveBasePanel(BasePanel panel) {
        super.setActiveBasePanel(panel);
        if (panel == null) {
            this.frame.getSidePaneManager().hide(GroupSidePane.class);
            return;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            this.validateTree();
        }
    }

    @Override
    public void grabFocus() {
    }

    @Override
    public SidePaneComponent.ToggleAction getToggleAction() {
        return this.toggleAction;
    }
}

