/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jabref.gui.GUIGlobals;
import org.jabref.gui.customjfx.CustomJFXPanel;
import org.jabref.gui.fieldeditors.EditorTextArea;
import org.jabref.gui.fieldeditors.FieldEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextArea
implements FieldEditor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextArea.class);
    private final JFXPanel swingPanel;
    private final EditorTextArea textArea;
    private String fieldName;

    public TextArea(String fieldName, String content) {
        this(fieldName, content, "");
    }

    public TextArea(String fieldName, String content, String title) {
        this.textArea = new EditorTextArea(content);
        this.textArea.setPromptText(title);
        this.swingPanel = CustomJFXPanel.wrap(new Scene((Parent)this.textArea));
        this.swingPanel.setBackground(GUIGlobals.activeBackgroundColor);
        this.fieldName = fieldName;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String newName) {
        this.fieldName = newName;
    }

    @Override
    public void setBackground(Color color) {
    }

    @Override
    public JComponent getPane() {
        return this.swingPanel;
    }

    @Override
    public JComponent getTextComponent() {
        return null;
    }

    @Override
    public boolean hasFocus() {
        return false;
    }

    @Override
    public void setActiveBackgroundColor() {
        this.setBackgroundColor(GUIGlobals.activeBackgroundColor);
    }

    @Override
    public void setValidBackgroundColor() {
        this.setBackgroundColor(GUIGlobals.validFieldBackgroundColor);
    }

    @Override
    public void setInvalidBackgroundColor() {
        this.setBackgroundColor(GUIGlobals.invalidFieldBackgroundColor);
    }

    private void setBackgroundColor(Color color) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setBackground(color);
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> this.setBackground(color));
            }
            catch (InterruptedException | InvocationTargetException e) {
                LOGGER.info("Problem setting background color", e);
            }
        }
    }

    @Override
    public String getText() {
        return this.textArea.getText();
    }

    @Override
    public void setText(String newText) {
        this.textArea.setText(newText);
    }

    @Override
    public void append(String text) {
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public void paste(String textToInsert) {
    }

    @Override
    public String getSelectedText() {
        return null;
    }

    @Override
    public void undo() {
    }

    @Override
    public void redo() {
    }

    @Override
    public void requestFocus() {
    }
}

