/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.jabref.gui.DialogService;
import org.jabref.gui.autocompleter.AutoCompleteSuggestionProvider;
import org.jabref.gui.externalfiles.AutoSetFileLinksUtil;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.gui.externalfiletype.UnknownExternalFileType;
import org.jabref.gui.fieldeditors.AbstractEditorViewModel;
import org.jabref.gui.fieldeditors.LinkedFileViewModel;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.importer.FulltextFetchers;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.FileFieldParser;
import org.jabref.model.entry.FileFieldWriter;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.util.FileHelper;
import org.jabref.preferences.JabRefPreferences;

public class LinkedFilesEditorViewModel
extends AbstractEditorViewModel {
    private final ListProperty<LinkedFileViewModel> files = new SimpleListProperty(FXCollections.observableArrayList(LinkedFileViewModel::getObservables));
    private final BooleanProperty fulltextLookupInProgress = new SimpleBooleanProperty(false);
    private final DialogService dialogService;
    private final BibDatabaseContext databaseContext;
    private final TaskExecutor taskExecutor;
    private final JabRefPreferences preferences;

    public LinkedFilesEditorViewModel(String fieldName, AutoCompleteSuggestionProvider<?> suggestionProvider, DialogService dialogService, BibDatabaseContext databaseContext, TaskExecutor taskExecutor, FieldCheckers fieldCheckers, JabRefPreferences preferences) {
        super(fieldName, suggestionProvider, fieldCheckers);
        this.dialogService = dialogService;
        this.databaseContext = databaseContext;
        this.taskExecutor = taskExecutor;
        this.preferences = preferences;
        BindingsHelper.bindContentBidirectional(this.files, this.text, LinkedFilesEditorViewModel::getStringRepresentation, this::parseToFileViewModel);
    }

    private static String getStringRepresentation(List<LinkedFileViewModel> files) {
        List<LinkedFile> filesToSerialize = files.stream().filter(file -> !file.isAutomaticallyFound()).map(LinkedFileViewModel::getFile).collect(Collectors.toList());
        return FileFieldWriter.getStringRepresentation(filesToSerialize);
    }

    public static LinkedFile fromFile(Path file, List<Path> fileDirectories) {
        String fileExtension = FileHelper.getFileExtension(file).orElse("");
        ExternalFileType suggestedFileType = ExternalFileTypes.getInstance().getExternalFileTypeByExt(fileExtension).orElse(new UnknownExternalFileType(fileExtension));
        Path relativePath = FileUtil.shortenFileName(file, fileDirectories);
        return new LinkedFile("", relativePath.toString(), suggestedFileType.getName());
    }

    public LinkedFileViewModel fromFile(Path file) {
        List<Path> fileDirectories = this.databaseContext.getFileDirectoriesAsPaths(this.preferences.getFileDirectoryPreferences());
        LinkedFile linkedFile = LinkedFilesEditorViewModel.fromFile(file, fileDirectories);
        return new LinkedFileViewModel(linkedFile, this.entry, this.databaseContext, this.taskExecutor);
    }

    public boolean isFulltextLookupInProgress() {
        return this.fulltextLookupInProgress.get();
    }

    public BooleanProperty fulltextLookupInProgressProperty() {
        return this.fulltextLookupInProgress;
    }

    private List<LinkedFileViewModel> parseToFileViewModel(String stringValue) {
        return FileFieldParser.parse(stringValue).stream().map(linkedFile -> new LinkedFileViewModel((LinkedFile)linkedFile, this.entry, this.databaseContext, this.taskExecutor)).collect(Collectors.toList());
    }

    public ObservableList<LinkedFileViewModel> getFiles() {
        return (ObservableList)this.files.get();
    }

    public ListProperty<LinkedFileViewModel> filesProperty() {
        return this.files;
    }

    public void addNewFile() {
        Path workingDirectory = this.databaseContext.getFirstExistingFileDir(this.preferences.getFileDirectoryPreferences()).orElse(Paths.get(this.preferences.get("workingDirectory"), new String[0]));
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().withInitialDirectory(workingDirectory).build();
        List<Path> fileDirectories = this.databaseContext.getFileDirectoriesAsPaths(this.preferences.getFileDirectoryPreferences());
        this.dialogService.showFileOpenDialog(fileDialogConfiguration).ifPresent(newFile -> {
            LinkedFile newLinkedFile = LinkedFilesEditorViewModel.fromFile(newFile, fileDirectories);
            this.files.add((Object)new LinkedFileViewModel(newLinkedFile, this.entry, this.databaseContext, this.taskExecutor));
        });
    }

    @Override
    public void bindToEntry(BibEntry entry) {
        super.bindToEntry(entry);
        if (entry != null) {
            BackgroundTask<List> findAssociatedNotLinkedFiles = BackgroundTask.wrap(() -> this.findAssociatedNotLinkedFiles(entry)).onSuccess(arg_0 -> this.files.addAll(arg_0));
            this.taskExecutor.execute(findAssociatedNotLinkedFiles);
        }
    }

    private List<LinkedFileViewModel> findAssociatedNotLinkedFiles(BibEntry entry) {
        ArrayList<LinkedFileViewModel> result = new ArrayList<LinkedFileViewModel>();
        AutoSetFileLinksUtil util = new AutoSetFileLinksUtil(this.databaseContext, this.preferences.getFileDirectoryPreferences(), this.preferences.getAutoLinkPreferences(), ExternalFileTypes.getInstance());
        try {
            List<LinkedFile> linkedFiles = util.findAssociatedNotLinkedFiles(entry);
            for (LinkedFile linkedFile : linkedFiles) {
                LinkedFileViewModel newLinkedFile = new LinkedFileViewModel(linkedFile, entry, this.databaseContext, this.taskExecutor);
                newLinkedFile.markAsAutomaticallyFound();
                result.add(newLinkedFile);
            }
        }
        catch (IOException e) {
            this.dialogService.showErrorDialogAndWait("Error accessing the file system", e);
        }
        return result;
    }

    public void fetchFulltext() {
        FulltextFetchers fetcher = new FulltextFetchers(this.preferences.getImportFormatPreferences());
        BackgroundTask.wrap(() -> fetcher.findFullTextPDF(this.entry)).onRunning(() -> this.fulltextLookupInProgress.setValue(Boolean.valueOf(true))).onFinished(() -> this.fulltextLookupInProgress.setValue(Boolean.valueOf(false))).onSuccess(url -> {
            if (url.isPresent()) {
                this.addFromURL((URL)url.get());
            } else {
                this.dialogService.notify(Localization.lang("No full text document found", new String[0]));
            }
        }).executeWith(this.taskExecutor);
    }

    public void addFromURL() {
        Optional<String> urlText = this.dialogService.showInputDialogAndWait(Localization.lang("Download file", new String[0]), Localization.lang("Enter URL to download", new String[0]));
        if (urlText.isPresent()) {
            try {
                URL url = new URL(urlText.get());
                this.addFromURL(url);
            }
            catch (MalformedURLException exception) {
                this.dialogService.showErrorDialogAndWait(Localization.lang("Invalid URL", new String[0]), exception);
            }
        }
    }

    private void addFromURL(URL url) {
        LinkedFileViewModel onlineFile = new LinkedFileViewModel(new LinkedFile(url, ""), this.entry, this.databaseContext, this.taskExecutor);
        this.files.add((Object)onlineFile);
        onlineFile.download();
    }

    public void deleteFile(LinkedFileViewModel file) {
        if (file.getFile().isOnlineLink()) {
            this.removeFileLink(file);
        } else {
            boolean deleteSuccessful = file.delete(this.preferences.getFileDirectoryPreferences());
            if (deleteSuccessful) {
                this.files.remove((Object)file);
            }
        }
    }

    public void removeFileLink(LinkedFileViewModel file) {
        this.files.remove((Object)file);
    }
}

