/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.externalfiletype;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.jabref.Globals;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.gui.externalfiletype.UnknownExternalFileType;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalFileMenuItem
extends JMenuItem
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalFileMenuItem.class);
    private final BibEntry entry;
    private final String link;
    private final BibDatabaseContext databaseContext;
    private Optional<ExternalFileType> fileType;
    private final JabRefFrame frame;
    private String fieldName;

    public ExternalFileMenuItem(JabRefFrame frame, BibEntry entry, String name, String link, Icon icon, BibDatabaseContext databaseContext, Optional<ExternalFileType> fileType) {
        super(name, icon);
        this.frame = frame;
        this.entry = entry;
        this.link = link;
        this.databaseContext = databaseContext;
        this.fileType = fileType;
        this.addActionListener(this);
    }

    public ExternalFileMenuItem(JabRefFrame frame, BibEntry entry, String name, String link, Icon icon, BibDatabaseContext databaseContext, String fieldName) {
        this(frame, entry, name, link, icon, databaseContext, Optional.empty());
        this.fieldName = fieldName;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean success = this.openLink();
        if (!success) {
            List<Path> searchedDirs = this.databaseContext.getFileDirectoriesAsPaths(Globals.prefs.getFileDirectoryPreferences());
            this.frame.output(Localization.lang("Unable to open %0", this.link) + " " + Arrays.toString(searchedDirs.toArray()));
        }
    }

    private boolean openLink() {
        this.frame.output(Localization.lang("External viewer called", new String[0]) + ".");
        try {
            Optional<ExternalFileType> type = this.fileType;
            if (!this.fileType.isPresent()) {
                if (this.fieldName == null) {
                    Optional<String> extension = FileHelper.getFileExtension(this.link);
                    this.fileType = type = ExternalFileTypes.getInstance().getExternalFileTypeByExt(extension.orElse(null));
                } else {
                    JabRefDesktop.openExternalViewer(this.databaseContext, this.link, this.fieldName);
                    return true;
                }
            }
            if (type.isPresent() && type.get() instanceof UnknownExternalFileType) {
                return JabRefDesktop.openExternalFileUnknown(this.frame, this.entry, this.databaseContext, this.link, (UnknownExternalFileType)type.get());
            }
            return JabRefDesktop.openExternalFileAnyFormat(this.databaseContext, this.link, type);
        }
        catch (IOException ex) {
            if (this.fileType.isPresent() && !this.fileType.get().getOpenWithApplication().isEmpty() && ex.getMessage().contains(this.fileType.get().getOpenWithApplication())) {
                JOptionPane.showMessageDialog(this.frame, Localization.lang("Unable to open link. The application '%0' associated with the file type '%1' could not be called.", this.fileType.get().getOpenWithApplication(), this.fileType.get().getName()), Localization.lang("Could not open link", new String[0]), 0);
                return false;
            }
            LOGGER.warn("Unable to open link", ex);
            return false;
        }
    }
}

