/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.errorconsole;

import java.util.List;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javax.inject.Inject;
import org.jabref.gui.AbstractController;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.IconTheme;
import org.jabref.gui.errorconsole.ErrorConsoleViewModel;
import org.jabref.gui.errorconsole.LogEventViewModel;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.keyboard.KeyBindingRepository;
import org.jabref.logic.util.BuildInfo;

public class ErrorConsoleController
extends AbstractController<ErrorConsoleViewModel> {
    @FXML
    private Button copyLogButton;
    @FXML
    private Button clearLogButton;
    @FXML
    private Button createIssueButton;
    @FXML
    private ListView<LogEventViewModel> messagesListView;
    @FXML
    private Label descriptionLabel;
    @Inject
    private DialogService dialogService;
    @Inject
    private ClipBoardManager clipBoardManager;
    @Inject
    private BuildInfo buildInfo;
    @Inject
    private KeyBindingRepository keyBindingRepository;

    @FXML
    private void initialize() {
        this.viewModel = new ErrorConsoleViewModel(this.dialogService, this.clipBoardManager, this.buildInfo);
        this.messagesListView.setCellFactory(this.createCellFactory());
        this.messagesListView.itemsProperty().bind(((ErrorConsoleViewModel)this.viewModel).allMessagesDataProperty());
        this.messagesListView.scrollTo(((ErrorConsoleViewModel)this.viewModel).allMessagesDataProperty().getSize() - 1);
        this.messagesListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        ((ErrorConsoleViewModel)this.viewModel).allMessagesDataProperty().addListener(change -> {
            int size = ((ErrorConsoleViewModel)this.viewModel).allMessagesDataProperty().size();
            if (size > 0) {
                this.messagesListView.scrollTo(size - 1);
            }
        });
        this.descriptionLabel.setGraphic(IconTheme.JabRefIcon.CONSOLE.getGraphicNode());
    }

    private Callback<ListView<LogEventViewModel>, ListCell<LogEventViewModel>> createCellFactory() {
        return cell -> new ListCell<LogEventViewModel>(){
            private HBox graphic = new HBox(10.0);
            private Node icon;
            private VBox message;
            private Label heading = new Label();
            private Label stacktrace = new Label();
            {
                this.message = new VBox();
                this.message.getChildren().setAll((Object[])new Node[]{this.heading, this.stacktrace});
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            }

            public void updateItem(LogEventViewModel event, boolean empty) {
                super.updateItem((Object)event, empty);
                if (event == null || empty) {
                    this.setGraphic(null);
                } else {
                    this.icon = event.getIcon().getGraphicNode();
                    this.heading.setText(event.getDisplayText());
                    this.heading.getStyleClass().setAll((Object[])new String[]{event.getStyleClass()});
                    this.stacktrace.setText(event.getStackTrace().orElse(""));
                    this.graphic.getStyleClass().setAll((Object[])new String[]{event.getStyleClass()});
                    this.graphic.getChildren().setAll((Object[])new Node[]{this.icon, this.message});
                    this.setGraphic((Node)this.graphic);
                }
            }
        };
    }

    @FXML
    private void copySelectedLogEntries(KeyEvent event) {
        if (this.keyBindingRepository.checkKeyCombinationEquality(KeyBinding.COPY, event)) {
            ObservableList selectedEntries = this.messagesListView.getSelectionModel().getSelectedItems();
            ((ErrorConsoleViewModel)this.viewModel).copyLog((List<LogEventViewModel>)selectedEntries);
        }
    }

    @FXML
    private void copyLog() {
        ((ErrorConsoleViewModel)this.viewModel).copyLog();
    }

    @FXML
    private void clearLog() {
        ((ErrorConsoleViewModel)this.viewModel).clearLog();
    }

    @FXML
    private void createIssue() {
        ((ErrorConsoleViewModel)this.viewModel).reportIssue();
    }

    @FXML
    private void closeErrorDialog() {
        this.getStage().close();
    }
}

