/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor.fileannotationtab;

import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.jabref.logic.formatter.bibtexfields.RemoveHyphenatedNewlinesFormatter;
import org.jabref.logic.formatter.bibtexfields.RemoveNewlinesFormatter;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.pdf.FileAnnotation;
import org.jabref.model.pdf.FileAnnotationType;

public class FileAnnotationViewModel {
    private final FileAnnotation annotation;
    private StringProperty author = new SimpleStringProperty();
    private StringProperty page = new SimpleStringProperty();
    private StringProperty date = new SimpleStringProperty();
    private StringProperty content = new SimpleStringProperty();
    private StringProperty marking = new SimpleStringProperty();

    public FileAnnotationViewModel(FileAnnotation annotation) {
        this.annotation = annotation;
        this.author.set((Object)annotation.getAuthor());
        this.page.set((Object)Integer.toString(annotation.getPage()));
        this.date.set((Object)annotation.getTimeModified().toString().replace('T', ' '));
        this.setupContentProperties(annotation);
    }

    private void setupContentProperties(FileAnnotation annotation) {
        if (annotation.hasLinkedAnnotation()) {
            this.content.set((Object)annotation.getLinkedFileAnnotation().getContent());
            String annotationContent = annotation.getContent();
            String illegibleTextMessage = Localization.lang("The marked area does not contain any legible text!", new String[0]);
            this.marking.set((Object)(annotationContent.isEmpty() ? illegibleTextMessage : annotationContent));
        } else {
            String content = annotation.getContent();
            content = new RemoveHyphenatedNewlinesFormatter().format(content);
            content = new RemoveNewlinesFormatter().format(content);
            this.content.set((Object)content);
            this.marking.set((Object)"");
        }
    }

    public String getAuthor() {
        return (String)this.author.get();
    }

    public String getPage() {
        return (String)this.page.get();
    }

    public String getDate() {
        return (String)this.date.get();
    }

    public String getContent() {
        return (String)this.content.get();
    }

    public StringProperty pageProperty() {
        return this.page;
    }

    public StringProperty dateProperty() {
        return this.date;
    }

    public StringProperty contentProperty() {
        return this.content;
    }

    public StringProperty markingProperty() {
        return this.marking;
    }

    public StringProperty authorProperty() {
        return this.author;
    }

    public String toString() {
        if (this.annotation.hasLinkedAnnotation() && this.getContent().isEmpty()) {
            if (FileAnnotationType.UNDERLINE.equals((Object)this.annotation.getAnnotationType())) {
                return Localization.lang("Empty Underline", new String[0]);
            }
            if (FileAnnotationType.HIGHLIGHT.equals((Object)this.annotation.getAnnotationType())) {
                return Localization.lang("Empty Highlight", new String[0]);
            }
            return Localization.lang("Empty Marking", new String[0]);
        }
        if (FileAnnotationType.UNDERLINE.equals((Object)this.annotation.getAnnotationType())) {
            return Localization.lang("Underline", new String[0]) + ": " + this.getContent();
        }
        if (FileAnnotationType.HIGHLIGHT.equals((Object)this.annotation.getAnnotationType())) {
            return Localization.lang("Highlight", new String[0]) + ": " + this.getContent();
        }
        return super.toString();
    }

    public String getMarking() {
        return (String)this.marking.get();
    }
}

