/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor.fileannotationtab;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextArea;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import javax.inject.Inject;
import org.fxmisc.easybind.EasyBind;
import org.jabref.gui.AbstractController;
import org.jabref.gui.entryeditor.fileannotationtab.FileAnnotationTabViewModel;
import org.jabref.gui.entryeditor.fileannotationtab.FileAnnotationViewModel;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.pdf.FileAnnotationCache;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.util.FileUpdateMonitor;

public class FileAnnotationTabController
extends AbstractController<FileAnnotationTabViewModel> {
    @FXML
    public ComboBox<Path> files;
    @FXML
    public ListView<FileAnnotationViewModel> annotationList;
    @FXML
    public Label author;
    @FXML
    public Label page;
    @FXML
    public Label date;
    @FXML
    public TextArea content;
    @FXML
    public TextArea marking;
    @FXML
    public GridPane grid;
    @Inject
    private FileAnnotationCache fileAnnotationCache;
    @Inject
    private BibEntry entry;
    @Inject
    private FileUpdateMonitor fileMonitor;

    @FXML
    public void initialize() {
        this.viewModel = new FileAnnotationTabViewModel(this.fileAnnotationCache, this.entry, this.fileMonitor);
        this.files.getItems().setAll((Collection)((FileAnnotationTabViewModel)this.viewModel).filesProperty().get());
        this.files.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> ((FileAnnotationTabViewModel)this.viewModel).notifyNewSelectedFile((Path)newValue));
        this.files.getSelectionModel().selectFirst();
        this.annotationList.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.annotationList.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> ((FileAnnotationTabViewModel)this.viewModel).notifyNewSelectedAnnotation((FileAnnotationViewModel)newValue));
        ViewModelListCellFactory cellFactory = new ViewModelListCellFactory().withTooltip(FileAnnotationViewModel::getMarking).withGraphic(annotation -> this.createFileAnnotationNode((FileAnnotationViewModel)annotation));
        this.annotationList.setCellFactory(cellFactory);
        this.annotationList.setPlaceholder((Node)new Label(Localization.lang("File has no attached annotations", new String[0])));
        Bindings.bindContent((List)((List)this.annotationList.itemsProperty().get()), ((FileAnnotationTabViewModel)this.viewModel).annotationsProperty());
        this.annotationList.getSelectionModel().selectFirst();
        ((ObservableList)this.annotationList.itemsProperty().get()).addListener(c -> this.annotationList.getSelectionModel().selectFirst());
        this.content.textProperty().bind(EasyBind.select(((FileAnnotationTabViewModel)this.viewModel).currentAnnotationProperty()).selectObject(FileAnnotationViewModel::contentProperty));
        this.marking.textProperty().bind(EasyBind.select(((FileAnnotationTabViewModel)this.viewModel).currentAnnotationProperty()).selectObject(FileAnnotationViewModel::markingProperty));
        this.grid.disableProperty().bind((ObservableValue)((FileAnnotationTabViewModel)this.viewModel).isAnnotationsEmpty());
    }

    private Node createFileAnnotationNode(FileAnnotationViewModel annotation) {
        GridPane node = new GridPane();
        ColumnConstraints firstColumn = new ColumnConstraints();
        ColumnConstraints secondColumn = new ColumnConstraints();
        firstColumn.setPercentWidth(70.0);
        secondColumn.setPercentWidth(30.0);
        firstColumn.setHalignment(HPos.LEFT);
        secondColumn.setHalignment(HPos.RIGHT);
        node.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{firstColumn, secondColumn});
        RowConstraints firstRow = new RowConstraints();
        RowConstraints secondRow = new RowConstraints();
        firstRow.setMinHeight(10.0);
        firstRow.setPrefHeight(15.0);
        secondRow.setMinHeight(10.0);
        secondRow.setPrefHeight(35.0);
        node.getRowConstraints().addAll((Object[])new RowConstraints[]{firstRow, secondRow});
        Label marking = new Label(annotation.getMarking());
        Label author = new Label(annotation.getAuthor());
        Label date = new Label(annotation.getDate());
        Label page = new Label(Localization.lang("Page", new String[0]) + ": " + annotation.getPage());
        marking.setFont(new Font("System Bold", 15.0));
        marking.setPrefWidth(250.0);
        author.setFont(new Font("System", 14.0));
        marking.setPrefHeight(10.0);
        author.setPrefHeight(30.0);
        date.setPrefHeight(10.0);
        page.setPrefHeight(30.0);
        marking.setTextAlignment(TextAlignment.LEFT);
        marking.setAlignment(Pos.TOP_LEFT);
        author.setTextAlignment(TextAlignment.LEFT);
        author.setAlignment(Pos.TOP_LEFT);
        date.setTextAlignment(TextAlignment.RIGHT);
        date.setAlignment(Pos.TOP_RIGHT);
        page.setTextAlignment(TextAlignment.RIGHT);
        page.setAlignment(Pos.TOP_RIGHT);
        node.add((Node)marking, 0, 0);
        node.add((Node)author, 0, 1);
        node.add((Node)date, 1, 0);
        node.add((Node)page, 1, 1);
        return node;
    }

    public void copy(ActionEvent event) {
        ((FileAnnotationTabViewModel)this.viewModel).copyCurrentAnnotation();
    }
}

