/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.desktop.os;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.StringJoiner;
import org.jabref.gui.desktop.os.NativeDesktop;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.preferences.JabRefPreferences;

public class Linux
implements NativeDesktop {
    @Override
    public void openFile(String filePath, String fileType) throws IOException {
        Optional<ExternalFileType> type = ExternalFileTypes.getInstance().getExternalFileTypeByExt(fileType);
        String viewer = type.isPresent() && !type.get().getOpenWithApplication().isEmpty() ? type.get().getOpenWithApplication() : "xdg-open";
        String[] cmdArray = new String[]{viewer, filePath};
        Runtime.getRuntime().exec(cmdArray);
    }

    @Override
    public void openFileWithApplication(String filePath, String application) throws IOException {
        String[] openWith = application != null && !application.isEmpty() ? application.split(" ") : new String[]{"xdg-open"};
        String[] cmdArray = new String[openWith.length + 1];
        System.arraycopy(openWith, 0, cmdArray, 0, openWith.length);
        cmdArray[cmdArray.length - 1] = filePath;
        Runtime.getRuntime().exec(cmdArray);
    }

    @Override
    public void openFolderAndSelectFile(Path filePath) throws IOException {
        String desktopSession = System.getenv("DESKTOP_SESSION").toLowerCase(Locale.ROOT);
        String cmd = desktopSession.contains("gnome") ? "nautilus" + filePath.toString().replace(" ", "\\ ") : (desktopSession.contains("kde") ? "dolphin --select " + filePath.toString().replace(" ", "\\ ") : "xdg-open " + filePath.toAbsolutePath().getParent().toString());
        Runtime.getRuntime().exec(cmd);
    }

    @Override
    public void openConsole(String absolutePath) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        Process p = runtime.exec("readlink /etc/alternatives/x-terminal-emulator");
        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String emulatorName = reader.readLine();
        if (emulatorName != null) {
            if ((emulatorName = emulatorName.substring(emulatorName.lastIndexOf(File.separator) + 1)).contains("gnome")) {
                runtime.exec("gnome-terminal --working-directory=" + absolutePath);
            } else if (emulatorName.contains("xfce4")) {
                runtime.exec("xfce4-terminal --working-directory=" + absolutePath);
            } else if (emulatorName.contains("konsole")) {
                runtime.exec("konsole --workdir=" + absolutePath);
            } else {
                runtime.exec(emulatorName, null, new File(absolutePath));
            }
        }
    }

    @Override
    public void openPdfWithParameters(String filePath, List<String> parameters) throws IOException {
        if (JabRefPreferences.getInstance().get("usePDFReader").equals(JabRefPreferences.getInstance().get("adobeAcrobatCommand"))) {
            String application = "acroread";
            StringJoiner sj = new StringJoiner(" ");
            sj.add(application);
            parameters.forEach(param2 -> sj.add((CharSequence)param2));
            this.openFileWithApplication(filePath, sj.toString());
        } else {
            this.openFile(filePath, "PDF");
        }
    }

    @Override
    public String detectProgramPath(String programName, String directoryName) {
        return programName;
    }

    @Override
    public Path getApplicationDirectory() {
        return Paths.get("/usr/lib/", new String[0]);
    }
}

