/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.contentselector;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.jabref.gui.BasePanel;
import org.jabref.gui.JabRefDialog;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.help.HelpAction;
import org.jabref.gui.keyboard.KeyBinder;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.metadata.ContentSelector;
import org.jabref.model.metadata.ContentSelectors;
import org.jabref.model.metadata.MetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentSelectorDialog
extends JabRefDialog {
    private static final String WORD_FIRSTLINE_TEXT = Localization.lang("<select word>", new String[0]);
    private static final String FIELD_FIRST_LINE = Localization.lang("<field name>", new String[0]);
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentSelectorDialog.class);
    private final GridBagLayout gbl = new GridBagLayout();
    private final GridBagConstraints con = new GridBagConstraints();
    private final JPanel fieldPan = new JPanel();
    private final JPanel wordPan = new JPanel();
    private final JPanel buttonPan = new JPanel();
    private final JPanel fieldNamePan = new JPanel();
    private final JPanel wordEditPan = new JPanel();
    private final MetaData metaData;
    private final JabRefFrame frame;
    private final BasePanel panel;
    private final JButton newField = new JButton(Localization.lang("New", new String[0]));
    private final JButton removeField = new JButton(Localization.lang("Remove", new String[0]));
    private final JButton newWord = new JButton(Localization.lang("New", new String[0]));
    private final JButton removeWord = new JButton(Localization.lang("Remove", new String[0]));
    private final JButton ok = new JButton(Localization.lang("OK", new String[0]));
    private final JButton cancel = new JButton();
    private final JButton apply = new JButton(Localization.lang("Apply", new String[0]));
    private final DefaultListModel<String> fieldListModel = new DefaultListModel();
    private final JList<String> fieldList = new JList<String>(this.fieldListModel);
    private final JTextField fieldNameField = new JTextField("", 20);
    private final JTextField wordEditField = new JTextField("", 20);
    private final JScrollPane fPane = new JScrollPane(this.fieldList);
    private final Map<String, DefaultListModel<String>> wordListModels = new HashMap<String, DefaultListModel<String>>();
    private final List<String> removedFields = new ArrayList<String>();
    private DefaultListModel<String> wordListModel = new DefaultListModel();
    private JList<String> wordList = new JList<String>(this.wordListModel);
    private JScrollPane wPane = new JScrollPane(this.wordList);
    private String currentField;

    public ContentSelectorDialog(Window owner, JabRefFrame frame, BasePanel panel, boolean modal, String fieldName) {
        super(owner, Localization.lang("Manage content selectors", new String[0]), ContentSelectorDialog.class);
        this.setModal(modal);
        this.metaData = panel.getBibDatabaseContext().getMetaData();
        this.frame = frame;
        this.panel = panel;
        this.currentField = fieldName;
        this.initLayout();
        this.setupFieldSelector();
        if (this.currentField != null) {
            int fieldInd = this.fieldListModel.indexOf(this.currentField);
            if (fieldInd >= 0) {
                this.fieldList.setSelectedIndex(fieldInd);
            }
        } else if (!this.fieldListModel.isEmpty()) {
            this.fieldList.setSelectedIndex(0);
            this.currentField = this.fieldList.getSelectedValue();
        }
        this.setupWordSelector();
        this.setupActions();
        KeyBinder.bindCloseDialogKeyToCancelAction(this.rootPane, this.cancel.getAction());
        this.pack();
    }

    private static int findPos(DefaultListModel<String> lm, String item) {
        for (int i = 0; i < lm.size(); ++i) {
            String s2 = lm.get(i);
            if (item.compareToIgnoreCase(s2) >= 0) continue;
            return i;
        }
        return lm.size();
    }

    private void setupActions() {
        this.wordList.addListSelectionListener(e -> {
            this.wordEditField.setText(this.wordList.getSelectedValue());
            this.wordEditField.selectAll();
            this.wordEditField.requestFocus();
        });
        this.newWord.addActionListener(e -> this.newWordAction());
        ActionListener wordEditFieldListener = e -> this.actOnWordEdit();
        this.wordEditField.addActionListener(wordEditFieldListener);
        this.removeWord.addActionListener(e -> {
            int index = this.wordList.getSelectedIndex();
            if (index == -1) {
                return;
            }
            this.wordListModel.remove(index);
            this.wordEditField.setText("");
            if (!this.wordListModel.isEmpty()) {
                this.wordList.setSelectedIndex(Math.min(index, this.wordListModel.size() - 1));
            }
        });
        this.fieldList.addListSelectionListener(e -> {
            this.currentField = this.fieldList.getSelectedValue();
            this.fieldNameField.setText("");
            this.setupWordSelector();
        });
        this.newField.addActionListener(e -> {
            if (!this.fieldListModel.get(0).equals(FIELD_FIRST_LINE)) {
                this.fieldListModel.add(0, FIELD_FIRST_LINE);
            }
            this.fieldList.setSelectedIndex(0);
            this.fPane.getVerticalScrollBar().setValue(0);
            this.fieldNameField.setEnabled(true);
            this.fieldNameField.setText(this.currentField);
            this.fieldNameField.selectAll();
            this.fieldNameField.requestFocus();
        });
        this.fieldNameField.addActionListener(e -> this.fieldNameField.transferFocus());
        this.fieldNameField.addFocusListener(new FieldNameFocusAdapter());
        this.removeField.addActionListener(e -> {
            int index = this.fieldList.getSelectedIndex();
            if (index == -1) {
                return;
            }
            String fieldName = this.fieldListModel.get(index);
            this.removedFields.add(fieldName);
            this.fieldListModel.remove(index);
            this.wordListModels.remove(fieldName);
            this.fieldNameField.setText("");
            if (!this.fieldListModel.isEmpty()) {
                this.fieldList.setSelectedIndex(Math.min(index, this.wordListModel.size() - 1));
            }
        });
        this.ok.addActionListener(e -> {
            try {
                this.applyChanges();
                this.dispose();
            }
            catch (Exception ex) {
                LOGGER.info("Could not apply changes in \"Manage content selectors\"", ex);
                JOptionPane.showMessageDialog(this.frame, Localization.lang("Could not apply changes.", new String[0]));
            }
        });
        this.apply.addActionListener(e -> {
            if (!"".equals(this.wordEditField.getText())) {
                wordEditFieldListener.actionPerformed(null);
            }
            try {
                this.applyChanges();
            }
            catch (Exception ex) {
                LOGGER.info("Could not apply changes in \"Manage content selectors\"", ex);
                JOptionPane.showMessageDialog(this.frame, Localization.lang("Could not apply changes.", new String[0]));
            }
        });
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContentSelectorDialog.this.dispose();
            }
        };
        cancelAction.putValue("Name", Localization.lang("Cancel", new String[0]));
        this.cancel.setAction(cancelAction);
    }

    private void actOnWordEdit() {
        String old = this.wordList.getSelectedValue();
        String newVal = this.wordEditField.getText();
        if ("".equals(newVal) || newVal.equals(old)) {
            return;
        }
        int index = this.wordList.getSelectedIndex();
        if (this.wordListModel.contains(newVal)) {
            index = this.wordListModel.indexOf(newVal);
            this.wordList.ensureIndexIsVisible(index);
            return;
        }
        int newIndex = ContentSelectorDialog.findPos(this.wordListModel, newVal);
        if (index >= 0) {
            this.wordListModel.remove(index);
            if (newIndex > index) {
                --newIndex;
            }
        }
        this.wordListModel.add(newIndex, newVal);
        this.wordList.ensureIndexIsVisible(newIndex);
        this.wordEditField.selectAll();
    }

    private void newWordAction() {
        if (this.wordListModel.isEmpty() || !this.wordListModel.get(0).equals(WORD_FIRSTLINE_TEXT)) {
            this.wordListModel.add(0, WORD_FIRSTLINE_TEXT);
        }
        this.wordList.setSelectedIndex(0);
        this.wPane.getVerticalScrollBar().setValue(0);
    }

    private void applyChanges() {
        boolean anythingChanged = false;
        for (String string : this.removedFields) {
            this.metaData.clearContentSelectors(string);
            anythingChanged = true;
        }
        for (Map.Entry entry : this.wordListModels.entrySet()) {
            if (entry.getKey() == null || FIELD_FIRST_LINE.equals(entry.getKey())) continue;
            DefaultListModel lm = (DefaultListModel)entry.getValue();
            if (!lm.isEmpty()) {
                for (int start = 0; start < lm.size() && ((String)lm.get(start)).equals(WORD_FIRSTLINE_TEXT); ++start) {
                }
            }
            HashSet<String> data = new HashSet<String>();
            for (int wrd = start; wrd < lm.size(); ++wrd) {
                String word = (String)lm.get(wrd);
                data.add(word);
            }
            if (!data.equals(new HashSet<String>(this.metaData.getContentSelectorValuesForField((String)entry.getKey())))) {
                anythingChanged = true;
            }
            if (!data.isEmpty() && this.metaData.getContentSelectorValuesForField((String)entry.getKey()).isEmpty()) {
                anythingChanged = true;
            }
            this.metaData.addContentSelector(new ContentSelector((String)entry.getKey(), new ArrayList<String>(data)));
        }
        if (anythingChanged) {
            this.panel.setupMainPanel();
            this.panel.markNonUndoableBaseChanged();
        }
    }

    private void setupFieldSelector() {
        this.fieldListModel.clear();
        TreeSet<String> contents = new TreeSet<String>();
        ContentSelectors selectors = this.metaData.getContentSelectors();
        for (String s2 : selectors.getFieldNamesWithSelectors()) {
            contents.add(s2);
        }
        if (contents.isEmpty()) {
            this.fieldListModel.addElement("author");
            this.fieldListModel.addElement("journal");
            this.fieldListModel.addElement("keywords");
            this.fieldListModel.addElement("publisher");
        } else {
            for (String s2 : contents) {
                this.fieldListModel.addElement(s2);
            }
        }
        if (this.currentField == null) {
            this.fieldList.setSelectedIndex(0);
        } else {
            int i = this.fieldListModel.indexOf(this.currentField);
            if (i != -1) {
                this.fieldList.setSelectedIndex(i);
            }
        }
    }

    private void setupWordSelector() {
        this.wordListModel = this.wordListModels.get(this.currentField);
        if (this.wordListModel == null) {
            this.wordListModel = new DefaultListModel();
            this.wordList.setModel(this.wordListModel);
            this.wordListModels.put(this.currentField, this.wordListModel);
            int index = 0;
            for (String s2 : this.metaData.getContentSelectorValuesForField(this.currentField)) {
                this.wordListModel.add(index, s2);
                ++index;
            }
        } else {
            this.wordList.setModel(this.wordListModel);
        }
    }

    private void initLayout() {
        this.fieldNameField.setEnabled(false);
        this.fieldList.setVisibleRowCount(4);
        this.wordList.setVisibleRowCount(10);
        String VAL = "Uren luren himmelturen, ja Besseggen.";
        this.fieldList.setPrototypeCellValue("Uren luren himmelturen, ja Besseggen.");
        this.wordList.setPrototypeCellValue("Uren luren himmelturen, ja Besseggen.");
        this.fieldPan.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localization.lang("Field name", new String[0])));
        this.wordPan.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localization.lang("Keyword", new String[0])));
        this.fieldPan.setLayout(this.gbl);
        this.wordPan.setLayout(this.gbl);
        this.con.insets = new Insets(2, 2, 2, 2);
        this.con.fill = 1;
        this.con.gridwidth = 2;
        this.con.weightx = 1.0;
        this.con.weighty = 1.0;
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.gbl.setConstraints(this.fPane, this.con);
        this.fieldPan.add(this.fPane);
        this.gbl.setConstraints(this.wPane, this.con);
        this.wordPan.add(this.wPane);
        this.con.gridwidth = 1;
        this.con.gridx = 2;
        this.con.gridheight = 2;
        this.gbl.setConstraints(this.fieldNamePan, this.con);
        this.fieldPan.add(this.fieldNamePan);
        this.gbl.setConstraints(this.wordEditPan, this.con);
        this.wordPan.add(this.wordEditPan);
        this.con.gridx = 0;
        this.con.gridy = 1;
        this.con.weightx = 0.0;
        this.con.weighty = 0.0;
        this.con.gridwidth = 1;
        this.con.gridheight = 1;
        this.con.fill = 0;
        this.con.anchor = 17;
        this.gbl.setConstraints(this.newField, this.con);
        this.fieldPan.add(this.newField);
        this.gbl.setConstraints(this.newWord, this.con);
        this.wordPan.add(this.newWord);
        this.con.gridx = 1;
        this.gbl.setConstraints(this.removeField, this.con);
        this.fieldPan.add(this.removeField);
        this.gbl.setConstraints(this.removeWord, this.con);
        this.wordPan.add(this.removeWord);
        this.con.anchor = 17;
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.gbl.setConstraints(this.fieldNameField, this.con);
        this.fieldNamePan.add(this.fieldNameField);
        this.gbl.setConstraints(this.wordEditField, this.con);
        this.wordEditPan.add(this.wordEditField);
        ButtonBarBuilder bsb = new ButtonBarBuilder(this.buttonPan);
        bsb.addGlue();
        bsb.addButton((JComponent)this.ok);
        bsb.addButton((JComponent)this.apply);
        bsb.addButton((JComponent)this.cancel);
        bsb.addRelatedGap();
        bsb.addButton((JComponent)new HelpAction(HelpFile.CONTENT_SELECTOR).getHelpButton());
        bsb.addGlue();
        this.con.fill = 1;
        this.getContentPane().setLayout(this.gbl);
        this.con.weightx = 1.0;
        this.con.weighty = 0.5;
        this.con.gridwidth = 1;
        this.con.gridheight = 1;
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.gbl.setConstraints(this.fieldPan, this.con);
        this.getContentPane().add(this.fieldPan);
        this.con.gridy = 1;
        this.gbl.setConstraints(this.wordPan, this.con);
        this.getContentPane().add(this.wordPan);
        this.con.weighty = 0.0;
        this.con.gridy = 2;
        this.con.insets = new Insets(12, 2, 2, 2);
        this.gbl.setConstraints(this.buttonPan, this.con);
        this.getContentPane().add(this.buttonPan);
    }

    private class FieldNameFocusAdapter
    extends FocusAdapter {
        private FieldNameFocusAdapter() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            String s2 = ContentSelectorDialog.this.fieldNameField.getText();
            ContentSelectorDialog.this.fieldNameField.setText("");
            ContentSelectorDialog.this.fieldNameField.setEnabled(false);
            if (!FIELD_FIRST_LINE.equals(s2) && !"".equals(s2)) {
                int pos;
                ContentSelectorDialog.this.fieldListModel.remove(0);
                if (ContentSelectorDialog.this.fieldListModel.contains(s2)) {
                    pos = ContentSelectorDialog.this.fieldListModel.indexOf(s2);
                } else {
                    pos = ContentSelectorDialog.findPos(ContentSelectorDialog.this.fieldListModel, s2);
                    ContentSelectorDialog.this.fieldListModel.add(Math.max(0, pos), s2);
                }
                ContentSelectorDialog.this.fieldList.setSelectedIndex(pos);
                ContentSelectorDialog.this.fieldList.ensureIndexIsVisible(pos);
                ContentSelectorDialog.this.currentField = s2;
                ContentSelectorDialog.this.setupWordSelector();
                ContentSelectorDialog.this.newWordAction();
            }
        }
    }
}

