/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.collab;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jabref.Globals;
import org.jabref.JabRefExecutorService;
import org.jabref.gui.BasePanel;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.collab.ChangeDisplayDialog;
import org.jabref.gui.collab.ChangeViewModel;
import org.jabref.gui.collab.EntryAddChangeViewModel;
import org.jabref.gui.collab.EntryChangeViewModel;
import org.jabref.gui.collab.EntryDeleteChangeViewModel;
import org.jabref.gui.collab.GroupChangeViewModel;
import org.jabref.gui.collab.MetaDataChangeViewModel;
import org.jabref.gui.collab.PreambleChangeViewModel;
import org.jabref.gui.collab.StringAddChangeViewModel;
import org.jabref.gui.collab.StringChangeViewModel;
import org.jabref.gui.collab.StringNameChangeViewModel;
import org.jabref.gui.collab.StringRemoveChangeViewModel;
import org.jabref.logic.bibtex.DuplicateCheck;
import org.jabref.logic.bibtex.comparator.BibDatabaseDiff;
import org.jabref.logic.bibtex.comparator.BibEntryDiff;
import org.jabref.logic.bibtex.comparator.BibStringDiff;
import org.jabref.logic.bibtex.comparator.GroupDiff;
import org.jabref.logic.bibtex.comparator.MetaDataDiff;
import org.jabref.logic.bibtex.comparator.PreambleDiff;
import org.jabref.logic.exporter.BibtexDatabaseWriter;
import org.jabref.logic.exporter.FileSaveSession;
import org.jabref.logic.exporter.SaveException;
import org.jabref.logic.exporter.SavePreferences;
import org.jabref.logic.exporter.SaveSession;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.OpenDatabase;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibtexString;
import org.jabref.model.metadata.MetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeScanner
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeScanner.class);
    private final File file;
    private final Path tempFile;
    private final BibDatabaseContext databaseInMemory;
    private final MetaData metadataInMemory;
    private final BasePanel panel;
    private final JabRefFrame frame;
    private BibDatabaseContext databaseInTemp;
    private final DefaultMutableTreeNode changes = new DefaultMutableTreeNode(Localization.lang("External changes", new String[0]));

    public ChangeScanner(JabRefFrame frame, BasePanel bp, File file, Path tempFile) {
        this.panel = bp;
        this.frame = frame;
        this.databaseInMemory = bp.getBibDatabaseContext();
        this.metadataInMemory = bp.getBibDatabaseContext().getMetaData();
        this.file = file;
        this.tempFile = tempFile;
    }

    public boolean changesFound() {
        return this.changes.getChildCount() > 0;
    }

    private static BibEntry bestFit(BibEntry targetEntry, List<BibEntry> entries) {
        return entries.stream().max(Comparator.comparingDouble(candidate -> DuplicateCheck.compareEntriesStrictly(targetEntry, candidate))).orElse(null);
    }

    public void displayResult(DisplayResultCallback fup) {
        if (this.changes.getChildCount() > 0) {
            SwingUtilities.invokeLater(() -> {
                ChangeDisplayDialog changeDialog = new ChangeDisplayDialog(this.frame, this.panel, this.databaseInTemp.getDatabase(), this.changes);
                changeDialog.setLocationRelativeTo(this.frame);
                changeDialog.setVisible(true);
                fup.scanResultsResolved(changeDialog.isOkPressed());
                if (changeDialog.isOkPressed()) {
                    this.storeTempDatabase();
                }
            });
        } else {
            JOptionPane.showMessageDialog(this.frame, Localization.lang("No actual changes found.", new String[0]), Localization.lang("External changes", new String[0]), 1);
            fup.scanResultsResolved(true);
        }
    }

    private void storeTempDatabase() {
        JabRefExecutorService.INSTANCE.execute(() -> {
            try {
                SavePreferences prefs = Globals.prefs.loadForSaveFromPreferences().withMakeBackup(false).withEncoding(this.panel.getBibDatabaseContext().getMetaData().getEncoding().orElse(Globals.prefs.getDefaultEncoding()));
                BibtexDatabaseWriter<SaveSession> databaseWriter = new BibtexDatabaseWriter<SaveSession>(FileSaveSession::new);
                Object ss = databaseWriter.saveDatabase(this.databaseInTemp, prefs);
                ((SaveSession)ss).commit(this.tempFile);
            }
            catch (SaveException ex) {
                LOGGER.warn("Problem updating tmp file after accepting external changes", ex);
            }
        });
    }

    @Override
    public void run() {
        try {
            ImportFormatPreferences importFormatPreferences = Globals.prefs.getImportFormatPreferences();
            ParserResult result = OpenDatabase.loadDatabase(this.tempFile.toFile(), importFormatPreferences, Globals.getFileUpdateMonitor());
            this.databaseInTemp = result.getDatabaseContext();
            result = OpenDatabase.loadDatabase(this.file, importFormatPreferences, Globals.getFileUpdateMonitor());
            BibDatabaseContext databaseOnDisk = result.getDatabaseContext();
            BibDatabaseDiff differences = BibDatabaseDiff.compare(this.databaseInTemp, databaseOnDisk);
            differences.getMetaDataDifferences().ifPresent(diff -> {
                this.changes.add(new MetaDataChangeViewModel(this.metadataInMemory, (MetaDataDiff)diff));
                diff.getGroupDifferences().ifPresent(groupDiff -> this.changes.add(new GroupChangeViewModel((GroupDiff)groupDiff)));
            });
            differences.getPreambleDifferences().ifPresent(diff -> this.changes.add(new PreambleChangeViewModel(this.databaseInMemory.getDatabase().getPreamble().orElse(""), (PreambleDiff)diff)));
            differences.getBibStringDifferences().forEach(diff -> this.changes.add(this.createBibStringDiff((BibStringDiff)diff)));
            differences.getEntryDifferences().forEach(diff -> this.changes.add(this.createBibEntryDiff((BibEntryDiff)diff)));
        }
        catch (IOException ex) {
            LOGGER.warn("Problem running", ex);
        }
    }

    private ChangeViewModel createBibStringDiff(BibStringDiff diff) {
        if (diff.getOriginalString() == null) {
            return new StringAddChangeViewModel(diff.getNewString());
        }
        if (diff.getNewString() == null) {
            Optional<BibtexString> current = this.databaseInMemory.getDatabase().getStringByName(diff.getOriginalString().getName());
            return new StringRemoveChangeViewModel(diff.getOriginalString(), current.orElse(null));
        }
        if (diff.getOriginalString().getName().equals(diff.getNewString().getName())) {
            Optional<BibtexString> current = this.databaseInMemory.getDatabase().getStringByName(diff.getOriginalString().getName());
            return new StringChangeViewModel(current.orElse(null), diff.getOriginalString(), diff.getNewString().getContent());
        }
        Optional<BibtexString> current = this.databaseInMemory.getDatabase().getStringByName(diff.getOriginalString().getName());
        return new StringNameChangeViewModel(current.orElse(null), diff.getOriginalString(), current.map(BibtexString::getName).orElse(""), diff.getNewString().getName());
    }

    private ChangeViewModel createBibEntryDiff(BibEntryDiff diff) {
        if (diff.getOriginalEntry() == null) {
            return new EntryAddChangeViewModel(diff.getNewEntry());
        }
        if (diff.getNewEntry() == null) {
            return new EntryDeleteChangeViewModel(ChangeScanner.bestFit(diff.getOriginalEntry(), this.databaseInMemory.getEntries()), diff.getOriginalEntry());
        }
        return new EntryChangeViewModel(ChangeScanner.bestFit(diff.getOriginalEntry(), this.databaseInMemory.getEntries()), diff.getOriginalEntry(), diff.getNewEntry());
    }

    @FunctionalInterface
    public static interface DisplayResultCallback {
        public void scanResultsResolved(boolean var1);
    }
}

