/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.bibtexkeypattern;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.IconTheme;
import org.jabref.gui.help.HelpAction;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.EntryTypes;
import org.jabref.model.bibtexkeypattern.AbstractBibtexKeyPattern;
import org.jabref.model.bibtexkeypattern.DatabaseBibtexKeyPattern;
import org.jabref.model.bibtexkeypattern.GlobalBibtexKeyPattern;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.EntryType;
import org.jabref.preferences.JabRefPreferences;

public class BibtexKeyPatternPanel
extends JPanel {
    protected final GridBagLayout gbl = new GridBagLayout();
    protected final GridBagConstraints con = new GridBagConstraints();
    protected final JTextField defaultPat = new JTextField();
    private final HelpAction help;
    private final Map<String, JTextField> textFields = new HashMap<String, JTextField>();
    private final BasePanel panel;

    public BibtexKeyPatternPanel(BasePanel panel) {
        this.panel = panel;
        this.help = new HelpAction(Localization.lang("Help on key patterns", new String[0]), HelpFile.BIBTEX_KEY_PATTERN);
        this.buildGUI();
    }

    private void buildGUI() {
        JPanel pan = new JPanel();
        JScrollPane sp2 = new JScrollPane(pan);
        sp2.setPreferredSize(new Dimension(100, 100));
        sp2.setBorder(BorderFactory.createEmptyBorder());
        pan.setLayout(this.gbl);
        this.setLayout(this.gbl);
        JLabel lblEntryType = new JLabel(Localization.lang("Entry type", new String[0]));
        Font f = new Font("plain", 1, 12);
        lblEntryType.setFont(f);
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.con.gridwidth = 1;
        this.con.gridheight = 1;
        this.con.fill = 3;
        this.con.anchor = 17;
        this.con.insets = new Insets(5, 5, 10, 0);
        this.gbl.setConstraints(lblEntryType, this.con);
        pan.add(lblEntryType);
        JLabel lblKeyPattern = new JLabel(Localization.lang("Key pattern", new String[0]));
        lblKeyPattern.setFont(f);
        this.con.gridx = 1;
        this.con.gridy = 0;
        this.con.gridheight = 1;
        this.con.fill = 2;
        this.con.anchor = 17;
        this.con.insets = new Insets(5, 5, 10, 5);
        this.gbl.setConstraints(lblKeyPattern, this.con);
        pan.add(lblKeyPattern);
        this.con.gridy = 1;
        this.con.gridx = 0;
        JLabel lab = new JLabel(Localization.lang("Default pattern", new String[0]));
        this.gbl.setConstraints(lab, this.con);
        pan.add(lab);
        this.con.gridx = 1;
        this.gbl.setConstraints(this.defaultPat, this.con);
        pan.add(this.defaultPat);
        this.con.insets = new Insets(5, 5, 10, 5);
        JButton btnDefault = new JButton(Localization.lang("Default", new String[0]));
        btnDefault.addActionListener(e -> this.defaultPat.setText((String)Globals.prefs.defaults.get("defaultBibtexKeyPattern")));
        this.con.gridx = 2;
        int y = 2;
        this.gbl.setConstraints(btnDefault, this.con);
        pan.add(btnDefault);
        BibDatabaseMode mode = this.panel != null ? this.panel.getBibDatabaseContext().getMode() : Globals.prefs.getDefaultBibDatabaseMode();
        for (EntryType type : EntryTypes.getAllValues(mode)) {
            this.textFields.put(type.getName().toLowerCase(Locale.ROOT), this.addEntryType(pan, type, y));
            ++y;
        }
        this.con.fill = 1;
        this.con.gridx = 0;
        this.con.gridy = 1;
        this.con.gridwidth = 3;
        this.con.weightx = 1.0;
        this.con.weighty = 1.0;
        this.gbl.setConstraints(sp2, this.con);
        this.add(sp2);
        this.con.gridwidth = 1;
        this.con.gridx = 1;
        this.con.gridy = 2;
        this.con.fill = 2;
        this.con.weightx = 0.0;
        this.con.weighty = 0.0;
        this.con.anchor = 14;
        this.con.insets = new Insets(0, 5, 0, 5);
        JButton hlb = new JButton(IconTheme.JabRefIcon.HELP.getSmallIcon());
        hlb.setToolTipText(Localization.lang("Help on key patterns", new String[0]));
        this.gbl.setConstraints(hlb, this.con);
        this.add(hlb);
        hlb.addActionListener(this.help);
        JButton btnDefaultAll = new JButton(Localization.lang("Reset all", new String[0]));
        this.con.gridx = 2;
        this.con.gridy = 2;
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        this.con.anchor = 14;
        this.con.insets = new Insets(20, 5, 0, 5);
        this.gbl.setConstraints(btnDefaultAll, this.con);
        btnDefaultAll.addActionListener(e -> {
            for (JTextField field2 : this.textFields.values()) {
                field2.setText("");
            }
            this.defaultPat.setText((String)Globals.prefs.defaults.get("defaultBibtexKeyPattern"));
        });
        this.add(btnDefaultAll);
    }

    private JTextField addEntryType(Container c, EntryType type, int y) {
        JLabel lab = new JLabel(type.getName());
        this.con.gridx = 0;
        this.con.gridy = y;
        this.con.fill = 1;
        this.con.weightx = 0.0;
        this.con.weighty = 0.0;
        this.con.anchor = 17;
        this.con.insets = new Insets(0, 5, 0, 5);
        this.gbl.setConstraints(lab, this.con);
        c.add(lab);
        JTextField tf = new JTextField();
        tf.setColumns(15);
        this.con.gridx = 1;
        this.con.fill = 2;
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        this.con.anchor = 10;
        this.con.insets = new Insets(0, 5, 0, 5);
        this.gbl.setConstraints(tf, this.con);
        c.add(tf);
        JButton but = new JButton(Localization.lang("Default", new String[0]));
        this.con.gridx = 2;
        this.con.fill = 1;
        this.con.weightx = 0.0;
        this.con.weighty = 0.0;
        this.con.anchor = 10;
        this.con.insets = new Insets(0, 5, 0, 5);
        this.gbl.setConstraints(but, this.con);
        but.setActionCommand(type.getName().toLowerCase(Locale.ROOT));
        but.addActionListener(e -> {
            JTextField tField = this.textFields.get(e.getActionCommand());
            tField.setText("");
        });
        c.add(but);
        return tf;
    }

    private void fillPatternUsingPanelData(AbstractBibtexKeyPattern keypatterns) {
        for (Map.Entry<String, JTextField> entry : this.textFields.entrySet()) {
            String text = entry.getValue().getText();
            if (text.trim().isEmpty()) continue;
            keypatterns.addBibtexKeyPattern(entry.getKey(), text);
        }
        String text = this.defaultPat.getText();
        if (!text.trim().isEmpty()) {
            keypatterns.setDefaultValue(text);
        }
    }

    protected GlobalBibtexKeyPattern getKeyPatternAsGlobalBibtexKeyPattern() {
        GlobalBibtexKeyPattern res = GlobalBibtexKeyPattern.fromPattern(JabRefPreferences.getInstance().get("defaultBibtexKeyPattern"));
        this.fillPatternUsingPanelData(res);
        return res;
    }

    public DatabaseBibtexKeyPattern getKeyPatternAsDatabaseBibtexKeyPattern() {
        DatabaseBibtexKeyPattern res = new DatabaseBibtexKeyPattern(Globals.prefs.getKeyPattern());
        this.fillPatternUsingPanelData(res);
        return res;
    }

    public void setValues(AbstractBibtexKeyPattern keyPattern) {
        for (Map.Entry<String, JTextField> entry : this.textFields.entrySet()) {
            BibtexKeyPatternPanel.setValue(entry.getValue(), entry.getKey(), keyPattern);
        }
        if (keyPattern.getDefaultValue() == null || keyPattern.getDefaultValue().isEmpty()) {
            this.defaultPat.setText("");
        } else {
            this.defaultPat.setText(keyPattern.getDefaultValue().get(0));
        }
    }

    private static void setValue(JTextField tf, String fieldName, AbstractBibtexKeyPattern keyPattern) {
        if (keyPattern.isDefaultValue(fieldName)) {
            tf.setText("");
        } else {
            tf.setText(keyPattern.getValue(fieldName).get(0));
        }
    }
}

