/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.InternalBibtexFields;
import org.jabref.model.metadata.SaveOrderConfig;

public class SaveOrderConfigDisplay {
    private JPanel panel;
    private JComboBox<String> savePriSort;
    private JComboBox<String> saveSecSort;
    private JComboBox<String> saveTerSort;
    private JCheckBox savePriDesc;
    private JCheckBox saveSecDesc;
    private JCheckBox saveTerDesc;

    public SaveOrderConfigDisplay() {
        this.init();
    }

    private void init() {
        List<String> fieldNames = InternalBibtexFields.getAllPublicFieldNames();
        fieldNames.add("bibtexkey");
        Collections.sort(fieldNames);
        String[] allPlusKey = fieldNames.toArray(new String[fieldNames.size()]);
        this.savePriSort = new JComboBox<String>(allPlusKey);
        this.savePriSort.setEditable(true);
        this.saveSecSort = new JComboBox<String>(allPlusKey);
        this.saveSecSort.setEditable(true);
        this.saveTerSort = new JComboBox<String>(allPlusKey);
        this.saveTerSort.setEditable(true);
        this.savePriDesc = new JCheckBox(Localization.lang("Descending", new String[0]));
        this.saveSecDesc = new JCheckBox(Localization.lang("Descending", new String[0]));
        this.saveTerDesc = new JCheckBox(Localization.lang("Descending", new String[0]));
        FormLayout layout = new FormLayout("right:pref, 8dlu, fill:pref, 4dlu, fill:60dlu, 4dlu, left:pref", "pref, 2dlu, pref, 2dlu, pref");
        FormBuilder builder = FormBuilder.create().layout(layout);
        builder.add(Localization.lang("Primary sort criterion", new String[0]), new Object[0]).xy(1, 1);
        builder.add(this.savePriSort).xy(3, 1);
        builder.add(this.savePriDesc).xy(5, 1);
        builder.add(Localization.lang("Secondary sort criterion", new String[0]), new Object[0]).xy(1, 3);
        builder.add(this.saveSecSort).xy(3, 3);
        builder.add(this.saveSecDesc).xy(5, 3);
        builder.add(Localization.lang("Tertiary sort criterion", new String[0]), new Object[0]).xy(1, 5);
        builder.add(this.saveTerSort).xy(3, 5);
        builder.add(this.saveTerDesc).xy(5, 5);
        this.panel = builder.build();
    }

    public Component getPanel() {
        return this.panel;
    }

    public void setEnabled(boolean enabled) {
        this.savePriSort.setEnabled(enabled);
        this.savePriDesc.setEnabled(enabled);
        this.saveSecSort.setEnabled(enabled);
        this.saveSecDesc.setEnabled(enabled);
        this.saveTerSort.setEnabled(enabled);
        this.saveTerDesc.setEnabled(enabled);
    }

    public void setSaveOrderConfig(SaveOrderConfig saveOrderConfig) {
        Objects.requireNonNull(saveOrderConfig);
        this.savePriSort.setSelectedItem(saveOrderConfig.sortCriteria[0].field);
        this.savePriDesc.setSelected(saveOrderConfig.sortCriteria[0].descending);
        this.saveSecSort.setSelectedItem(saveOrderConfig.sortCriteria[1].field);
        this.saveSecDesc.setSelected(saveOrderConfig.sortCriteria[1].descending);
        this.saveTerSort.setSelectedItem(saveOrderConfig.sortCriteria[2].field);
        this.saveTerDesc.setSelected(saveOrderConfig.sortCriteria[2].descending);
    }

    public SaveOrderConfig getSaveOrderConfig() {
        SaveOrderConfig saveOrderConfig = new SaveOrderConfig();
        saveOrderConfig.sortCriteria[0].field = this.getSelectedItemAsLowerCaseTrim(this.savePriSort);
        saveOrderConfig.sortCriteria[0].descending = this.savePriDesc.isSelected();
        saveOrderConfig.sortCriteria[1].field = this.getSelectedItemAsLowerCaseTrim(this.saveSecSort);
        saveOrderConfig.sortCriteria[1].descending = this.saveSecDesc.isSelected();
        saveOrderConfig.sortCriteria[2].field = this.getSelectedItemAsLowerCaseTrim(this.saveTerSort);
        saveOrderConfig.sortCriteria[2].descending = this.saveTerDesc.isSelected();
        return saveOrderConfig;
    }

    private String getSelectedItemAsLowerCaseTrim(JComboBox<String> sortBox) {
        return sortBox.getSelectedItem().toString().toLowerCase(Locale.ROOT).trim();
    }
}

