/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui;

import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIconView;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jabref.logic.groups.DefaultGroupsFactory;
import org.jabref.preferences.JabRefPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IconTheme {
    public static final java.awt.Color DEFAULT_COLOR = JabRefPreferences.getInstance().getColor("iconEnabledColor");
    public static final java.awt.Color DEFAULT_DISABLED_COLOR = JabRefPreferences.getInstance().getColor("iconDisabledColor");
    public static Font FONT;
    private static final String DEFAULT_ICON_PATH = "/images/external/red.png";
    private static final Logger LOGGER;
    private static final Map<String, String> KEY_TO_ICON;
    private static Font FONT_16;
    private static javafx.scene.text.Font FX_FONT;

    private static InputStream getMaterialDesignIconsStream() {
        return FontBasedIcon.class.getResourceAsStream("/fonts/materialdesignicons-webfont.ttf");
    }

    public static Color getDefaultColor() {
        return Color.rgb((int)DEFAULT_COLOR.getRed(), (int)DEFAULT_COLOR.getGreen(), (int)DEFAULT_COLOR.getBlue(), (double)((double)DEFAULT_COLOR.getAlpha() / 255.0));
    }

    public static ImageIcon getImage(String name) {
        return new ImageIcon(IconTheme.getIconUrl(name));
    }

    public static javafx.scene.image.Image getJabRefImageFX() {
        return IconTheme.getImageFX("jabrefIcon48");
    }

    public static javafx.scene.image.Image getImageFX(String name) {
        return new javafx.scene.image.Image(IconTheme.getIconUrl(name).toString());
    }

    public static URL getIconUrl(String name) {
        String key = Objects.requireNonNull(name, "icon name");
        if (!KEY_TO_ICON.containsKey(key)) {
            LOGGER.warn("Could not find icon url by name " + name + ", so falling back on default icon " + DEFAULT_ICON_PATH);
        }
        String path = KEY_TO_ICON.getOrDefault(key, DEFAULT_ICON_PATH);
        return Objects.requireNonNull(IconTheme.class.getResource(path), "Path must not be null for key " + key);
    }

    private static Map<String, String> readIconThemeFile(URL url, String prefix) {
        Objects.requireNonNull(url, "url");
        Objects.requireNonNull(prefix, "prefix");
        HashMap<String, String> result = new HashMap<String, String>();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.ISO_8859_1));){
            String line;
            while ((line = in.readLine()) != null) {
                if (!line.contains("=")) continue;
                int index = line.indexOf(61);
                String key = line.substring(0, index).trim();
                String value = prefix + line.substring(index + 1).trim();
                result.put(key, value);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Unable to read default icon theme.", e);
        }
        return result;
    }

    public static List<Image> getLogoSet() {
        ArrayList<Image> jabrefLogos = new ArrayList<Image>();
        jabrefLogos.add(new ImageIcon(IconTheme.getIconUrl("jabrefIcon16")).getImage());
        jabrefLogos.add(new ImageIcon(IconTheme.getIconUrl("jabrefIcon20")).getImage());
        jabrefLogos.add(new ImageIcon(IconTheme.getIconUrl("jabrefIcon32")).getImage());
        jabrefLogos.add(new ImageIcon(IconTheme.getIconUrl("jabrefIcon40")).getImage());
        jabrefLogos.add(new ImageIcon(IconTheme.getIconUrl("jabrefIcon48")).getImage());
        jabrefLogos.add(new ImageIcon(IconTheme.getIconUrl("jabrefIcon64")).getImage());
        jabrefLogos.add(new ImageIcon(IconTheme.getIconUrl("jabrefIcon128")).getImage());
        return jabrefLogos;
    }

    static {
        LOGGER = LoggerFactory.getLogger(IconTheme.class);
        KEY_TO_ICON = IconTheme.readIconThemeFile(IconTheme.class.getResource("/images/Icons.properties"), "/images/external/");
        try (InputStream stream = IconTheme.getMaterialDesignIconsStream();){
            FONT = Font.createFont(0, stream);
            FONT_16 = FONT.deriveFont(0, 16.0f);
            try (InputStream stream2 = IconTheme.getMaterialDesignIconsStream();){
                FX_FONT = javafx.scene.text.Font.loadFont((InputStream)stream2, (double)JabRefPreferences.getInstance().getInt("iconSizeLarge"));
            }
        }
        catch (FontFormatException | IOException e) {
            LOGGER.warn("Error loading font", e);
        }
    }

    public static class FontBasedIcon
    implements Icon {
        private final String iconCode;
        private final java.awt.Color iconColor;
        private final int size;

        public FontBasedIcon(String code, java.awt.Color iconColor) {
            this.iconCode = code;
            this.iconColor = iconColor;
            this.size = JabRefPreferences.getInstance().getInt("iconSizeLarge");
        }

        public FontBasedIcon(String code, java.awt.Color iconColor, int size) {
            this.iconCode = code;
            this.iconColor = iconColor;
            this.size = size;
        }

        @Override
        public void paintIcon(Component c, Graphics g2, int x, int y) {
            Graphics2D g22 = (Graphics2D)g2.create();
            RenderingHints rh = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g22.setRenderingHints(rh);
            g22.setFont(FONT.deriveFont(0, this.size));
            g22.setColor(this.iconColor);
            FontMetrics fm = g22.getFontMetrics();
            g22.translate(x, y + fm.getAscent());
            g22.drawString(this.iconCode, 0, 0);
            g22.dispose();
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }

        public FontBasedIcon createDisabledIcon() {
            return new FontBasedIcon(this.iconCode, DEFAULT_DISABLED_COLOR, this.size);
        }

        public FontBasedIcon createSmallIcon() {
            return new FontBasedIcon(this.iconCode, this.iconColor, JabRefPreferences.getInstance().getInt("iconSizeSmall"));
        }

        public FontBasedIcon createWithNewColor(java.awt.Color newColor) {
            return new FontBasedIcon(this.iconCode, newColor, this.size);
        }
    }

    public static enum JabRefIcon {
        ADD(MaterialDesignIcon.PLUS_BOX),
        ADD_NOBOX(MaterialDesignIcon.PLUS),
        ADD_ENTRY(MaterialDesignIcon.TOOLTIP_OUTLINE_PLUS),
        EDIT_ENTRY(MaterialDesignIcon.TOOLTIP_EDIT),
        EDIT_STRINGS(MaterialDesignIcon.TOOLTIP_TEXT),
        FOLDER(MaterialDesignIcon.FOOD_FORK_DRINK),
        REMOVE(MaterialDesignIcon.MINUS_BOX),
        REMOVE_NOBOX(MaterialDesignIcon.MINUS),
        FILE(MaterialDesignIcon.FILE),
        PDF_FILE(MaterialDesignIcon.FILE_PDF),
        DOI(MaterialDesignIcon.BARCODE_SCAN),
        DUPLICATE(MaterialDesignIcon.CONTENT_DUPLICATE),
        EDIT(MaterialDesignIcon.PENCIL),
        NEW(MaterialDesignIcon.FILE_OUTLINE),
        SAVE(MaterialDesignIcon.CONTENT_SAVE),
        SAVE_ALL(MaterialDesignIcon.CONTENT_SAVE_ALL),
        CLOSE(MaterialDesignIcon.CLOSE),
        PASTE(MaterialDesignIcon.CONTENT_PASTE),
        CUT(MaterialDesignIcon.CONTENT_CUT),
        COPY(MaterialDesignIcon.CONTENT_COPY),
        COMMENT(MaterialDesignIcon.COMMENT),
        REDO(MaterialDesignIcon.REDO),
        UNDO(MaterialDesignIcon.UNDO),
        MARK_ENTRIES(MaterialDesignIcon.BOOKMARK),
        MARKER(MaterialDesignIcon.MARKER),
        UNMARK_ENTRIES(MaterialDesignIcon.BOOKMARK_OUTLINE),
        REFRESH(MaterialDesignIcon.REFRESH),
        DELETE_ENTRY(MaterialDesignIcon.DELETE),
        SEARCH(MaterialDesignIcon.MAGNIFY),
        ADVANCED_SEARCH(java.awt.Color.CYAN, MaterialDesignIcon.MAGNIFY),
        PREFERENCES(MaterialDesignIcon.SETTINGS),
        HELP(MaterialDesignIcon.HELP_CIRCLE),
        UP(MaterialDesignIcon.CHEVRON_UP),
        DOWN(MaterialDesignIcon.CHEVRON_DOWN),
        LEFT(MaterialDesignIcon.ARROW_LEFT_BOLD),
        RIGHT(MaterialDesignIcon.ARROW_RIGHT_BOLD),
        SOURCE(MaterialDesignIcon.CODE_BRACES),
        MAKE_KEY(MaterialDesignIcon.KEY_VARIANT),
        CLEANUP_ENTRIES(MaterialDesignIcon.BROOM),
        PRIORITY(MaterialDesignIcon.FLAG),
        PRIORITY_HIGH(java.awt.Color.RED, MaterialDesignIcon.FLAG),
        PRIORITY_MEDIUM(java.awt.Color.ORANGE, MaterialDesignIcon.FLAG),
        PRIORITY_LOW(new java.awt.Color(111, 204, 117), MaterialDesignIcon.FLAG),
        PRINTED(MaterialDesignIcon.PRINTER),
        RANKING(MaterialDesignIcon.STAR),
        RANK1(MaterialDesignIcon.STAR, MaterialDesignIcon.STAR_OUTLINE, MaterialDesignIcon.STAR_OUTLINE, MaterialDesignIcon.STAR_OUTLINE, MaterialDesignIcon.STAR_OUTLINE),
        RANK2(MaterialDesignIcon.STAR, MaterialDesignIcon.STAR, MaterialDesignIcon.STAR_OUTLINE, MaterialDesignIcon.STAR_OUTLINE, MaterialDesignIcon.STAR_OUTLINE),
        RANK3(MaterialDesignIcon.STAR, MaterialDesignIcon.STAR, MaterialDesignIcon.STAR, MaterialDesignIcon.STAR_OUTLINE, MaterialDesignIcon.STAR_OUTLINE),
        RANK4(MaterialDesignIcon.STAR, MaterialDesignIcon.STAR, MaterialDesignIcon.STAR, MaterialDesignIcon.STAR, MaterialDesignIcon.STAR_OUTLINE),
        RANK5(MaterialDesignIcon.STAR, MaterialDesignIcon.STAR, MaterialDesignIcon.STAR, MaterialDesignIcon.STAR, MaterialDesignIcon.STAR),
        WWW(MaterialDesignIcon.WEB),
        GROUP_INCLUDING(MaterialDesignIcon.FILTER_OUTLINE),
        GROUP_REFINING(MaterialDesignIcon.FILTER),
        AUTO_GROUP(MaterialDesignIcon.AUTO_FIX),
        EMAIL(MaterialDesignIcon.EMAIL),
        EXPORT_TO_CLIPBOARD(MaterialDesignIcon.CLIPBOARD_ARROW_LEFT),
        ATTACH_FILE(MaterialDesignIcon.PAPERCLIP),
        AUTO_FILE_LINK(MaterialDesignIcon.FILE_FIND),
        QUALITY_ASSURED(MaterialDesignIcon.CERTIFICATE),
        QUALITY(MaterialDesignIcon.CERTIFICATE),
        OPEN(MaterialDesignIcon.FOLDER),
        ADD_ROW(MaterialDesignIcon.SERVER_PLUS),
        REMOVE_ROW(MaterialDesignIcon.SERVER_MINUS),
        PICTURE(MaterialDesignIcon.FILE_IMAGE),
        READ_STATUS_READ(new java.awt.Color(111, 204, 117), MaterialDesignIcon.EYE),
        READ_STATUS_SKIMMED(java.awt.Color.ORANGE, MaterialDesignIcon.EYE),
        READ_STATUS(MaterialDesignIcon.EYE),
        RELEVANCE(MaterialDesignIcon.STAR_CIRCLE),
        MERGE_ENTRIES(MaterialDesignIcon.COMPARE),
        CONNECT_OPEN_OFFICE(MaterialDesignIcon.OPEN_IN_APP),
        PLAIN_TEXT_IMPORT_TODO(MaterialDesignIcon.CHECKBOX_BLANK_CIRCLE_OUTLINE),
        PLAIN_TEXT_IMPORT_DONE(MaterialDesignIcon.CHECKBOX_MARKED_CIRCLE_OUTLINE),
        DONATE(MaterialDesignIcon.GIFT),
        MOVE_TAB_ARROW(MaterialDesignIcon.ARROW_UP_BOLD),
        OPTIONAL(MaterialDesignIcon.LABEL_OUTLINE),
        REQUIRED(MaterialDesignIcon.LABEL),
        INTEGRITY_FAIL(java.awt.Color.RED, MaterialDesignIcon.CLOSE_CIRCLE),
        INTEGRITY_INFO(MaterialDesignIcon.INFORMATION),
        INTEGRITY_WARN(MaterialDesignIcon.ALERT_CIRCLE),
        INTEGRITY_SUCCESS(MaterialDesignIcon.CHECKBOX_MARKED_CIRCLE_OUTLINE),
        GITHUB(MaterialDesignIcon.GITHUB_CIRCLE),
        TOGGLE_ENTRY_PREVIEW(MaterialDesignIcon.LIBRARY_BOOKS),
        TOGGLE_GROUPS(MaterialDesignIcon.VIEW_LIST),
        WRITE_XMP(MaterialDesignIcon.IMPORT),
        FILE_WORD(MaterialDesignIcon.FILE_WORD),
        FILE_EXCEL(MaterialDesignIcon.FILE_EXCEL),
        FILE_POWERPOINT(MaterialDesignIcon.FILE_POWERPOINT),
        FILE_TEXT(MaterialDesignIcon.FILE_DOCUMENT),
        FILE_MULTIPLE(MaterialDesignIcon.FILE_MULTIPLE),
        KEY_BINDINGS(MaterialDesignIcon.KEYBOARD),
        FIND_DUPLICATES(MaterialDesignIcon.CODE_EQUAL),
        PULL(MaterialDesignIcon.SOURCE_PULL),
        SUCCESS(MaterialDesignIcon.CHECK_CIRCLE),
        WARNING(MaterialDesignIcon.ALERT),
        ERROR(MaterialDesignIcon.ALERT_CIRCLE),
        OPEN_IN_NEW_WINDOW(MaterialDesignIcon.OPEN_IN_NEW),
        CASE_SENSITIVE(MaterialDesignIcon.ALPHABETICAL),
        REG_EX(MaterialDesignIcon.REGEX),
        CONSOLE(MaterialDesignIcon.CONSOLE),
        FORUM(MaterialDesignIcon.FORUM),
        FACEBOOK(MaterialDesignIcon.FACEBOOK),
        TWITTER(MaterialDesignIcon.TWITTER),
        BLOG(MaterialDesignIcon.RSS),
        GLOBAL_SEARCH(MaterialDesignIcon.EARTH),
        DATE_PICKER(MaterialDesignIcon.CALENDAR),
        DEFAULT_GROUP_ICON(MaterialDesignIcon.LABEL_OUTLINE),
        ALL_ENTRIES_GROUP_ICON(DefaultGroupsFactory.ALL_ENTRIES_GROUP_DEFAULT_ICON),
        GROUP_REGULAR(java.awt.Color.RED, MaterialDesignIcon.SYNC);

        private final List<MaterialDesignIcon> icons;
        private final java.awt.Color color;
        private final String unicode;

        private JabRefIcon(MaterialDesignIcon ... icons) {
            this(DEFAULT_COLOR, icons);
        }

        private JabRefIcon(java.awt.Color color, MaterialDesignIcon ... icons) {
            this.icons = Arrays.asList(icons);
            this.color = color;
            this.unicode = Arrays.stream(icons).map(MaterialDesignIcon::unicode).collect(Collectors.joining());
        }

        public FontBasedIcon getIcon() {
            return new FontBasedIcon(this.unicode, this.color);
        }

        public List<MaterialDesignIcon> getUnderlyingIcons() {
            return this.icons;
        }

        public MaterialDesignIcon getUnderlyingIcon() {
            return this.icons.get(0);
        }

        public FontBasedIcon getSmallIcon() {
            return new FontBasedIcon(this.unicode, this.color, JabRefPreferences.getInstance().getInt("iconSizeSmall"));
        }

        public Node getGraphicNode() {
            return new MaterialDesignIconView(this.icons.get(0));
        }

        public String getCode() {
            return this.unicode;
        }
    }
}

