/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.helper.oauth;

import de.undercouch.citeproc.helper.json.JsonLexer;
import de.undercouch.citeproc.helper.json.JsonParser;
import de.undercouch.citeproc.helper.oauth.OAuth;
import de.undercouch.citeproc.helper.oauth.RequestException;
import de.undercouch.citeproc.helper.oauth.Response;
import de.undercouch.citeproc.helper.oauth.Token;
import de.undercouch.citeproc.helper.oauth.UnauthorizedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;

public class OAuth2
implements OAuth {
    private static final String ACCESS_TOKEN = "access_token";
    private static final String AUTHORIZATION_CODE = "authorization_code";
    private static final String BASIC = "Basic";
    private static final String BEARER = "Bearer";
    private static final String CODE = "code";
    private static final String GRANT_TYPE = "grant_type";
    private static final String REDIRECT_URI = "redirect_uri";
    private static final String UTF8 = "UTF-8";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_CONTENT_LENGTH = "Content-Length";
    private final String consumerKey;
    private final String consumerSecret;
    private final String redirectUri;

    public OAuth2(String consumerKey, String consumerSecret, String redirectUri) {
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.redirectUri = redirectUri;
    }

    @Override
    public Token requestTemporaryCredentials(URL url, OAuth.Method method) throws IOException {
        throw new UnsupportedOperationException("OAuth 2 does not require temporary credentials");
    }

    @Override
    public Token requestTokenCredentials(URL url, OAuth.Method method, Token temporaryCredentials, String verifier) throws IOException {
        String body = "";
        body = body + "grant_type=" + URLEncoder.encode(AUTHORIZATION_CODE, UTF8);
        body = body + "&code=" + URLEncoder.encode(verifier, UTF8);
        body = body + "&redirect_uri=" + URLEncoder.encode(this.redirectUri, UTF8);
        HashMap<String, String> headers = new HashMap<String, String>();
        String encodedUserPass = DatatypeConverter.printBase64Binary((byte[])(this.consumerKey + ":" + this.consumerSecret).getBytes(UTF8));
        headers.put(HEADER_AUTHORIZATION, "Basic " + encodedUserPass);
        Response r = this.request(url, method, null, headers, body);
        try (InputStream is = r.getInputStream();){
            JsonParser parser = new JsonParser(new JsonLexer(new InputStreamReader(is, UTF8)));
            Map<String, Object> obj = parser.parseObject();
            Object at = obj.get(ACCESS_TOKEN);
            if (at == null) {
                Token token = null;
                return token;
            }
            Token token = new Token(at.toString(), at.toString());
            return token;
        }
    }

    @Override
    public Response request(URL url, OAuth.Method method, Token token) throws IOException {
        return this.request(url, method, token, null);
    }

    @Override
    public Response request(URL url, OAuth.Method method, Token token, Map<String, String> additionalHeaders) throws IOException {
        return this.request(url, method, token, additionalHeaders, null);
    }

    private Response request(URL url, OAuth.Method method, Token token, Map<String, String> additionalHeaders, String body) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setInstanceFollowRedirects(true);
        conn.setRequestMethod(method.toString());
        if (additionalHeaders != null) {
            for (Map.Entry<String, String> e : additionalHeaders.entrySet()) {
                conn.setRequestProperty(e.getKey(), e.getValue());
            }
        }
        if (token != null) {
            conn.setRequestProperty(HEADER_AUTHORIZATION, "Bearer " + token.getSecret());
        }
        if (body == null) {
            conn.connect();
        } else {
            byte[] by = body.getBytes();
            conn.setRequestProperty(HEADER_CONTENT_LENGTH, Integer.toString(by.length));
            conn.setUseCaches(false);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            try (OutputStream os = conn.getOutputStream();){
                os.write(by);
                os.flush();
            }
        }
        if (conn.getResponseCode() == 401) {
            throw new UnauthorizedException("Not authorized");
        }
        if (conn.getResponseCode() != 200) {
            throw new RequestException("HTTP request failed with error code: " + conn.getResponseCode());
        }
        return new Response(conn);
    }
}

