/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.io.FileUtils;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.io.IOUtils;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Preconditions;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Strings;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.system.SystemInformation;
import com.microsoft.applicationinsights.internal.util.LocalFileSystemUtils;
import com.microsoft.applicationinsights.internal.util.PropertyHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public final class JniPCConnector {
    public static final String AI_BASE_FOLDER = "AISDK";
    public static final String AI_NATIVE_FOLDER = "native";
    public static final String PROCESS_SELF_INSTANCE_NAME = "__SELF__";
    private static final String BITS_MODEL_64 = "64";
    private static final String NATIVE_LIBRARY_64 = "applicationinsights-core-native-win64.dll";
    private static final String NATIVE_LIBRARY_32 = "applicationinsights-core-native-win32.dll";
    private static String currentInstanceName;

    private static native String getInstanceName(int var0);

    private static native String addCounter(String var0, String var1, String var2);

    private static native double getPerformanceCounterValue(String var0);

    public static boolean initialize() {
        try {
            if (!SystemInformation.INSTANCE.isWindows()) {
                InternalLogger.INSTANCE.error("Jni connector is only used on Windows OS.", new Object[0]);
                return false;
            }
            JniPCConnector.loadNativeLibrary();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable e) {
            try {
                InternalLogger.INSTANCE.error("Failed to load native dll, Windows performance counters will not be used. Please make sure that Visual C++ Redistributable is properly installed: %s.", e.toString());
                return false;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return true;
    }

    public static String addPerformanceCounter(String category, String counter, String instance) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(category), "category must be non-null non empty string.");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(counter), "counter must be non-null non empty string.");
        return JniPCConnector.addCounter(category, counter, instance);
    }

    public static String translateInstanceName(String instanceName) throws Exception {
        if (PROCESS_SELF_INSTANCE_NAME.equals(instanceName)) {
            if (Strings.isNullOrEmpty(currentInstanceName)) {
                throw new Exception("Cannot translate instance name: Unknown current instance name");
            }
            return currentInstanceName;
        }
        return instanceName;
    }

    public static double getValueOfPerformanceCounter(String name) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name must be non-null non empty value.");
        return JniPCConnector.getPerformanceCounterValue(name);
    }

    private static void initNativeCode() {
        int processId = Integer.parseInt(SystemInformation.INSTANCE.getProcessId());
        currentInstanceName = JniPCConnector.getInstanceName(processId);
        if (Strings.isNullOrEmpty(currentInstanceName)) {
            InternalLogger.INSTANCE.error("Failed to fetch current process instance name, process counters for for the process level will not be activated.", new Object[0]);
        } else {
            InternalLogger.INSTANCE.trace("Java process name is set to '%s'", currentInstanceName);
        }
    }

    private static void loadNativeLibrary() throws IOException {
        String model = System.getProperty("sun.arch.data.model");
        String libraryToLoad = BITS_MODEL_64.equals(model) ? NATIVE_LIBRARY_64 : NATIVE_LIBRARY_32;
        File dllPath = JniPCConnector.buildDllLocalPath();
        File dllOnDisk = new File(dllPath, libraryToLoad);
        if (!dllOnDisk.exists()) {
            JniPCConnector.extractToLocalFolder(dllOnDisk, libraryToLoad);
        }
        System.load(dllOnDisk.toString());
        JniPCConnector.initNativeCode();
        InternalLogger.INSTANCE.trace("Successfully loaded library '%s'", libraryToLoad);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractToLocalFolder(File dllOnDisk, String libraryToLoad) throws IOException {
        FileOutputStream out;
        block14: {
            InputStream in = JniPCConnector.class.getClassLoader().getResourceAsStream(libraryToLoad);
            if (in == null) {
                throw new RuntimeException(String.format("Failed to find '%s' in jar", libraryToLoad));
            }
            out = null;
            try {
                out = FileUtils.openOutputStream(dllOnDisk);
                IOUtils.copy(in, (OutputStream)out);
                InternalLogger.INSTANCE.trace("Successfully extracted '%s' to local folder", libraryToLoad);
                if (in == null) break block14;
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        InternalLogger.INSTANCE.error("Failed to close input stream for dll extraction: %s", e.toString());
                    }
                }
                if (out != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException e) {
                        InternalLogger.INSTANCE.error("Failed to close output stream for dll extraction: %s", e.toString());
                    }
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException e) {
                InternalLogger.INSTANCE.error("Failed to close input stream for dll extraction: %s", e.toString());
            }
        }
        if (out != null) {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                InternalLogger.INSTANCE.error("Failed to close output stream for dll extraction: %s", e.toString());
            }
        }
    }

    private static File buildDllLocalPath() {
        Properties properties = PropertyHelper.getSdkVersionProperties();
        if (properties == null) {
            throw new RuntimeException("Failed to find SDK Version Properties file.");
        }
        String version = properties.getProperty("version");
        if (version == null) {
            throw new RuntimeException("Failed to find SDK version.");
        }
        File dllPath = LocalFileSystemUtils.getTempDir();
        dllPath = new File(dllPath.toString(), AI_BASE_FOLDER);
        dllPath = new File(dllPath.toString(), AI_NATIVE_FOLDER);
        if (!(dllPath = new File(dllPath.toString(), version)).exists()) {
            dllPath.mkdirs();
        }
        if (!(dllPath.exists() && dllPath.canRead() && dllPath.canWrite())) {
            throw new RuntimeException("Failed to create a read/write folder for the native dll.");
        }
        InternalLogger.INSTANCE.trace("%s folder exists", dllPath.toString());
        return dllPath;
    }
}

