/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.sampling;

import com.microsoft.applicationinsights.channel.TelemetrySampler;
import com.microsoft.applicationinsights.internal.channel.sampling.FixedRateTelemetrySampler;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.shutdown.SDKShutdownActivity;
import com.microsoft.applicationinsights.internal.shutdown.Stoppable;
import com.microsoft.applicationinsights.internal.util.ThreadPoolUtils;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class AdaptiveTelemetrySampler
implements Stoppable,
TelemetrySampler {
    private static final int DEFAULT_MAX_TELEMETRIES_PER_SECOND = 100;
    private static final int DEFAULT_EVALUATION_INTERVAL_IN_SECONDS = 900;
    private static final int DEFAULT_SAMPLING_PERCENTAGE_DECREASE_TIMEOUT_IN_SECONDS = 120;
    private static final int DEFAULT_SAMPLING_PERCENTAGE_INCREASE_TIMEOUT_IN_SECONDS = 900;
    private static final int DEFAULT_MIN_SAMPLING_PERCENTAGE = 1;
    private static final int DEFAULT_MAX_SAMPLING_PERCENTAGE = 100;
    private static final int DEFAULT_INITIAL_SAMPLING_PERCENTAGE = 100;
    private static final double DEFAULT_MOVING_AVERAGE_RATIO = 0.25;
    private double maxTelemetriesPerSecond;
    private int evaluationIntervalInSec;
    private int samplingPercentageDecreaseTimeoutInSec;
    private int samplingPercentageIncreaseTimeoutInSec;
    private int minSamplingPercentage;
    private int maxSamplingPercentage;
    private double movingAverageRatio = 0.25;
    private double currentSamplingPercentage;
    private Date lastChangedDate;
    private ChangeDirection lastChangeDirection = ChangeDirection.None;
    private final AtomicLong counter = new AtomicLong(0L);
    private ScheduledThreadPoolExecutor threads;
    private final FixedRateTelemetrySampler sampler = new FixedRateTelemetrySampler();

    @Override
    public synchronized void stop(long timeout, TimeUnit timeUnit) {
        ThreadPoolUtils.stop(this.threads, timeout, timeUnit);
    }

    public void initialize(String maxTelemetriesPerSecond, String evaluationIntervalInSeconds, String samplingPercentageDecreaseTimeoutInSeconds, String samplingPercentageIncreaseTimeoutInSeconds, String minSamplingPercentage, String maxSamplingPercentage, String initialSamplingPercentage, String movingAverageRatio) {
        this.maxTelemetriesPerSecond = this.getIntValueOrDefault("maxTelemetriesPerSecond", maxTelemetriesPerSecond, 100, 0, Integer.MAX_VALUE);
        this.evaluationIntervalInSec = this.getIntValueOrDefault("evaluationIntervalInSec", evaluationIntervalInSeconds, 900, 0, Integer.MAX_VALUE);
        this.samplingPercentageDecreaseTimeoutInSec = this.getIntValueOrDefault("samplingPercentageDecreaseTimeoutInSec", samplingPercentageDecreaseTimeoutInSeconds, 120, 0, Integer.MAX_VALUE);
        this.samplingPercentageIncreaseTimeoutInSec = this.getIntValueOrDefault("samplingPercentageIncreaseTimeoutInSec", samplingPercentageIncreaseTimeoutInSeconds, 900, 0, Integer.MAX_VALUE);
        this.minSamplingPercentage = this.getIntValueOrDefault("minSamplingPercentage", minSamplingPercentage, 1, 0, 100);
        this.maxSamplingPercentage = this.getIntValueOrDefault("maxSamplingPercentage", maxSamplingPercentage, 100, 0, 100);
        this.currentSamplingPercentage = this.getDoubleValueOrDefault("initialSamplingPercentage", initialSamplingPercentage, 100.0, 0.0, 100.0);
        this.movingAverageRatio = this.getDoubleValueOrDefault("movingAverageRatio", movingAverageRatio, 0.25, 0.0, 100.0);
        this.createTimerThread();
        this.lastChangedDate = new Date();
        this.sampler.setSamplingPercentage(this.currentSamplingPercentage);
        this.threads.scheduleAtFixedRate(new SamplingRangeEvaluator(), this.evaluationIntervalInSec, this.evaluationIntervalInSec, TimeUnit.SECONDS);
        SDKShutdownActivity.INSTANCE.register(this);
    }

    @Override
    public Set<Class> getExcludeTypes() {
        return this.sampler.getExcludeTypes();
    }

    @Override
    public void setExcludeTypes(String types) {
        this.sampler.setExcludeTypes(types);
    }

    @Override
    public Set<Class> getIncludeTypes() {
        return this.sampler.getIncludeTypes();
    }

    @Override
    public void setIncludeTypes(String types) {
        this.sampler.setIncludeTypes(types);
    }

    @Override
    public Double getSamplingPercentage() {
        return this.sampler.getSamplingPercentage();
    }

    @Override
    public void setSamplingPercentage(Double samplingPercentage) {
        this.sampler.setSamplingPercentage(samplingPercentage);
    }

    @Override
    public boolean isSampledIn(Telemetry telemetry) {
        if (this.sampler.isSampledIn(telemetry)) {
            this.counter.incrementAndGet();
            return true;
        }
        return false;
    }

    private void createTimerThread() {
        this.threads = new ScheduledThreadPoolExecutor(1);
        this.threads.setThreadFactory(ThreadPoolUtils.createDaemonThreadFactory(AdaptiveTelemetrySampler.class));
    }

    private int getIntValueOrDefault(String name, String valueAsString, int defaultValue, int minValue, int maxValue) {
        int result = defaultValue;
        try {
            int value = Integer.valueOf(valueAsString);
            if (value > 0) {
                result = value;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result > maxValue) {
            result = maxValue;
        }
        if (result < minValue) {
            result = minValue;
        }
        InternalLogger.INSTANCE.trace("%s is set to %s", name, defaultValue);
        return result;
    }

    private double getDoubleValueOrDefault(String name, String valueAsString, double defaultValue, double minValue, double maxValue) {
        double result = defaultValue;
        try {
            double value = Double.valueOf(valueAsString);
            if (value > 0.0) {
                result = value;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result > maxValue) {
            result = maxValue;
        }
        if (result < minValue) {
            result = minValue;
        }
        InternalLogger.INSTANCE.trace("%s is set to %s", name, defaultValue);
        return result;
    }

    private class SamplingRangeEvaluator
    implements Runnable {
        private boolean first = true;
        private double average = 0.0;

        private SamplingRangeEvaluator() {
        }

        @Override
        public void run() {
            boolean samplingPercentageChangeNeeded;
            double telemetriesPerSecond = (double)AdaptiveTelemetrySampler.this.counter.get() / (double)AdaptiveTelemetrySampler.this.evaluationIntervalInSec;
            AdaptiveTelemetrySampler.this.counter.set(0L);
            if (!this.first) {
                this.average = this.average * (1.0 - AdaptiveTelemetrySampler.this.movingAverageRatio) + telemetriesPerSecond * AdaptiveTelemetrySampler.this.movingAverageRatio;
            } else {
                this.first = false;
                this.average = telemetriesPerSecond;
            }
            InternalLogger.INSTANCE.trace("Average for sampling is %s", this.average);
            double suggestedSamplingPercentage = this.average > AdaptiveTelemetrySampler.this.maxTelemetriesPerSecond ? 100.0 - (this.average - AdaptiveTelemetrySampler.this.maxTelemetriesPerSecond) * 100.0 / AdaptiveTelemetrySampler.this.maxTelemetriesPerSecond : 100.0;
            if (suggestedSamplingPercentage > (double)AdaptiveTelemetrySampler.this.maxSamplingPercentage) {
                suggestedSamplingPercentage = AdaptiveTelemetrySampler.this.maxSamplingPercentage;
            }
            if (suggestedSamplingPercentage < (double)AdaptiveTelemetrySampler.this.minSamplingPercentage) {
                suggestedSamplingPercentage = AdaptiveTelemetrySampler.this.minSamplingPercentage;
            }
            boolean bl = samplingPercentageChangeNeeded = suggestedSamplingPercentage != AdaptiveTelemetrySampler.this.currentSamplingPercentage;
            if (samplingPercentageChangeNeeded) {
                Date currentDate = new Date();
                long duration = currentDate.getTime() - AdaptiveTelemetrySampler.this.lastChangedDate.getTime();
                long diffInSeconds = TimeUnit.MILLISECONDS.toSeconds(duration);
                if (suggestedSamplingPercentage > AdaptiveTelemetrySampler.this.currentSamplingPercentage) {
                    if (AdaptiveTelemetrySampler.this.lastChangeDirection != ChangeDirection.Up || diffInSeconds >= (long)AdaptiveTelemetrySampler.this.samplingPercentageIncreaseTimeoutInSec) {
                        this.updateSamplingData(suggestedSamplingPercentage, ChangeDirection.Up, currentDate);
                    }
                } else if (AdaptiveTelemetrySampler.this.lastChangeDirection != ChangeDirection.Down || diffInSeconds >= (long)AdaptiveTelemetrySampler.this.samplingPercentageDecreaseTimeoutInSec) {
                    this.updateSamplingData(suggestedSamplingPercentage, ChangeDirection.Down, currentDate);
                }
            }
        }

        private void updateSamplingData(double suggestedSamplingPercentage, ChangeDirection direction, Date currentDate) {
            InternalLogger.INSTANCE.trace("Updating sampling percentage from %s to %s", AdaptiveTelemetrySampler.this.currentSamplingPercentage, suggestedSamplingPercentage);
            AdaptiveTelemetrySampler.this.currentSamplingPercentage = suggestedSamplingPercentage;
            AdaptiveTelemetrySampler.this.lastChangeDirection = direction;
            AdaptiveTelemetrySampler.this.lastChangedDate = currentDate;
            AdaptiveTelemetrySampler.this.sampler.setSamplingPercentage(suggestedSamplingPercentage);
        }
    }

    private static enum ChangeDirection {
        Up,
        Down,
        None;

    }
}

