/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.agent;

import com.microsoft.applicationinsights.agent.internal.coresync.AgentNotificationsHandler;
import com.microsoft.applicationinsights.agent.internal.coresync.impl.ImplementationsCoordinator;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.internal.agent.CoreAgentNotificationsHandler;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.ThreadLocalCleaner;

public enum AgentConnector {
    INSTANCE;

    private String agentKey;
    private RegistrationType registrationType = RegistrationType.NONE;
    private CoreAgentNotificationsHandler coreDataAgent = null;

    public synchronized RegistrationResult register(ClassLoader classLoader, String name) {
        switch (this.registrationType) {
            case NONE: {
                try {
                    this.coreDataAgent = new CoreAgentNotificationsHandler(name);
                    this.agentKey = ImplementationsCoordinator.INSTANCE.register(classLoader, (AgentNotificationsHandler)this.coreDataAgent);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    try {
                        InternalLogger.INSTANCE.error("Could not find Agent: '%s'", ExceptionUtils.getStackTrace(t));
                        this.agentKey = null;
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.registrationType = RegistrationType.WEB;
                return new RegistrationResult(this.agentKey, this.coreDataAgent.getCleaner());
            }
            case WEB: {
                return new RegistrationResult(this.agentKey, this.coreDataAgent.getCleaner());
            }
            case SELF: {
                InternalLogger.INSTANCE.error("Core was already registered by the Agent", new Object[0]);
                return null;
            }
        }
        InternalLogger.INSTANCE.error("Unknown registration type '%s' found", new Object[]{this.registrationType});
        return null;
    }

    public synchronized boolean registerSelf() {
        switch (this.registrationType) {
            case NONE: {
                try {
                    this.coreDataAgent = new CoreAgentNotificationsHandler("app");
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    try {
                        InternalLogger.INSTANCE.error("Could not find Agent: '%s'", ExceptionUtils.getStackTrace(t));
                        return false;
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                ImplementationsCoordinator.INSTANCE.registerSelf((AgentNotificationsHandler)this.coreDataAgent);
                this.registrationType = RegistrationType.SELF;
                return true;
            }
            case WEB: {
                InternalLogger.INSTANCE.error("Core was already registered by the Web module", new Object[0]);
                return false;
            }
            case SELF: {
                InternalLogger.INSTANCE.info("Core was already registered by the Agent, ignored", new Object[0]);
                return true;
            }
        }
        InternalLogger.INSTANCE.error("Unknown registration type '%s' found", new Object[]{this.registrationType});
        return false;
    }

    public static class RegistrationResult {
        private final String key;
        private final ThreadLocalCleaner cleaner;

        public RegistrationResult(String key, ThreadLocalCleaner cleaner) {
            this.key = key;
            this.cleaner = cleaner;
        }

        public String getKey() {
            return this.key;
        }

        public ThreadLocalCleaner getCleaner() {
            return this.cleaner;
        }
    }

    static enum RegistrationType {
        NONE,
        WEB,
        SELF;

    }
}

