/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.Scroller;
import com.impossibl.postgres.protocol.DataRow;
import com.impossibl.postgres.protocol.ResultField;
import java.sql.SQLException;
import java.util.List;

class ListScroller
extends Scroller {
    int currentRowIndex = -1;
    List<DataRow> results;
    List<ResultField> resultFields;
    boolean releaseResults;

    ListScroller(List<ResultField> resultFields, List<DataRow> results, boolean releaseResults) {
        this.resultFields = resultFields;
        this.results = results;
        this.releaseResults = releaseResults;
    }

    void setResults(List<DataRow> results) {
        if (this.results != null) {
            for (DataRow dataRow : this.results) {
                dataRow.release();
            }
        }
        this.results = results;
    }

    @Override
    void close() throws SQLException {
        if (this.releaseResults) {
            this.setResults(null);
        }
    }

    @Override
    List<ResultField> getResultFields() {
        return this.resultFields;
    }

    @Override
    boolean isValidRow() {
        return this.currentRowIndex >= 0 && this.currentRowIndex < this.results.size();
    }

    @Override
    String getCursorName() {
        return null;
    }

    @Override
    int getType() {
        return 1004;
    }

    @Override
    int getConcurrency() {
        return 1007;
    }

    @Override
    int getHoldability() {
        return 2;
    }

    @Override
    int getRow() throws SQLException {
        if (!this.isValidRow()) {
            return 0;
        }
        return this.currentRowIndex + 1;
    }

    @Override
    DataRow getRowData() {
        return this.results.get(this.currentRowIndex);
    }

    @Override
    boolean isBeforeFirst() throws SQLException {
        return !this.results.isEmpty() && this.currentRowIndex == -1;
    }

    @Override
    boolean isAfterLast() throws SQLException {
        return !this.results.isEmpty() && this.currentRowIndex == this.results.size();
    }

    @Override
    boolean isFirst() throws SQLException {
        return !this.results.isEmpty() && this.currentRowIndex == 0;
    }

    @Override
    boolean isLast() throws SQLException {
        return !this.results.isEmpty() && this.currentRowIndex == this.results.size() - 1;
    }

    @Override
    void beforeFirst() throws SQLException {
        this.currentRowIndex = -1;
    }

    @Override
    void afterLast() throws SQLException {
        this.currentRowIndex = this.results.size();
    }

    @Override
    boolean first() throws SQLException {
        return this.absolute(1);
    }

    @Override
    boolean last() throws SQLException {
        return this.absolute(-1);
    }

    @Override
    boolean absolute(int row) throws SQLException {
        if (row < 0) {
            row = this.results.size() + 1 + row;
        }
        this.currentRowIndex = Math.max(-1, Math.min(this.results.size(), row - 1));
        return this.isValidRow();
    }

    @Override
    boolean relative(int rows) throws SQLException {
        this.currentRowIndex = Math.max(-1, Math.min(this.results.size(), this.currentRowIndex + rows));
        return this.isValidRow();
    }

    @Override
    boolean next() throws SQLException {
        return this.relative(1);
    }

    @Override
    boolean previous() throws SQLException {
        return this.relative(-1);
    }

    @Override
    void insert(Object[] updatedRowValues) throws SQLException {
        throw Exceptions.RS_NOT_UPDATABLE;
    }

    @Override
    void update(Object[] updatedRowValues) throws SQLException {
        throw Exceptions.RS_NOT_UPDATABLE;
    }

    @Override
    void delete() throws SQLException {
        throw Exceptions.RS_NOT_UPDATABLE;
    }

    @Override
    void refresh() throws SQLException {
    }
}

