/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.ErrorUtils;
import com.impossibl.postgres.jdbc.PGConnectionImpl;
import com.impossibl.postgres.jdbc.ThreadedHousekeeper;
import com.impossibl.postgres.system.NoticeException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ConnectionUtil {
    private static final String JDBC_APPLICATION_NAME_PARAM = "applicationName";
    private static final String JDBC_CLIENT_ENCODING_PARAM = "clientEncoding";
    private static Logger log = Logger.getLogger(ConnectionUtil.class.getName());
    private static final Pattern URL_PATTERN = Pattern.compile("jdbc:pgsql:(?://((?:[a-zA-Z0-9\\-\\.]+|\\[[0-9a-f\\:]+\\])(?:\\:(?:\\d+))?(?:,(?:[a-zA-Z0-9\\-\\.]+|\\[[0-9a-f\\:]+\\])(?:\\:(?:\\d+))?)*)/)?((?:\\w|-|_)+)(?:[\\?\\&](.*))?");
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("(?:([a-zA-Z0-9\\-\\.]+|\\[[0-9a-f\\:]+\\])(?:\\:(\\d+))?)");

    ConnectionUtil() {
    }

    static PGConnectionImpl createConnection(String url, Properties info, boolean allowHousekeeper) throws SQLException {
        ConnectionSpecifier connSpec = ConnectionUtil.parseURL(url);
        if (connSpec == null) {
            return null;
        }
        SQLException lastException = null;
        Properties settings = ConnectionUtil.buildSettings(connSpec, info);
        ThreadedHousekeeper.Ref housekeeper = null;
        if (allowHousekeeper) {
            boolean enableHousekeeper = true;
            if (settings.getProperty("housekeeper.enabled") != null && !Boolean.parseBoolean(settings.getProperty("housekeeper.enabled"))) {
                enableHousekeeper = false;
            } else if (!Boolean.parseBoolean(settings.getProperty("housekeeper", "true"))) {
                enableHousekeeper = false;
            }
            if (enableHousekeeper) {
                housekeeper = ThreadedHousekeeper.acquire();
            }
        }
        for (InetSocketAddress address : connSpec.getAddresses()) {
            if (address.isUnresolved()) {
                lastException = new SQLException("Connection Error: address '" + address.getHostString() + "' is unresolved");
                continue;
            }
            try {
                PGConnectionImpl conn = new PGConnectionImpl((SocketAddress)address, settings, housekeeper);
                conn.init();
                return conn;
            }
            catch (IOException e) {
                lastException = new SQLException("Connection Error: " + e.getMessage(), e);
            }
            catch (NoticeException e) {
                lastException = ErrorUtils.makeSQLException("Connection Error: ", e.getNotice());
            }
        }
        throw lastException;
    }

    private static Properties buildSettings(ConnectionSpecifier connSpec, Properties connectInfo) {
        Properties settings = new Properties();
        settings.putAll((Map<?, ?>)connSpec.getParameters());
        settings.putAll((Map<?, ?>)connectInfo);
        settings.put("database", connSpec.getDatabase());
        if (settings.getProperty("user") == null) {
            settings.put("user", "");
        }
        if (settings.getProperty("password") == null) {
            settings.put("password", "");
        }
        if (settings.getProperty("application_name") == null && settings.getProperty(JDBC_APPLICATION_NAME_PARAM) != null) {
            settings.put("application_name", settings.getProperty(JDBC_APPLICATION_NAME_PARAM));
        }
        if (settings.getProperty("client_encoding") == null && settings.getProperty(JDBC_CLIENT_ENCODING_PARAM) != null) {
            settings.put("client_encoding", settings.getProperty(JDBC_CLIENT_ENCODING_PARAM));
        }
        settings.put("databaseUrl", "jdbc:pgsql://" + connSpec.getHosts() + "/" + connSpec.getDatabase());
        return settings;
    }

    static ConnectionSpecifier parseURL(String url) {
        try {
            Matcher urlMatcher = URL_PATTERN.matcher(url);
            if (!urlMatcher.matches()) {
                return null;
            }
            ConnectionSpecifier spec = new ConnectionSpecifier();
            String hosts = urlMatcher.group(1);
            if (hosts == null || hosts.isEmpty()) {
                hosts = "localhost";
            }
            Matcher hostsMatcher = ADDRESS_PATTERN.matcher(hosts);
            while (hostsMatcher.find()) {
                String name = hostsMatcher.group(1);
                String port = hostsMatcher.group(2);
                if (port == null || port.isEmpty()) {
                    port = "5432";
                }
                InetSocketAddress address = new InetSocketAddress(name, Integer.parseInt(port));
                spec.addAddress(address);
            }
            spec.setDatabase(urlMatcher.group(2));
            String params = urlMatcher.group(3);
            if (params != null && !params.isEmpty()) {
                for (String nameValue : params.split("&")) {
                    String[] items = nameValue.split("=");
                    if (items.length == 1) {
                        spec.addParameter(items[0], "");
                        continue;
                    }
                    if (items.length != 2) continue;
                    spec.addParameter(items[0], items[1]);
                }
            }
            log.fine("parseURL: " + url + " => " + spec);
            return spec;
        }
        catch (Throwable e) {
            return null;
        }
    }

    static class ConnectionSpecifier {
        private List<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        private String database = null;
        private Properties parameters = new Properties();

        ConnectionSpecifier() {
            this.addresses = new ArrayList<InetSocketAddress>();
            this.parameters = new Properties();
        }

        String getDatabase() {
            return this.database;
        }

        void setDatabase(String v) {
            this.database = v;
        }

        List<InetSocketAddress> getAddresses() {
            return this.addresses;
        }

        void addAddress(InetSocketAddress v) {
            this.addresses.add(v);
        }

        Properties getParameters() {
            return this.parameters;
        }

        void addParameter(String key, String value) {
            this.parameters.put(key, value);
        }

        String getHosts() {
            StringBuilder hosts = new StringBuilder();
            Iterator<InetSocketAddress> addrIter = this.addresses.iterator();
            while (addrIter.hasNext()) {
                InetSocketAddress addr = addrIter.next();
                hosts.append(addr.getHostString());
                if (addr.getPort() != 5432) {
                    hosts.append(':');
                    hosts.append(addr.getPort());
                }
                if (!addrIter.hasNext()) continue;
                hosts.append(",");
            }
            return hosts.toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb = sb.append("ConnectionSpecifier[");
            sb = sb.append("hosts=").append(this.getHosts());
            sb = sb.append(",");
            sb = sb.append("database=").append(this.getDatabase());
            sb = sb.append(",");
            sb = sb.append("parameters=").append(this.getParameters());
            sb = sb.append("]");
            return sb.toString();
        }
    }
}

