/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.datetime.instants;

import com.impossibl.postgres.datetime.TimeZones;
import com.impossibl.postgres.datetime.instants.Instant;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.utils.guava.Strings;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public abstract class InstantBase
implements Instant {
    Instant.Type type;

    protected InstantBase(Instant.Type type) {
        this.type = type;
    }

    @Override
    public Instant.Type getType() {
        return this.type;
    }

    @Override
    public String print(Context context) {
        return this.toString();
    }

    @Override
    public Date toDate() {
        long day = TimeUnit.DAYS.toMillis(1L);
        long millis = this.getMillisLocal() / day * day;
        return new Date(millis -= this.getZoneOffsetMillis());
    }

    @Override
    public Time toTime() {
        long millis = this.getMillisLocal();
        if (this.type == Instant.Type.Timestamp) {
            millis %= TimeUnit.DAYS.toMillis(1L);
        }
        return new Time(millis -= this.getZoneOffsetMillis());
    }

    @Override
    public Timestamp toTimestamp() {
        long micros = this.getMicrosUTC();
        long millis = TimeUnit.MICROSECONDS.toMillis(micros);
        long leftoverMicros = micros - TimeUnit.MILLISECONDS.toMicros(millis);
        Timestamp ts = new Timestamp(millis);
        long nanos = (long)ts.getNanos() + TimeUnit.MICROSECONDS.toNanos(leftoverMicros);
        ts.setNanos((int)nanos);
        return ts;
    }

    public String toString() {
        long millis = TimeUnit.SECONDS.toMillis(TimeUnit.MILLISECONDS.toSeconds(this.getMillisUTC()));
        int micros = (int)(this.getMicrosUTC() - TimeUnit.MILLISECONDS.toMicros(millis));
        if (micros < 0) {
            millis -= 1000L;
            micros += 1000000;
        }
        TimeZone zone = this.getZone() == null ? TimeZones.UTC : this.getZone();
        Calendar cal = Calendar.getInstance(zone);
        cal.setTimeInMillis(millis);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        StringBuilder sb = new StringBuilder(String.format("%04d-%02d-%02d %02d:%02d:%02d", year, month, day, hour, minute, second));
        sb.append('.');
        if (micros > 0) {
            String microString = Integer.toString(micros);
            microString = Strings.padStart(microString, 6, '0');
            char[] nanosChar = new char[microString.length()];
            microString.getChars(0, microString.length(), nanosChar, 0);
            int truncIndex = 5;
            while (nanosChar[truncIndex] == '0') {
                --truncIndex;
            }
            sb.append(nanosChar, 0, truncIndex + 1);
        } else {
            sb.append("000000");
        }
        sb.append(" [");
        if (this.getZone() != null) {
            sb.append(TimeZones.getOffsetZoneID(zone.getRawOffset()));
        } else {
            sb.append("ANY");
        }
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstantBase)) {
            return false;
        }
        InstantBase other = (InstantBase)obj;
        return this.type == other.type;
    }
}

