/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.loader;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.loader.URLResourceData;

public class URLResourceLoader
implements ResourceLoader {
    public static final String SCHEMA_NAME = URLResourceLoader.class.getName();
    private static final Log logger = LogFactory.getLog(URLResourceLoader.class);

    public boolean isSupportedKey(ResourceKey key) {
        return SCHEMA_NAME.equals(key.getSchema());
    }

    public ResourceKey createKey(Object value, Map factoryKeys) throws ResourceKeyCreationException {
        String valueString;
        if (value instanceof URL) {
            return new ResourceKey(SCHEMA_NAME, value, factoryKeys);
        }
        if (value instanceof String && ((valueString = (String)value).indexOf("://") >= 0 || valueString.startsWith("file:/"))) {
            try {
                return new ResourceKey(SCHEMA_NAME, new URL(valueString), factoryKeys);
            }
            catch (MalformedURLException mfue) {
                throw new ResourceKeyCreationException("Malformed value: " + value);
            }
        }
        return null;
    }

    public ResourceKey deriveKey(ResourceKey parent, String path, Map factoryKeys) throws ResourceKeyCreationException {
        if (!this.isSupportedKey(parent)) {
            throw new ResourceKeyCreationException("Assertation: Unsupported parent key type");
        }
        try {
            HashMap map;
            URL url = path != null ? new URL((URL)parent.getIdentifier(), path) : (URL)parent.getIdentifier();
            if (factoryKeys != null) {
                map = new HashMap();
                map.putAll(parent.getFactoryParameters());
                map.putAll(factoryKeys);
            } else {
                map = parent.getFactoryParameters();
            }
            return new ResourceKey(parent.getSchema(), url, map);
        }
        catch (MalformedURLException e) {
            throw new ResourceKeyCreationException("Malformed value: " + path);
        }
    }

    public URL toURL(ResourceKey key) {
        return (URL)key.getIdentifier();
    }

    public ResourceData load(ResourceKey key) throws ResourceLoadingException {
        if (!this.isSupportedKey(key)) {
            throw new ResourceLoadingException("Key format is not recognized.");
        }
        return new URLResourceData(key);
    }

    public String serialize(ResourceKey bundleKey, ResourceKey key) {
        if (key == null) {
            throw new NullPointerException("The ResourceKey can not be null");
        }
        if (!this.isSupportedKey(key)) {
            throw new IllegalArgumentException("Key format is not recognized.");
        }
        if (!(key.getIdentifier() instanceof URL)) {
            throw new IllegalArgumentException("ResourceKey is invalid - identifier is not a URL object");
        }
        logger.debug((Object)"Serializing a Classloader Resource Key...");
        if (key.getParent() != null) {
            logger.warn((Object)("Serializing a Classloader Resource Key which contains a parent: key=[" + bundleKey + "] parent=[" + key.getParent() + "]"));
        }
        URL url = (URL)key.getIdentifier();
        String result = ResourceKeyUtils.createStringResourceKey(key.getSchema().toString(), url.toExternalForm(), key.getFactoryParameters());
        logger.debug((Object)("Serialized Classloader Resource Key: [" + result + "]"));
        return result;
    }

    public ResourceKey deserialize(ResourceKey bundleKey, String stringKey) throws ResourceKeyCreationException {
        ResourceKeyData keyData = ResourceKeyUtils.parse(stringKey);
        if (!SCHEMA_NAME.equals(keyData.getSchema())) {
            throw new ResourceKeyCreationException("Serialized version of key does not contain correct schema");
        }
        try {
            return this.createKey(new URL(keyData.getIdentifier()), keyData.getFactoryParameters());
        }
        catch (MalformedURLException mfue) {
            throw new ResourceKeyCreationException("Malformed value: " + keyData.getIdentifier());
        }
    }

    public boolean isSupportedDeserializer(String data) {
        return SCHEMA_NAME.equals(ResourceKeyUtils.readSchemaFromString(data));
    }
}

