# OSG ArgumentParser specific test procedures.

package require tcl3d

proc bgerror { msg } {
    puts "Error: $msg\n$::errorInfo"
}

# Add the program name (i.e. Tcl script name) as first list entry
# for C/C++ main compatibility.
set argv [linsert $argv 0 $argv0]

# Don't need to specify the number of elements due to the wrapping of the C++ constructor.
osg::ArgumentParser arguments $argv

set appName [arguments getApplicationName]
puts "Application name: $appName"

set appUsage [arguments getApplicationUsage]
$appUsage setApplicationName $appName

# Set description, usage, command line options and keyboard shortcuts.
$appUsage setDescription [format "%s is a program for testing classes ArgumentParser and ApplicationUsage." $appName]

$appUsage setCommandLineUsage [format "%s \[options\] filename ..." $appName]
$appUsage addCommandLineOption "--opt1"       "Command line option 1"
$appUsage addCommandLineOption "--opt2"       "Command line option 2"
$appUsage addCommandLineOption "-h or --help" "Display command line parameters"
$appUsage addCommandLineOption "--help-env"   "Display environmental variables"
$appUsage addCommandLineOption "--help-keys"  "Display keyboard & mouse bindings"
$appUsage addCommandLineOption "--help-all"   "Display command line, env vars and keyboard & mouse bindings."

$appUsage addKeyboardMouseBinding "Key-x"  "Do something with Key-x."
$appUsage addKeyboardMouseBinding "Key-F1" "Do something with Key-F1."

puts "The following options have been specified:"
for { set i 0 } { $i < [llength $argv] } { incr i } {
    # Method get is the wrapped operator [].
    puts [format "    Option %d: isOption: %d <%s>" $i [arguments isOption $i] [arguments get $i]]
}

puts "Testing static methods isOption isString isNumber isBool:"
foreach str { "--help" "-help" "help" "123" "true" "TRUE" } {
    puts [format "%10s %d %d %d %d" $str \
        [osg::ArgumentParser_isOption $str] \
        [osg::ArgumentParser_isString $str] \
        [osg::ArgumentParser_isNumber $str] \
        [osg::ArgumentParser_isBool $str]]
}

puts "[$appUsage writeEnvironmentSettings]"

puts "[$appUsage getDescription]"
puts "Number of options supplied: [arguments getNumArgs]"

set helpAll [expr [arguments find "--help-all"] > 0]

set helpType 0
if { $helpAll || ([arguments find "-h"] > 0) || ([arguments find "--help"] > 0) } {
    set helpType $::osg::ApplicationUsage_COMMAND_LINE_OPTION
}
if { $helpAll || ([arguments find "--help-env"] > 0) } {
    set helpType [expr $helpType | $::osg::ApplicationUsage_ENVIRONMENTAL_VARIABLE]
}
if { $helpAll || ([arguments find "--help-keys"] > 0) } {
    set helpType [expr $helpType | $::osg::ApplicationUsage_KEYBOARD_MOUSE_BINDING]
}

if { $helpType } {
    # Additional overloaded method write returning a string, instead of
    # writing to a C++ iostream.
    puts "[$appUsage write $helpType]"
} else {
    puts "$appName: No command line options specified"
}

puts "Number of options remaining: [arguments getNumArgs]"

arguments reportRemainingOptionsAsUnrecognized
if { [arguments errors] } {
    puts "[arguments writeErrorMessages]"
}

exit 0
