/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.specs.NotSpec;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.TransformedClassPath;
import org.gradle.util.internal.CollectionUtils;

public class DefaultClassPath
implements ClassPath,
Serializable {
    private final ImmutableUniqueList<File> files;

    public static Builder builderWithExactSize(int size) {
        return new Builder(size);
    }

    public static ClassPath of(Iterable<File> files) {
        if (files == null) {
            return EMPTY;
        }
        if (files instanceof Collection) {
            return DefaultClassPath.of((Collection)files);
        }
        ArrayList<File> list = new ArrayList<File>();
        for (File file : files) {
            list.add(file);
        }
        return DefaultClassPath.of(list);
    }

    public static ClassPath of(File ... files) {
        if (files == null || files.length == 0) {
            return EMPTY;
        }
        return DefaultClassPath.of(Arrays.asList(files));
    }

    public static ClassPath of(Collection<File> files) {
        if (files == null || files.isEmpty()) {
            return EMPTY;
        }
        return new DefaultClassPath(ImmutableUniqueList.of(files));
    }

    DefaultClassPath() {
        this(ImmutableUniqueList.empty());
    }

    protected DefaultClassPath(ImmutableUniqueList<File> files) {
        this.files = files;
    }

    public String toString() {
        return this.files.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.files.isEmpty();
    }

    @Override
    public List<URI> getAsURIs() {
        ArrayList<URI> urls = new ArrayList<URI>(this.files.size());
        for (File file : this.files) {
            urls.add(file.toURI());
        }
        return urls;
    }

    @Override
    public List<File> getAsFiles() {
        return this.files;
    }

    @Override
    public URL[] getAsURLArray() {
        URL[] urls = new URL[this.files.size()];
        int i = 0;
        for (File file : this.files) {
            urls[i++] = DefaultClassPath.toURL(file);
        }
        return urls;
    }

    @Override
    public List<URL> getAsURLs() {
        ArrayList<URL> urls = new ArrayList<URL>(this.files.size());
        for (File file : this.files) {
            urls.add(DefaultClassPath.toURL(file));
        }
        return urls;
    }

    private static URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Override
    public ClassPath plus(ClassPath other) {
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        if (other instanceof TransformedClassPath) {
            return ((TransformedClassPath)other).prepend(this);
        }
        return new DefaultClassPath(DefaultClassPath.concat(this.files, other.getAsFiles()));
    }

    @Override
    public ClassPath plus(Collection<File> other) {
        if (other.isEmpty()) {
            return this;
        }
        return new DefaultClassPath(DefaultClassPath.concat(this.files, other));
    }

    @Override
    public ClassPath removeIf(Spec<? super File> filter) {
        List remainingFiles = CollectionUtils.filter(this.files, new NotSpec<File>(filter));
        if (remainingFiles.size() == this.files.size()) {
            return this;
        }
        return DefaultClassPath.of(remainingFiles);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultClassPath other = (DefaultClassPath)obj;
        return this.files.equals(other.files);
    }

    public int hashCode() {
        return this.files.hashCode();
    }

    private static ImmutableUniqueList<File> concat(Collection<File> files1, Collection<File> files2) {
        LinkedHashSet<File> result = new LinkedHashSet<File>();
        result.addAll(files1);
        result.addAll(files2);
        return new ImmutableUniqueList<File>(result);
    }

    protected static final class ImmutableUniqueList<T>
    extends AbstractList<T>
    implements Serializable {
        private static final ImmutableUniqueList<Object> EMPTY = new ImmutableUniqueList(Collections.emptySet());
        private final Object[] asArray;
        private final Set<T> asSet;
        private final int size;

        public static <T> ImmutableUniqueList<T> of(Collection<T> collection) {
            if (collection.isEmpty()) {
                return ImmutableUniqueList.empty();
            }
            Builder<T> builder = new Builder<T>(collection.size());
            for (T element : collection) {
                builder.add(element);
            }
            return builder.build();
        }

        public static <T> Builder<T> builderWithExactSize(int exactSize) {
            return new Builder(exactSize);
        }

        public static <T> ImmutableUniqueList<T> empty() {
            return EMPTY;
        }

        ImmutableUniqueList(Set<T> from) {
            this(from, from.toArray(new Object[0]));
        }

        ImmutableUniqueList(Set<T> set, Object[] array) {
            this.size = array.length;
            this.asArray = array;
            this.asSet = set;
        }

        @Override
        public T get(int index) {
            if (index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            return (T)Cast.uncheckedNonnullCast((Object)this.asArray[index]);
        }

        @Override
        public boolean contains(Object o) {
            return this.asSet.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.asSet.containsAll(c);
        }

        @Override
        public int size() {
            return this.size;
        }

        public static class Builder<T> {
            private final HashSet<T> set;
            private final Object[] array;
            private int inserted;

            public Builder(int size) {
                this.set = new HashSet(size);
                this.array = new Object[size];
                this.inserted = 0;
            }

            public void add(T element) {
                if (this.set.add(element)) {
                    if (this.inserted < this.array.length) {
                        this.array[this.inserted] = element;
                        ++this.inserted;
                    } else {
                        throw new IllegalStateException("Trying to insert more elements than size given!");
                    }
                }
            }

            public ImmutableUniqueList<T> build() {
                return new ImmutableUniqueList<T>(this.set, this.shrinkArray());
            }

            public ImmutableUniqueList<T> buildWithExactSize() {
                assert (this.array.length == this.inserted);
                return new ImmutableUniqueList<T>(this.set, this.array);
            }

            private Object[] shrinkArray() {
                if (this.array.length == this.inserted) {
                    return this.array;
                }
                Object[] newArray = new Object[this.inserted];
                System.arraycopy(this.array, 0, newArray, 0, this.inserted);
                return newArray;
            }
        }
    }

    public static class Builder {
        private final ImmutableUniqueList.Builder<File> uniqueListBuilder;

        public Builder(int exactSize) {
            this.uniqueListBuilder = ImmutableUniqueList.builderWithExactSize(exactSize);
        }

        public void add(File file) {
            this.uniqueListBuilder.add(file);
        }

        public ClassPath build() {
            return new DefaultClassPath(this.uniqueListBuilder.buildWithExactSize());
        }
    }
}

