/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.ui;

import com.nokia.mid.ui.DirectGraphics;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class DirectGraphicsImpl
implements DirectGraphics {
    private static final int TRANS_NONE = 0;
    private static final int TRANS_MIRROR_ROT180 = 1;
    private static final int TRANS_MIRROR = 2;
    private static final int TRANS_ROT180 = 3;
    private static final int TRANS_MIRROR_ROT270 = 4;
    private static final int TRANS_ROT90 = 5;
    private static final int TRANS_ROT270 = 6;
    private static final int TRANS_MIRROR_ROT90 = 7;
    private Graphics g;
    static final int[] val1 = new int[]{0, 255};
    static final int[] val2 = DirectGraphicsImpl.fill(4);
    static final int[] val3 = DirectGraphicsImpl.fill(8);
    static final int[] val4 = DirectGraphicsImpl.fill(16);

    DirectGraphicsImpl(Graphics g) {
        this.g = g;
    }

    public void setARGBColor(int argbColor) {
        this.g._argbColor = argbColor;
        this.g._getAwtGraphics().setColor(new Color(argbColor >>> 16 & 0xFF, argbColor >>> 8 & 0xFF, argbColor & 0xFF, argbColor >>> 24 & 0xFF));
    }

    public void drawImage(Image img, int x, int y, int anchor, int manipulation) {
        this.g.drawRegion(img, 0, 0, img.getWidth(), img.getHeight(), this.midpTransformation(manipulation), x, y, anchor);
    }

    public void drawTriangle(int x1, int y1, int x2, int y2, int x3, int y3, int argbColor) {
        this.drawPolygon(new int[]{x1, x2, x3}, 0, new int[]{y1, y2, y3}, 0, 3, argbColor);
    }

    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3, int argbColor) {
        this.fillPolygon(new int[]{x1, x2, x3}, 0, new int[]{y1, y2, y3}, 0, 3, argbColor);
    }

    public void drawPolygon(int[] xPoints, int xOffset, int[] yPoints, int yOffset, int nPoints, int argbColor) {
        int save = this.g._argbColor;
        this.setARGBColor(argbColor);
        for (int i = 0; i < nPoints; ++i) {
            int j = (i + 1) % nPoints;
            this.g.drawLine(xPoints[xOffset + i], yPoints[yOffset + i], xPoints[xOffset + j], yPoints[yOffset + j]);
        }
        this.setARGBColor(save);
    }

    public void fillPolygon(int[] xPoints, int xOffset, int[] yPoints, int yOffset, int nPoints, int argbColor) {
        int[] x = new int[nPoints];
        int[] y = new int[nPoints];
        System.arraycopy(xPoints, xOffset, x, 0, nPoints);
        System.arraycopy(yPoints, yOffset, y, 0, nPoints);
        int save = this.g._argbColor;
        this.setARGBColor(argbColor);
        if (nPoints == 4 && x[0] == x[3] && x[1] == x[2] && y[0] == y[1] && y[2] == y[3]) {
            this.g.fillRect(x[0], y[0], x[2] - x[0], y[2] - y[0]);
        } else {
            if (this.getAlphaComponent() != 255) {
                // empty if block
            }
            this.g._getAwtGraphics().fillPolygon(x, y, nPoints);
            this.setARGBColor(save);
        }
    }

    public void drawPixels(byte[] pixels, byte[] transparencyMask, int offset, int scanlength, int x, int y, int width, int height, int manipulation, int format) {
        int[] dst = new int[width * height];
        int dstOfs = 0;
        for (int i = 0; i < height; ++i) {
            this.convertTo8888(pixels, transparencyMask, format, offset, dst, dstOfs, width);
            offset += scanlength;
            dstOfs += width;
        }
        this.drawPixels(dst, true, 0, width, x, y, width, height, manipulation, 8888);
    }

    public void drawPixels(int[] pixels, boolean transparency, int offset, int scanlength, int x, int y, int width, int height, int manipulation, int format) {
        if (manipulation != 0) {
            System.err.println("DirectGraphics.drawPixels() Unsupp. manip.: " + manipulation);
        }
        if (format == 888) {
            transparency = false;
        } else if (format != 8888) {
            System.err.println("DirectGraphics.drawPixels() Unsupp. format " + format);
        }
        this.g.drawRGB(pixels, offset, scanlength, x, y, width, height, transparency);
    }

    public void drawPixels(short[] pixels, boolean transparency, int offset, int scanlength, int x, int y, int width, int height, int manipulation, int format) {
        int[] dst = new int[width * height];
        int dstOfs = 0;
        for (int i = 0; i < height; ++i) {
            this.convertTo8888(pixels, format, offset, dst, dstOfs, width);
            offset += scanlength;
            dstOfs += width;
        }
        this.g.drawRGB(dst, 0, width, x, y, width, height, transparency);
    }

    public void getPixels(byte[] pixels, byte[] transparencyMask, int offset, int scanlength, int x, int y, int width, int height, int format) {
        System.err.println("gerPixels(byte...) not supported!");
    }

    public void getPixels(int[] pixels, int offset, int scanlength, int x, int y, int width, int height, int format) {
        int[] dxy = new int[2];
        BufferedImage awtImage = this.g._getAwtImage(dxy);
        PixelGrabber pg = new PixelGrabber(awtImage, x + dxy[0], y + dxy[1], width, height, pixels, offset, scanlength);
        boolean ok = false;
        do {
            try {
                pg.grabPixels(0L);
                ok = true;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (!ok);
    }

    public void getPixels(short[] pixels, int offset, int scanlength, int x, int y, int width, int height, int format) {
        int[] ipixels = new int[width * height];
        this.getPixels(ipixels, 0, width, x, y, width, height, 888);
        int srcOfs = 0;
        for (int i = 0; i < height; ++i) {
            this.convertTo4444(ipixels, 888, srcOfs, pixels, offset, width);
            srcOfs += width;
            offset += scanlength;
        }
    }

    public int getNativePixelFormat() {
        return 8888;
    }

    public int getAlphaComponent() {
        return this.g._argbColor >> 24 & 0xFF;
    }

    private int midpTransformation(int manipulation) {
        switch (manipulation) {
            case 0: {
                return 0;
            }
            case 90: {
                return 5;
            }
            case 180: {
                return 3;
            }
            case 270: {
                return 6;
            }
            case 8192: {
                return 2;
            }
        }
        System.err.println("Nokia (mirror) manipulation constant " + manipulation + " not yet supported");
        return this.midpTransformation(manipulation & 0x1FF);
    }

    static int[] fill(int steps) {
        int[] result = new int[steps];
        int add = 255 / (steps - 1);
        int val = 0;
        for (int i = 0; i < steps; ++i) {
            result[i] = val;
            val += add;
        }
        result[steps - 1] = 255;
        return result;
    }

    private void convertTo8888(short[] src, int format, int srcOffset, int[] dst, int dstOffset, int count) {
        int a = 255;
        for (int i = 0; i < count; ++i) {
            int b;
            int g;
            int r;
            short bi = src[srcOffset++];
            switch (format) {
                case 4444: {
                    a = val4[bi >> 12 & 0xF];
                }
                case 444: {
                    r = val4[bi >> 8 & 0xF];
                    g = val4[bi >> 4 & 0xF];
                    b = val4[bi & 0xF];
                    break;
                }
                default: {
                    System.err.println("convert8888 Unsupp. src format: " + format);
                    return;
                }
            }
            dst[dstOffset++] = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        }
    }

    private void convertTo4444(int[] src, int srcFormat, int srcOffset, short[] dst, int dstOffset, int count) {
        int a = 15;
        for (int i = 0; i < count; ++i) {
            int b;
            int g;
            int r;
            int bi = src[srcOffset++];
            switch (srcFormat) {
                case 8888: {
                    a = bi >> 28 & 0xF;
                }
                case 888: {
                    r = bi >> 20 & 0xF;
                    g = bi >> 12 & 0xF;
                    b = bi >> 4 & 0xF;
                    break;
                }
                default: {
                    System.err.println("conv4444 Unsupported format: " + srcFormat);
                    return;
                }
            }
            dst[dstOffset++] = (short)(a << 12 | r << 8 | g << 4 | b);
        }
    }

    private void convertTo8888(byte[] src, byte[] transparency, int format, int srcOffset, int[] dst, int dstOffset, int count) {
        int a = 255;
        for (int i = 0; i < count; ++i) {
            int b;
            int g;
            int r;
            a = transparency == null ? 255 : transparency[srcOffset];
            int bi = src[srcOffset++];
            switch (format) {
                case 332: {
                    r = val3[bi >> 5 & 7];
                    g = val3[bi >> 2 & 2];
                    b = val2[bi & 3];
                    break;
                }
                case 8: {
                    r = bi;
                    g = bi;
                    b = bi;
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported format: " + format);
                }
            }
            dst[dstOffset++] = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        }
    }
}

