/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.provider.Provider;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.util.internal.GUtil;

public class PathNotationConverter
implements NotationConverter<Object, String> {
    public void describe(DiagnosticsVisitor visitor) {
        visitor.candidate("String or CharSequence instances").example("\"some/path\"");
        visitor.candidate("Boolean values").example("true").example("Boolean.TRUE");
        visitor.candidate("Number values").example("42").example("3.14");
        visitor.candidate("A File instance");
        visitor.candidate("A Closure that returns any supported value.");
        visitor.candidate("A Callable that returns any supported value.");
        visitor.candidate("A Provider that provides any supported value.");
    }

    public static NotationParser<Object, String> parser() {
        return NotationParserBuilder.toType(String.class).noImplicitConverters().allowNullInput().converter((NotationConverter)new PathNotationConverter()).toComposite();
    }

    public void convert(Object notation, NotationConvertResult<? super String> result) throws TypeConversionException {
        if (notation == null) {
            result.converted(null);
        } else if (notation instanceof CharSequence || notation instanceof File || notation instanceof Number || notation instanceof Boolean) {
            result.converted((Object)notation.toString());
        } else if (notation instanceof Callable) {
            Callable callableNotation = (Callable)notation;
            Object called = GUtil.uncheckedCall((Callable)callableNotation);
            this.convert(called, result);
        } else if (notation instanceof Provider) {
            Provider providerNotation = (Provider)notation;
            Object called = providerNotation.get();
            this.convert(called, result);
        }
    }
}

