/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.initialization.ConfigurableIncludedBuild;
import org.gradle.api.initialization.ConfigurableIncludedPluginBuild;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.internal.build.PublicBuildPath;
import org.gradle.internal.composite.DefaultConfigurableIncludedBuild;
import org.gradle.internal.composite.DefaultConfigurableIncludedPluginBuild;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.plugin.management.internal.PluginRequests;

public abstract class IncludedBuildSpec {
    public final File rootDir;

    protected IncludedBuildSpec(File rootDir) {
        this.rootDir = rootDir;
    }

    public abstract BuildDefinition toBuildDefinition(StartParameterInternal var1, PublicBuildPath var2, Instantiator var3);

    public static IncludedBuildSpec includedPluginBuild(File rootDir, Action<? super ConfigurableIncludedPluginBuild> configurer) {
        return new IncludedPluginBuildSpec(rootDir, configurer);
    }

    public static IncludedBuildSpec includedBuild(File rootDir, Action<ConfigurableIncludedBuild> configurer) {
        return new IncludedLibraryBuildSpec(rootDir, configurer);
    }

    private static class IncludedPluginBuildSpec
    extends IncludedBuildSpec {
        private final Action<? super ConfigurableIncludedPluginBuild> configurer;

        private IncludedPluginBuildSpec(File rootDir, Action<? super ConfigurableIncludedPluginBuild> configurer) {
            super(rootDir);
            this.configurer = configurer;
        }

        @Override
        public BuildDefinition toBuildDefinition(StartParameterInternal startParameter, PublicBuildPath publicBuildPath, Instantiator instantiator) {
            DefaultConfigurableIncludedPluginBuild configurable = (DefaultConfigurableIncludedPluginBuild)instantiator.newInstance(DefaultConfigurableIncludedPluginBuild.class, new Object[]{this.rootDir});
            this.configurer.execute((Object)configurable);
            return BuildDefinition.fromStartParameterForBuild(startParameter, configurable.getName(), this.rootDir, PluginRequests.EMPTY, (Action<? super DependencySubstitutions>)ImmutableActionSet.empty(), publicBuildPath, true);
        }
    }

    private static class IncludedLibraryBuildSpec
    extends IncludedBuildSpec {
        private final Action<? super ConfigurableIncludedBuild> configurer;

        private IncludedLibraryBuildSpec(File rootDir, Action<? super ConfigurableIncludedBuild> configurer) {
            super(rootDir);
            this.configurer = configurer;
        }

        @Override
        public BuildDefinition toBuildDefinition(StartParameterInternal startParameter, PublicBuildPath publicBuildPath, Instantiator instantiator) {
            DefaultConfigurableIncludedBuild configurable = (DefaultConfigurableIncludedBuild)instantiator.newInstance(DefaultConfigurableIncludedBuild.class, new Object[]{this.rootDir});
            this.configurer.execute((Object)configurable);
            return BuildDefinition.fromStartParameterForBuild(startParameter, configurable.getName(), this.rootDir, PluginRequests.EMPTY, configurable.getDependencySubstitutionAction(), publicBuildPath, false);
        }
    }
}

