/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.campaign;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Campaign;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class HidetypeToken
extends AbstractTokenWithSeparator<Campaign>
implements CDOMPrimaryToken<Campaign> {
    public String getTokenName() {
        return "HIDETYPE";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, Campaign campaign, String value) {
        ListKey lk = null;
        String types = null;
        if (value.startsWith("EQUIP|")) {
            lk = ListKey.HIDDEN_Equipment;
            types = value.substring(6);
        } else if (value.startsWith("FEAT|")) {
            lk = ListKey.HIDDEN_Ability;
            types = value.substring(5);
        } else if (value.startsWith("SKILL|")) {
            lk = ListKey.HIDDEN_Skill;
            types = value.substring(6);
        }
        if (lk == null) {
            return new ParseResult.Fail(this.getTokenName() + " did not understand: " + value + " in " + campaign.getKeyName(), context);
        }
        StringTokenizer st = new StringTokenizer(types, "|");
        while (st.hasMoreTokens()) {
            context.getObjectContext().addToList((CDOMObject)campaign, lk, (Object)st.nextToken());
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, Campaign campaign) {
        ArrayList<String> returnList = new ArrayList<String>();
        Changes ech = context.getObjectContext().getListChanges((CDOMObject)campaign, ListKey.HIDDEN_Equipment);
        Changes ach = context.getObjectContext().getListChanges((CDOMObject)campaign, ListKey.HIDDEN_Ability);
        Changes sch = context.getObjectContext().getListChanges((CDOMObject)campaign, ListKey.HIDDEN_Skill);
        Collection added = ech.getAdded();
        if (added != null) {
            returnList.add("EQUIP|" + StringUtil.join((Collection)added, (String)"|"));
        }
        if ((added = ach.getAdded()) != null) {
            returnList.add("FEAT|" + StringUtil.join((Collection)added, (String)"|"));
        }
        if ((added = sch.getAdded()) != null) {
            returnList.add("SKILL|" + StringUtil.join((Collection)added, (String)"|"));
        }
        if (returnList.isEmpty()) {
            return null;
        }
        return returnList.toArray(new String[returnList.size()]);
    }

    public Class<Campaign> getTokenClass() {
        return Campaign.class;
    }
}

