/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util.enumeration;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public abstract class AbstractConstant
implements Serializable {
    private transient String _fieldName;

    private void writeObject(ObjectOutputStream out) throws IOException {
        Field[] f = this.getClass().getDeclaredFields();
        for (int i = 0; i < f.length; ++i) {
            try {
                int mod = f[i].getModifiers();
                if (!Modifier.isStatic(mod) || !Modifier.isFinal(mod) || !Modifier.isPublic(mod) || this != f[i].get(null)) continue;
                out.writeObject(f[i].getName());
                continue;
            }
            catch (IllegalAccessException e) {
                throw new IOException(e.getLocalizedMessage());
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException {
        try {
            this._fieldName = (String)in.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public Object readResolve() throws ObjectStreamException {
        try {
            return this.getClass().getField(this._fieldName).get(null);
        }
        catch (SecurityException e) {
            throw new InvalidObjectException("Failed to resolve object: " + e.getLocalizedMessage());
        }
        catch (NoSuchFieldException e) {
            throw new InvalidObjectException("Failed to resolve object: " + e.getLocalizedMessage());
        }
        catch (IllegalAccessException e) {
            throw new InvalidObjectException("Failed to resolve object: " + e.getLocalizedMessage());
        }
    }
}

