/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import pcgen.base.util.DoubleKeyMap;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Categorized;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.reference.ManufacturableFactory;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.SimpleReferenceManufacturer;
import pcgen.cdom.reference.TransparentCategorizedFactory;
import pcgen.cdom.reference.TransparentCategorizedReferenceManufacturer;
import pcgen.cdom.reference.TransparentFactory;
import pcgen.cdom.reference.UnconstructedValidator;
import pcgen.rules.context.AbstractReferenceContext;

public class GameReferenceContext
extends AbstractReferenceContext {
    private final Map<Class<?>, ReferenceManufacturer<?>> map = new HashMap();
    private final DoubleKeyMap<Class<?>, String, TransparentCategorizedReferenceManufacturer<? extends Loadable>> catmap = new DoubleKeyMap();

    @Override
    public <T extends Loadable> ReferenceManufacturer<T> getManufacturer(Class<T> cl) {
        if (Categorized.class.isAssignableFrom(cl)) {
            throw new InternalError(cl + " is categorized but was fetched without a category");
        }
        ReferenceManufacturer<?> mfg = this.map.get(cl);
        if (mfg == null) {
            mfg = new SimpleReferenceManufacturer(new TransparentFactory<T>(cl));
            this.map.put(cl, mfg);
        }
        return mfg;
    }

    public Collection<ReferenceManufacturer<?>> getAllManufacturers() {
        ArrayList returnList = new ArrayList(this.map.values());
        for (Class cl : this.catmap.getKeySet()) {
            returnList.addAll(this.catmap.values((Object)cl));
        }
        return returnList;
    }

    @Override
    public <T extends Categorized<T>> ReferenceManufacturer<T> getManufacturer(Class<T> cl, Class<? extends Category<T>> catClass, String cat) {
        TransparentCategorizedReferenceManufacturer<T> mfg = (TransparentCategorizedReferenceManufacturer<T>)this.catmap.get(cl, (Object)cat);
        if (mfg == null) {
            mfg = new TransparentCategorizedReferenceManufacturer<T>(new TransparentCategorizedFactory<T>(cl, cat), catClass, cat);
            this.catmap.put(cl, (Object)cat, mfg);
        }
        return mfg;
    }

    @Override
    public boolean validate(UnconstructedValidator validator) {
        return true;
    }

    @Override
    public <T extends Categorized<T>> ReferenceManufacturer<T> getManufacturer(Class<T> cl, Category<T> cat) {
        Class<Category<T>> catClass = this.getGenericClass(cat);
        return this.getManufacturer(cl, catClass, cat.getKeyName());
    }

    @Override
    <T extends CDOMObject> T performCopy(T obj, String copyName) {
        throw new UnsupportedOperationException("GameReferenceContext cannot copy objects");
    }

    @Override
    public <T extends CDOMObject> T performMod(T obj) {
        throw new UnsupportedOperationException("GameReferenceContext cannot mod objects");
    }

    @Override
    public <T extends Loadable> boolean hasManufacturer(Class<T> cl) {
        return false;
    }

    @Override
    protected <T extends Categorized<T>> boolean hasManufacturer(Class<T> cl, Category<T> cat) {
        return false;
    }

    @Override
    public <T extends Loadable> ReferenceManufacturer<T> getManufacturer(ManufacturableFactory<T> factory) {
        throw new UnsupportedOperationException("GameReferenceContext cannot provide a factory based manufacturer");
    }
}

