/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.prefs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.GameMode;
import pcgen.core.RuleCheck;
import pcgen.core.SettingsHandler;
import pcgen.gui2.prefs.PCGenPrefsPanel;
import pcgen.gui2.tools.Utility;
import pcgen.system.LanguageBundle;

public class HouseRulesPanel
extends PCGenPrefsPanel {
    private static String in_houseRules = LanguageBundle.getString("in_Prefs_houseRules");
    private final Collection<RuleCheck> ruleCheckList;
    private static final String HOUSE_RULE_STR = "{0} ({1})";
    private JCheckBox[] hrBoxes = null;
    private ButtonGroup[] hrGroup = null;
    private JRadioButton[] hrRadio = null;

    public HouseRulesPanel() {
        boolean aBool;
        JPanel mainPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        Border etched = null;
        TitledBorder title1 = BorderFactory.createTitledBorder(etched, in_houseRules);
        title1.setTitleJustification(1);
        mainPanel.setBorder(title1);
        gridbag = new GridBagLayout();
        mainPanel.setLayout(gridbag);
        c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(2, 2, 2, 2);
        int gridNum = 1;
        GameMode gameMode = SettingsHandler.getGame();
        this.ruleCheckList = gameMode.getModeContext().getReferenceContext().getConstructedCDOMObjects(RuleCheck.class);
        this.hrBoxes = new JCheckBox[this.ruleCheckList.size()];
        int excludeCount = 0;
        int boxNum = 0;
        for (RuleCheck aRule : this.ruleCheckList) {
            aRule.getName();
            String aKey = aRule.getKeyName();
            String aDesc = aRule.getDesc();
            aBool = aRule.getDefault();
            if (aRule.isExclude()) {
                ++excludeCount;
                continue;
            }
            if (SettingsHandler.hasRuleCheck(aKey)) {
                aBool = SettingsHandler.getRuleCheck(aKey);
            }
            this.hrBoxes[boxNum] = new JCheckBox(MessageFormat.format(HOUSE_RULE_STR, aDesc, aKey), aBool);
            this.hrBoxes[boxNum].setActionCommand(aKey);
            Utility.buildConstraints(c, 0, gridNum, 2, 1, 0.0, 0.0);
            gridbag.setConstraints(this.hrBoxes[boxNum], c);
            mainPanel.add(this.hrBoxes[boxNum]);
            ++boxNum;
            ++gridNum;
        }
        this.hrRadio = new JRadioButton[excludeCount];
        int exNum = 0;
        for (RuleCheck aRule : this.ruleCheckList) {
            aRule.getName();
            String aKey = aRule.getKeyName();
            aRule.getDesc();
            aBool = aRule.getDefault();
            if (!aRule.isExclude()) continue;
            this.hrRadio[exNum] = new JRadioButton(aKey);
            this.hrRadio[exNum].setActionCommand(aKey);
            if (SettingsHandler.hasRuleCheck(aKey)) {
                aBool = SettingsHandler.getRuleCheck(aKey);
            }
            this.hrRadio[exNum].setSelected(aBool);
            ++exNum;
        }
        this.hrGroup = new ButtonGroup[excludeCount];
        this.addRulesToPanel(mainPanel, gridbag, gridNum, gameMode);
        Utility.buildConstraints(c, 0, 60, 0, 1, 1.0, 1.0);
        c.fill = 1;
        JLabel label = new JLabel();
        gridbag.setConstraints(label, c);
        mainPanel.add(label);
        this.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "Center");
    }

    private void addRulesToPanel(JPanel mainPanel, GridBagLayout gridbag, int gridNum, GameMode gameMode) {
        int groupNum = 0;
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(2, 2, 2, 2);
        ArrayList<String> doneList = new ArrayList<String>();
        for (int i = 0; i < this.hrRadio.length; ++i) {
            CDOMSingleRef<RuleCheck> excludedRef;
            if (this.hrRadio[i] == null) continue;
            String aKey = this.hrRadio[i].getActionCommand();
            RuleCheck aRule = gameMode.getModeContext().getReferenceContext().silentlyGetConstructedCDOMObject(RuleCheck.class, aKey);
            if (aRule == null || doneList.contains(aKey) || (excludedRef = aRule.getExclude()) != null && doneList.contains(excludedRef.getLSTformat(false))) continue;
            String aDesc = aRule.getDesc();
            this.hrGroup[groupNum] = new ButtonGroup();
            this.hrGroup[groupNum].add(this.hrRadio[i]);
            doneList.add(aKey);
            Utility.buildConstraints(c, 0, gridNum, 3, 1, 0.0, 0.0);
            JPanel subPanel = new JPanel();
            gridbag.setConstraints(subPanel, c);
            subPanel.setLayout(gridbag);
            GridBagConstraints cc = new GridBagConstraints();
            cc.fill = 2;
            cc.insets = new Insets(0, 4, 0, 0);
            Border aBord = BorderFactory.createEtchedBorder();
            subPanel.setBorder(aBord);
            cc.anchor = 21;
            Utility.buildConstraints(cc, 0, 0, 2, 1, 2.0, 0.0);
            this.hrRadio[i].setText(MessageFormat.format(HOUSE_RULE_STR, aDesc, aKey));
            gridbag.setConstraints(this.hrRadio[i], cc);
            subPanel.add(this.hrRadio[i]);
            for (int ii = 0; ii < this.hrRadio.length; ++ii) {
                if (this.hrRadio[i] == null) continue;
                String exKey = this.hrRadio[ii].getActionCommand();
                if (excludedRef == null || !excludedRef.hasBeenResolved() || !exKey.equals(excludedRef.resolvesTo().getKeyName())) continue;
                aRule = excludedRef.resolvesTo();
                aDesc = aRule.getDesc();
                this.hrGroup[groupNum].add(this.hrRadio[ii]);
                doneList.add(excludedRef.getLSTformat(false));
                cc.anchor = 21;
                Utility.buildConstraints(cc, 0, 1, 2, 1, 2.0, 0.0);
                this.hrRadio[ii].setText(MessageFormat.format(HOUSE_RULE_STR, aDesc, exKey));
                gridbag.setConstraints(this.hrRadio[ii], cc);
                subPanel.add(this.hrRadio[ii]);
            }
            mainPanel.add(subPanel);
            ++gridNum;
            ++groupNum;
        }
    }

    @Override
    public String getTitle() {
        return in_houseRules;
    }

    @Override
    public void setOptionsBasedOnControls() {
        boolean aBool;
        String aKey;
        int i;
        GameMode gameMode = SettingsHandler.getGame();
        for (i = 0; i < this.hrBoxes.length; ++i) {
            if (this.hrBoxes[i] == null) continue;
            aKey = this.hrBoxes[i].getActionCommand();
            aBool = this.hrBoxes[i].isSelected();
            if (!gameMode.getModeContext().getReferenceContext().containsConstructedCDOMObject(RuleCheck.class, aKey)) continue;
            SettingsHandler.setRuleCheck(aKey, aBool);
        }
        for (i = 0; i < this.hrRadio.length; ++i) {
            if (this.hrRadio[i] == null) continue;
            aKey = this.hrRadio[i].getActionCommand();
            aBool = this.hrRadio[i].isSelected();
            if (!gameMode.getModeContext().getReferenceContext().containsConstructedCDOMObject(RuleCheck.class, aKey)) continue;
            SettingsHandler.setRuleCheck(aKey, aBool);
        }
    }

    @Override
    public void applyOptionValuesToControls() {
    }
}

