/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.reference;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import pcgen.base.util.ObjectContainer;
import pcgen.cdom.base.PrimitiveCollection;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.primitive.PrimitiveUtilities;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.CDOMSingleRef;

public class FilteredReference<T>
extends CDOMGroupRef<T> {
    private final Set<CDOMSingleRef<? super T>> filterSet = new HashSet<CDOMSingleRef<? super T>>();
    private final ObjectContainer<T> baseSet;

    public FilteredReference(Class<T> objClass, ObjectContainer<T> allRef) {
        super(objClass, "Filtered Reference");
        if (objClass == null) {
            throw new IllegalArgumentException("Class for FilteredReference cannot be null");
        }
        if (allRef == null) {
            throw new IllegalArgumentException("Base Set for FilteredReference cannot be null");
        }
        this.baseSet = allRef;
    }

    public void addProhibitedItem(CDOMSingleRef<? super T> prohibitedRef) {
        if (prohibitedRef == null) {
            throw new IllegalArgumentException("CDOMSingleRef to be added cannot be null");
        }
        Class refClass = prohibitedRef.getReferenceClass();
        if (!this.baseSet.getReferenceClass().isAssignableFrom(refClass)) {
            throw new IllegalArgumentException("CDOMSingleRef to be added " + refClass + " is a different class type than " + this.baseSet.getReferenceClass().getSimpleName());
        }
        this.filterSet.add(prohibitedRef);
    }

    public Class<? super T> getChoiceClass() {
        return this.baseSet.getReferenceClass();
    }

    public int hashCode() {
        return this.baseSet.hashCode() + this.filterSet.size();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilteredReference) {
            FilteredReference other = (FilteredReference)obj;
            return this.baseSet.equals(other.baseSet) && this.filterSet.equals(other.filterSet);
        }
        return false;
    }

    @Override
    public GroupingState getGroupingState() {
        GroupingState state = GroupingState.EMPTY;
        for (PrimitiveCollection primitiveCollection : this.filterSet) {
            state = primitiveCollection.getGroupingState().add(state);
        }
        return this.filterSet.size() == 1 ? state : state.compound(GroupingState.ALLOWS_UNION);
    }

    @Override
    public boolean contains(T item) {
        return this.getContainedObjects().contains(item);
    }

    @Override
    public void addResolution(T item) {
        throw new IllegalStateException("CompoundReference cannot be given a resolution");
    }

    @Override
    public Collection<T> getContainedObjects() {
        HashSet choices = new HashSet();
        choices.addAll(this.baseSet.getContainedObjects());
        Iterator it = choices.iterator();
        block0: while (it.hasNext()) {
            Object choice = it.next();
            for (CDOMSingleRef cDOMSingleRef : this.filterSet) {
                if (!cDOMSingleRef.contains(choice)) continue;
                it.remove();
                continue block0;
            }
        }
        return choices;
    }

    @Override
    public String getLSTformat(boolean useAny) {
        TreeSet sortSet = new TreeSet(PrimitiveUtilities.COLLECTION_SORTER);
        sortSet.addAll(this.filterSet);
        return "ALL|!" + PrimitiveUtilities.joinLstFormat(sortSet, "|!", useAny);
    }

    @Override
    public int getObjectCount() {
        return this.baseSet.getContainedObjects().size() - this.filterSet.size();
    }

    @Override
    public String getChoice() {
        return null;
    }
}

