/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.base;

import pcgen.cdom.base.Categorized;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.ClassIdentity;

public class CategorizedClassIdentity<T extends Categorized<T>>
implements ClassIdentity<T> {
    private final Class<T> underlyingClass;
    private final Category<T> underlyingCategory;

    public CategorizedClassIdentity(Class<T> cl, Category<T> cat) {
        if (cl == null) {
            throw new IllegalArgumentException("Class for BasicClassIdentity cannot be null");
        }
        if (!Categorized.class.isAssignableFrom(cl)) {
            throw new InternalError(cl + " is not categorized but was identified with a category");
        }
        if (cat == null) {
            throw new IllegalArgumentException("Category for BasicClassIdentity cannot be null");
        }
        this.underlyingClass = cl;
        this.underlyingCategory = cat;
    }

    @Override
    public String getName() {
        return this.underlyingClass.getSimpleName();
    }

    @Override
    public Class<T> getChoiceClass() {
        return this.underlyingClass;
    }

    public static <T extends Categorized<T>> ClassIdentity<T> getInstance(Class<T> cl, Category<T> cat) {
        return new CategorizedClassIdentity<T>(cl, cat);
    }

    public Category<T> getCategory() {
        return this.underlyingCategory;
    }
}

