/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.truth.ComparableSubject;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.MathUtil;
import org.jspecify.annotations.Nullable;

public class LongSubject
extends ComparableSubject<Long> {
    private final @Nullable Long actual;

    protected LongSubject(FailureMetadata metadata, @Nullable Long actual) {
        super(metadata, actual);
        this.actual = actual;
    }

    public TolerantLongComparison isWithin(final long tolerance) {
        return new TolerantLongComparison(){

            @Override
            public void of(long expected) {
                Long actual = LongSubject.this.actual;
                Preconditions.checkNotNull((Object)actual, (String)"actual value cannot be null. tolerance=%s expected=%s", (long)tolerance, (long)expected);
                LongSubject.checkTolerance(tolerance);
                if (!MathUtil.equalWithinTolerance(actual, expected, tolerance)) {
                    LongSubject.this.failWithoutActual(Fact.fact("expected", Long.toString(expected)), LongSubject.this.butWas(), Fact.fact("outside tolerance", Long.toString(tolerance)));
                }
            }
        };
    }

    public TolerantLongComparison isNotWithin(final long tolerance) {
        return new TolerantLongComparison(){

            @Override
            public void of(long expected) {
                Long actual = LongSubject.this.actual;
                Preconditions.checkNotNull((Object)actual, (String)"actual value cannot be null. tolerance=%s expected=%s", (long)tolerance, (long)expected);
                LongSubject.checkTolerance(tolerance);
                if (MathUtil.equalWithinTolerance(actual, expected, tolerance)) {
                    LongSubject.this.failWithoutActual(Fact.fact("expected not to be", Long.toString(expected)), LongSubject.this.butWas(), Fact.fact("within tolerance", Long.toString(tolerance)));
                }
            }
        };
    }

    @Override
    @Deprecated
    public final void isEquivalentAccordingToCompareTo(@Nullable Long other) {
        super.isEquivalentAccordingToCompareTo(other);
    }

    private static void checkTolerance(long tolerance) {
        Preconditions.checkArgument((tolerance >= 0L ? 1 : 0) != 0, (String)"tolerance (%s) cannot be negative", (long)tolerance);
    }

    @Override
    public final void isGreaterThan(int other) {
        this.isGreaterThan(Long.valueOf(other));
    }

    @Override
    public final void isLessThan(int other) {
        this.isLessThan(Long.valueOf(other));
    }

    @Override
    public final void isAtMost(int other) {
        this.isAtMost(Long.valueOf(other));
    }

    @Override
    public final void isAtLeast(int other) {
        this.isAtLeast(Long.valueOf(other));
    }

    public static abstract class TolerantLongComparison {
        private TolerantLongComparison() {
        }

        public abstract void of(long var1);

        @Deprecated
        public boolean equals(@Nullable Object o) {
            throw new UnsupportedOperationException("If you meant to compare longs, use .of(long) instead.");
        }

        @Deprecated
        public int hashCode() {
            throw new UnsupportedOperationException("Subject.hashCode() is not supported.");
        }
    }
}

