/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import org.spockframework.runtime.extension.AbstractAnnotationDrivenExtension;
import org.spockframework.runtime.extension.builtin.UnrollNameProvider;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.NameProvider;
import org.spockframework.runtime.model.SpecInfo;
import spock.lang.Unroll;

public class UnrollExtension
extends AbstractAnnotationDrivenExtension<Unroll> {
    @Override
    public void visitSpecAnnotation(Unroll unroll, SpecInfo spec) {
        for (FeatureInfo feature : spec.getFeatures()) {
            if (!feature.isParameterized()) continue;
            this.visitFeatureAnnotation(unroll, feature);
        }
    }

    @Override
    public void visitFeatureAnnotation(Unroll unroll, FeatureInfo feature) {
        if (!feature.isParameterized()) {
            return;
        }
        feature.setReportIterations(true);
        feature.setIterationNameProvider(this.chooseNameProvider(unroll, feature));
    }

    private NameProvider<IterationInfo> chooseNameProvider(Unroll unroll, FeatureInfo feature) {
        if (unroll.value().length() > 0) {
            return new UnrollNameProvider(feature, unroll.value());
        }
        if (feature.getName().contains("#")) {
            return new UnrollNameProvider(feature, feature.getName());
        }
        return null;
    }
}

