/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.report;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import jrm.locale.Messages;
import jrm.misc.HTMLRenderer;
import jrm.misc.Settings;
import jrm.profile.Profile;
import jrm.profile.data.Anyware;
import jrm.profile.report.FilterOptions;
import jrm.profile.report.Subject;
import jrm.profile.report.SubjectSet;
import jrm.ui.profile.report.ReportTreeModel;
import jrm.ui.progress.StatusHandler;
import one.util.streamex.IntStreamEx;

public class Report
implements TreeNode,
HTMLRenderer {
    private Profile profile;
    private final List<Subject> subjects;
    private final Map<String, Subject> subject_hash;
    public final Stats stats;
    private ReportTreeModel model = null;
    private FilterPredicate filterPredicate = new FilterPredicate(new ArrayList<FilterOptions>());
    private StatusHandler statusHandler = null;
    private final Map<Integer, Subject> insert_object_cache = Collections.synchronizedMap(new LinkedHashMap(250));

    public Report() {
        this.subjects = Collections.synchronizedList(new ArrayList());
        this.subject_hash = Collections.synchronizedMap(new HashMap());
        this.stats = new Stats();
        this.model = new ReportTreeModel(this);
        this.model.initClone();
    }

    private Report(Report report, List<FilterOptions> filterOptions) {
        this.filterPredicate = new FilterPredicate(filterOptions);
        this.model = report.model;
        this.profile = report.profile;
        this.subjects = report.filter(filterOptions);
        this.subject_hash = this.subjects.stream().collect(Collectors.toMap(Subject::getWareName, Function.identity(), (o, n) -> null));
        this.stats = report.stats;
    }

    public Report clone(List<FilterOptions> filterOptions) {
        return new Report(this, filterOptions);
    }

    public List<Subject> filter(List<FilterOptions> filterOptions) {
        this.filterPredicate = new FilterPredicate(filterOptions);
        return this.subjects.stream().filter(this.filterPredicate).map(s -> s.clone(filterOptions)).collect(Collectors.toList());
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
        this.reset();
    }

    public void reset() {
        this.subject_hash.clear();
        this.subjects.clear();
        this.insert_object_cache.clear();
        this.stats.clear();
        if (this.model != null) {
            this.model.filter(this.filterPredicate.filterOptions);
        }
        this.flush();
    }

    public void setStatusHandler(StatusHandler handler) {
        this.statusHandler = handler;
    }

    public ReportTreeModel getModel() {
        return this.model;
    }

    public Subject findSubject(Anyware ware) {
        return ware != null ? this.subject_hash.get(ware.getFullName()) : null;
    }

    public Subject findSubject(Anyware ware, Subject def) {
        if (ware != null) {
            if (this.subject_hash.containsKey(ware.getFullName())) {
                return this.subject_hash.get(ware.getFullName());
            }
            this.add(def);
            return def;
        }
        return null;
    }

    public synchronized boolean add(Subject subject) {
        subject.parent = this;
        if (subject.ware != null) {
            this.subject_hash.put(subject.ware.getFullName(), subject);
        }
        boolean result = this.subjects.add(subject);
        Report clone = (Report)this.model.getRoot();
        if (this != clone) {
            subject.updateStats();
            if (this.filterPredicate.test(subject)) {
                Subject cloned_subject = subject.clone(this.filterPredicate.filterOptions);
                clone.add(cloned_subject);
                this.insert_object_cache.put(clone.subjects.size() - 1, cloned_subject);
                if (this.insert_object_cache.size() >= 250) {
                    this.flush();
                }
            }
        }
        return result;
    }

    public synchronized void flush() {
        if (this.statusHandler != null) {
            this.statusHandler.setStatus(this.stats.getStatus());
        }
        if (this.insert_object_cache.size() > 0) {
            TreeModelEvent event = new TreeModelEvent((Object)this.model, this.model.getPathToRoot((Report)this.model.getRoot()), IntStreamEx.of(this.insert_object_cache.keySet()).toArray(), this.insert_object_cache.values().toArray());
            for (TreeModelListener l : this.model.getTreeModelListeners()) {
                l.treeNodesInserted(event);
            }
        }
        this.insert_object_cache.clear();
    }

    public void write() {
        File workdir = Settings.getWorkPath().toFile();
        File reportdir = new File(workdir, "reports");
        reportdir.mkdirs();
        File report_file = new File(reportdir, "report.log");
        try (PrintWriter report_w = new PrintWriter(report_file);){
            this.subjects.forEach(subject -> {
                report_w.println(subject);
                subject.notes.forEach(note -> report_w.println("\t" + note));
            });
            report_w.println();
            report_w.println(String.format(Messages.getString("Report.MissingSets"), this.stats.missing_set_cnt, this.profile.machines_cnt));
            report_w.println(String.format(Messages.getString("Report.MissingRoms"), this.stats.missing_roms_cnt, this.profile.roms_cnt));
            report_w.println(String.format(Messages.getString("Report.MissingDisks"), this.stats.missing_disks_cnt, this.profile.disks_cnt));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.subjects.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.subjects.size();
    }

    @Override
    public TreeNode getParent() {
        return null;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.subjects.indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public Enumeration<Subject> children() {
        return Collections.enumeration(this.subjects);
    }

    class FilterPredicate
    implements Predicate<Subject> {
        List<FilterOptions> filterOptions;

        public FilterPredicate(List<FilterOptions> filterOptions) {
            this.filterOptions = filterOptions;
        }

        @Override
        public boolean test(Subject t) {
            if (!this.filterOptions.contains((Object)FilterOptions.SHOWOK) && t instanceof SubjectSet && ((SubjectSet)t).isOK()) {
                return false;
            }
            return !this.filterOptions.contains((Object)FilterOptions.HIDEMISSING) || !(t instanceof SubjectSet) || !((SubjectSet)t).isMissing();
        }
    }

    public class Stats {
        public int missing_set_cnt = 0;
        public int missing_roms_cnt = 0;
        public int missing_disks_cnt = 0;
        public int missing_samples_cnt = 0;
        public int set_unneeded = 0;
        public int set_missing = 0;
        public int set_found = 0;
        public int set_found_ok = 0;
        public int set_found_fixpartial = 0;
        public int set_found_fixcomplete = 0;
        public int set_create = 0;
        public int set_create_partial = 0;
        public int set_create_complete = 0;

        public void clear() {
            this.missing_set_cnt = 0;
            this.missing_roms_cnt = 0;
            this.missing_disks_cnt = 0;
            this.missing_samples_cnt = 0;
            this.set_unneeded = 0;
            this.set_missing = 0;
            this.set_found = 0;
            this.set_found_ok = 0;
            this.set_found_fixpartial = 0;
            this.set_found_fixcomplete = 0;
            this.set_create = 0;
            this.set_create_partial = 0;
            this.set_create_complete = 0;
        }

        public String getStatus() {
            return String.format(Messages.getString("Report.Status"), this.set_found, this.set_found_ok, this.set_found_fixpartial, this.set_found_fixcomplete, this.set_create, this.set_create_partial, this.set_create_complete, this.set_missing, this.set_unneeded, this.set_found + this.set_create, this.set_found + this.set_create + this.set_missing);
        }
    }
}

