/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.ASeq;
import clojure.lang.Counted;
import clojure.lang.IHashEq;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentList;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.Murmur3;
import clojure.lang.Obj;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import clojure.lang.Sequential;
import clojure.lang.Util;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PersistentQueue
extends Obj
implements IPersistentList,
Collection,
Counted,
IHashEq {
    public static final PersistentQueue EMPTY = new PersistentQueue(null, 0, null, null);
    final int cnt;
    final ISeq f;
    final PersistentVector r;
    int _hash;
    int _hasheq;

    PersistentQueue(IPersistentMap meta, int cnt, ISeq f, PersistentVector r) {
        super(meta);
        this.cnt = cnt;
        this.f = f;
        this.r = r;
    }

    @Override
    public boolean equiv(Object obj) {
        if (!(obj instanceof Sequential)) {
            return false;
        }
        ISeq ms = RT.seq(obj);
        ISeq s = this.seq();
        while (s != null) {
            if (ms == null || !Util.equiv(s.first(), ms.first())) {
                return false;
            }
            s = s.next();
            ms = ms.next();
        }
        return ms == null;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Sequential)) {
            return false;
        }
        ISeq ms = RT.seq(obj);
        ISeq s = this.seq();
        while (s != null) {
            if (ms == null || !Util.equals(s.first(), ms.first())) {
                return false;
            }
            s = s.next();
            ms = ms.next();
        }
        return ms == null;
    }

    @Override
    public int hashCode() {
        int hash2 = this._hash;
        if (hash2 == 0) {
            hash2 = 1;
            for (ISeq s = this.seq(); s != null; s = s.next()) {
                hash2 = 31 * hash2 + (s.first() == null ? 0 : s.first().hashCode());
            }
            this._hash = hash2;
        }
        return hash2;
    }

    @Override
    public int hasheq() {
        int cached = this._hasheq;
        if (cached == 0) {
            this._hasheq = cached = Murmur3.hashOrdered(this);
        }
        return cached;
    }

    @Override
    public Object peek() {
        return RT.first(this.f);
    }

    @Override
    public PersistentQueue pop() {
        if (this.f == null) {
            return this;
        }
        ISeq f1 = this.f.next();
        PersistentVector r1 = this.r;
        if (f1 == null) {
            f1 = RT.seq(this.r);
            r1 = null;
        }
        return new PersistentQueue(this.meta(), this.cnt - 1, f1, r1);
    }

    @Override
    public int count() {
        return this.cnt;
    }

    @Override
    public ISeq seq() {
        if (this.f == null) {
            return null;
        }
        return new Seq(this.f, RT.seq(this.r));
    }

    @Override
    public PersistentQueue cons(Object o) {
        if (this.f == null) {
            return new PersistentQueue(this.meta(), this.cnt + 1, RT.list(o), null);
        }
        return new PersistentQueue(this.meta(), this.cnt + 1, this.f, (this.r != null ? this.r : PersistentVector.EMPTY).cons(o));
    }

    @Override
    public IPersistentCollection empty() {
        return EMPTY.withMeta(this.meta());
    }

    @Override
    public PersistentQueue withMeta(IPersistentMap meta) {
        return new PersistentQueue(meta, this.cnt, this.f, this.r);
    }

    @Override
    public Object[] toArray() {
        return RT.seqToArray(this.seq());
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection c) {
        for (Object o : c) {
            if (!this.contains(o)) continue;
            return true;
        }
        return false;
    }

    public Object[] toArray(Object[] a) {
        return RT.seqToPassedArray(this.seq(), a);
    }

    @Override
    public int size() {
        return this.count();
    }

    @Override
    public boolean isEmpty() {
        return this.count() == 0;
    }

    @Override
    public boolean contains(Object o) {
        for (ISeq s = this.seq(); s != null; s = s.next()) {
            if (!Util.equiv(s.first(), o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            private ISeq fseq;
            private final Iterator riter;
            {
                this.fseq = PersistentQueue.this.f;
                this.riter = PersistentQueue.this.r != null ? PersistentQueue.this.r.iterator() : null;
            }

            @Override
            public boolean hasNext() {
                return this.fseq != null && this.fseq.seq() != null || this.riter != null && this.riter.hasNext();
            }

            public Object next() {
                if (this.fseq != null) {
                    Object ret = this.fseq.first();
                    this.fseq = this.fseq.next();
                    return ret;
                }
                if (this.riter != null && this.riter.hasNext()) {
                    return this.riter.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static class Seq
    extends ASeq {
        final ISeq f;
        final ISeq rseq;

        Seq(ISeq f, ISeq rseq2) {
            this.f = f;
            this.rseq = rseq2;
        }

        Seq(IPersistentMap meta, ISeq f, ISeq rseq2) {
            super(meta);
            this.f = f;
            this.rseq = rseq2;
        }

        @Override
        public Object first() {
            return this.f.first();
        }

        @Override
        public ISeq next() {
            ISeq f1 = this.f.next();
            ISeq r1 = this.rseq;
            if (f1 == null) {
                if (this.rseq == null) {
                    return null;
                }
                f1 = this.rseq;
                r1 = null;
            }
            return new Seq(f1, r1);
        }

        @Override
        public int count() {
            return RT.count(this.f) + RT.count(this.rseq);
        }

        @Override
        public Seq withMeta(IPersistentMap meta) {
            return new Seq(meta, this.f, this.rseq);
        }
    }
}

