/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.util.Arrays;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;

public class AttributeStack {
    private static final String[] LOCAL_NAMES = new String[]{"audience", "platform", "product", "otherprops", "rev", "props", "linking", "toc", "print", "search", "format", "scope", "type", "dir", "translate", "processing-role", "cascade", "lang", "deliveryTarget", "subjectrefs"};
    private static final String[] NAMESPACES = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "http://www.w3.org/XML/1998/namespace", "", ""};
    private String[] stack;
    private final String[] localNames;
    private final String[] namespaces;
    private final int attributeCount;
    private final int[] localNameHashes;
    private final int[] namespaceHashes;
    private int top = -1;

    public AttributeStack() {
        this(NAMESPACES, LOCAL_NAMES);
    }

    public AttributeStack(String ... localNames) {
        this((String[])Stream.generate(() -> "").limit(localNames.length).toArray(String[]::new), (String[])localNames.clone());
    }

    public AttributeStack(QName ... qNames) {
        this((String[])Stream.of(qNames).map(QName::getNamespaceURI).toArray(String[]::new), (String[])Stream.of(qNames).map(QName::getLocalPart).toArray(String[]::new));
    }

    private AttributeStack(String[] namespaces, String[] localNames) {
        if (namespaces.length != localNames.length) {
            throw new IllegalArgumentException("namespaces and localNames must have same length: %s != %s".formatted(namespaces.length, localNames.length));
        }
        this.localNames = localNames;
        this.namespaces = namespaces;
        this.attributeCount = localNames.length;
        this.localNameHashes = new int[this.attributeCount];
        this.namespaceHashes = new int[this.attributeCount];
        for (int i = 0; i < this.attributeCount; ++i) {
            this.localNameHashes[i] = this.localNames[i].hashCode();
            this.namespaceHashes[i] = this.namespaces[i].hashCode();
        }
        this.stack = new String[16 * this.attributeCount];
    }

    public void push(Attributes attrs) {
        ++this.top;
        if ((this.top + 1) * this.attributeCount > this.stack.length) {
            this.stack = Arrays.copyOf(this.stack, this.stack.length * 2);
        }
        int baseIndex = this.top * this.attributeCount;
        for (int i = 0; i < this.attributeCount; ++i) {
            String value = attrs.getValue(this.namespaces[i], this.localNames[i]);
            if (value == null && this.top > 0) {
                value = this.stack[(this.top - 1) * this.attributeCount + i];
            }
            this.stack[baseIndex + i] = value;
        }
    }

    public String peek(String localName) {
        return this.peek("", localName);
    }

    public String peek(String namespace, String localName) {
        if (this.top < 0) {
            throw new IllegalStateException("Stack is empty");
        }
        int nameHash = localName.hashCode();
        int namespaceHash = namespace.hashCode();
        for (int i = 0; i < this.attributeCount; ++i) {
            if (nameHash != this.localNameHashes[i] || namespaceHash != this.namespaceHashes[i] || !localName.equals(this.localNames[i]) || !namespace.equals(this.namespaces[i])) continue;
            return this.stack[this.top * this.attributeCount + i];
        }
        throw new IllegalArgumentException("Stack not initialized for attribute {%s}%s".formatted(namespace, localName));
    }

    public void pop() {
        if (this.top < 0) {
            throw new IllegalStateException("Stack is empty");
        }
        int baseIndex = this.top * this.attributeCount;
        Arrays.fill(this.stack, baseIndex, baseIndex + this.attributeCount, null);
        --this.top;
    }

    public void clear() {
        this.top = -1;
    }
}

